package com.hand.app.electronicSignature.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.hand.app.electronicSignature.dto.EleSignVerify;
import com.hand.app.electronicSignature.service.IElectronicSignatureVerify;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import constant.APIToolKitException;
import org.springframework.stereotype.Service;
import request.Tx2001Request;
import request.Tx2002Request;
import request.Tx2003Request;
import request.Tx2004Request;
import request.Tx2005Request;
import service.SignAPI;
import util.StringUtil;

@Service
public class ElectronicSignatureVerifyImpl extends BaseServiceImpl<EleSignVerify> implements IElectronicSignatureVerify {

    //实名认证（银行卡四要素）
    public JSONObject bankVerified(EleSignVerify param) throws Exception {
        JSONObject returnJson = new JSONObject();
        try {
            Tx2001Request tx2001Request = new Tx2001Request();
            tx2001Request.setPersonName(param.getPersonName());
            tx2001Request.setIdType("0");
            tx2001Request.setIdentificationNumber(param.getIdentificationNumber());
            tx2001Request.setBankCardNumber(param.getBankCardNumber());
            tx2001Request.setBankReservedPhoneNumber(param.getBankReservedPhoneNumber());
            String response = SignAPI.sendMessageAndGetResult(tx2001Request);
            returnJson.put("ResponseCode", StringUtil.getNodeText(response, "ResponseCode"));
            returnJson.put("ResponseDesc", StringUtil.getNodeText(response, "ResponseDesc"));
            returnJson.put("authResult", StringUtil.getNodeText(response, "authResult"));
            returnJson.put("txId", StringUtil.getNodeText(response, "TxID"));
        } catch (APIToolKitException e) {
            e.printStackTrace();
        }
        return returnJson;
    }

    //实名认证(人脸)
    public JSONObject faceVerified(JSONObject param) throws Exception {
        JSONObject returnJson = new JSONObject();
        try {
            Tx2002Request tx2002Request = new Tx2002Request();
            tx2002Request.setPersonName(param.getString("personName"));
            tx2002Request.setIdType("0");
            tx2002Request.setIdentificationNumber(param.getString("identificationNumber"));
            tx2002Request.setIdentificationImage(param.getString("identificationImage"));
            tx2002Request.setSelfieData(param.getString("selfieData"));
            String response = SignAPI.sendMessageAndGetResult(tx2002Request);
            returnJson.put("ResponseCode", StringUtil.getNodeText(response, "ResponseCode"));
            returnJson.put("ResponseDesc", StringUtil.getNodeText(response, "ResponseDesc"));
            returnJson.put("selfieVerifyCode", StringUtil.getNodeText(response, "selfieVerifyCode"));
            returnJson.put("selfieVerifyInfo", StringUtil.getNodeText(response, "selfieVerifyInfo"));
            returnJson.put("selfieCompareWithIdCode", StringUtil.getNodeText(response, "selfieCompareWithIdCode"));
            returnJson.put("selfieCompareWithIdInfo", StringUtil.getNodeText(response, "selfieCompareWithIdInfo"));
            returnJson.put("txId", StringUtil.getNodeText(response, "TxID"));
        } catch (APIToolKitException e) {
            e.printStackTrace();
        }
        return returnJson;
    }

   //2003获取实名认证地址(人脸识别H5)
    public JSONObject getVerifyAddress(EleSignVerify param) throws Exception {
        JSONObject returnJson = new JSONObject();
        try {
            Tx2003Request tx2003Request = new Tx2003Request();
            tx2003Request.setRedirectUrl(param.getRedirectUrl());
            String response = SignAPI.sendMessageAndGetResult(tx2003Request);
            returnJson.put("ResponseCode", StringUtil.getNodeText(response, "ResponseCode"));
            returnJson.put("ResponseDesc", StringUtil.getNodeText(response, "ResponseDesc"));
            returnJson.put("url", StringUtil.getNodeText(response, "url"));
            returnJson.put("bizToken", StringUtil.getNodeText(response, "bizToken"));
            returnJson.put("txId", StringUtil.getNodeText(response, "TxID"));
        } catch (APIToolKitException e) {
            e.printStackTrace();
        }
        return returnJson;
    }

   //2004获取实名认证结果(人脸识别H5)
    public JSONObject getVerifyResult(EleSignVerify param) throws Exception {
        JSONObject returnJson = new JSONObject();
        try {
            Tx2004Request tx2004Request = new Tx2004Request();
            tx2004Request.setBizToken(param.getBizToken());
            String response = SignAPI.sendMessageAndGetResult(tx2004Request);
            returnJson.put("ResponseCode", StringUtil.getNodeText(response, "ResponseCode"));
            returnJson.put("ResponseDesc", StringUtil.getNodeText(response, "ResponseDesc"));
            JSONObject str = JSONObject.parseObject(StringUtil.getNodeText(response, "detectInfo"));
            returnJson.put("detectInfo", str);
            returnJson.put("txId", StringUtil.getNodeText(response, "TxID"));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return returnJson;
    }

    //2005OCR文字识别
//    public JSONObject ocrTextIdentify(JSONObject param) throws Exception {
//        JSONObject returnJson = new JSONObject();
//        try {
//            Tx2005Request tx2005Request = new Tx2005Request();
//            tx2005Request.setIdType(param.getString("idType"));
//            String response = SignAPI.sendMessageAndGetResult(tx2005Request);
//            returnJson.put("ResponseCode", StringUtil.getNodeText(response, "ResponseCode"));
//            returnJson.put("ResponseDesc", StringUtil.getNodeText(response, "ResponseDesc"));
//            returnJson.put("detectInfo", StringUtil.getNodeText(response, "detectInfo"));
//            returnJson.put("txId", StringUtil.getNodeText(response, "TxID"));
//        } catch (APIToolKitException e) {
//            e.printStackTrace();
//        }
//        return returnJson;
//    }
}
