package com.hand.app.electronicSignature.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.hand.app.electronicSignature.dto.EleSignSeal;
import com.hand.app.electronicSignature.service.IElectronicSignatureSeal;
import com.hand.app.electronicSignature.mapper.EleSignSealMapper;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import constant.APIToolKitException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import request.Tx1003Request;
import request.Tx1004Request;
import request.Tx1005Request;
import request.Tx1006Request;
import service.SignAPI;
import util.StringUtil;

@Service
public class ElectronicSignatureSealImpl extends BaseServiceImpl<EleSignSeal> implements IElectronicSignatureSeal {

    //增加印章
    public JSONObject addSeal(JSONObject param) throws Exception {
        JSONObject returnJson = new JSONObject();
        try {
            Tx1003Request tx1003Request = new Tx1003Request();
            tx1003Request.setUserId(param.getString("userId"));
            tx1003Request.setImageData(param.getString("imageData"));
            String response = SignAPI.sendMessageAndGetResult(tx1003Request);
            returnJson.put("ResponseCode", StringUtil.getNodeText(response, "ResponseCode"));
            returnJson.put("ResponseDesc", StringUtil.getNodeText(response, "ResponseDesc"));
            returnJson.put("sealId", StringUtil.getNodeText(response, "sealId"));
            returnJson.put("txId", StringUtil.getNodeText(response, "TxID"));
        } catch (APIToolKitException e) {
            e.printStackTrace();
        }
        return returnJson;
    }

    //删除印章
    public JSONObject deleteSeal(EleSignSeal param) throws Exception {
        JSONObject returnJson = new JSONObject();
        try {
            Tx1004Request tx1004Request = new Tx1004Request();
            tx1004Request.setUserId(param.getUserId());
            tx1004Request.setSealId(param.getSealId());
            String response = SignAPI.sendMessageAndGetResult(tx1004Request);
            returnJson.put("ResponseCode", StringUtil.getNodeText(response, "ResponseCode"));
            returnJson.put("txId", StringUtil.getNodeText(response, "TxID"));
            returnJson.put("ResponseDesc", StringUtil.getNodeText(response, "ResponseDesc"));
        } catch (APIToolKitException e) {
            e.printStackTrace();
        }
        return returnJson;
    }

    //1005修改印章
    public JSONObject alterSeal(JSONObject param) throws Exception {
        JSONObject returnJson = new JSONObject();
        try {
            Tx1005Request tx1005Request = new Tx1005Request();
            tx1005Request.setSealId(param.getString("sealId"));
            tx1005Request.setUserId(param.getString("userId"));
            tx1005Request.setImageData(param.getString("imageData"));
            String response = SignAPI.sendMessageAndGetResult(tx1005Request);
            returnJson.put("ResponseCode", StringUtil.getNodeText(response, "ResponseCode"));
            returnJson.put("txId", StringUtil.getNodeText(response, "TxID"));
            returnJson.put("ResponseDesc", StringUtil.getNodeText(response, "ResponseDesc"));
        } catch (APIToolKitException e) {
            e.printStackTrace();
        }
        return returnJson;
    }

    //1006查询印章
    public JSONObject querySeal(EleSignSeal param) throws Exception {
        JSONObject returnJson = new JSONObject();
        try {
            Tx1006Request tx1006Request = new Tx1006Request();
//            tx1006Request.setSealId(param.getSealId());
            tx1006Request.setUserId(param.getUserId());
            String response = SignAPI.sendMessageAndGetResult(tx1006Request);
            returnJson.put("ResponseCode", StringUtil.getNodeText(response, "ResponseCode"));
            returnJson.put("txId", StringUtil.getNodeText(response, "TxID"));
            returnJson.put("sealId", StringUtil.getNodeText(response, "sealId"));
            returnJson.put("imageData", StringUtil.getNodeText(response, "imageData"));
            returnJson.put("ResponseDesc", StringUtil.getNodeText(response, "ResponseDesc"));
        } catch (APIToolKitException e) {
            e.printStackTrace();
        }
        return returnJson;
    }

    //删除表中数据
    @Autowired
    private EleSignSealMapper eleSignSealMapper;

    @Override
    public int deleteBySealId(String id) {
        int res = eleSignSealMapper.deleteBySealId(id);
        return res;
    }

    //更新表中数据
    @Override
    public int updateBySealId(String id,String value) {
        int res = eleSignSealMapper.updateBySealId(id,value);
        return res;
    }
}
