package com.hand.app.electronicSignature.dto;


import com.hand.hap.mybatis.annotation.ExtensionAttribute;
import com.hand.hap.system.dto.BaseDTO;

import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

@Table(name = "electronic_signature_contract")
@ExtensionAttribute(disable = true)
public class EleSignContract extends BaseDTO {
    @Id
    @GeneratedValue
    private Integer conId;
    private String txId;
    private String contractId;
    private String templateId;
    private Boolean platformIsSignatory;
    private String serialNumber;
    private String sealId;
    private String contractName;
    private String contractFile;
    private String attachmentContentHash;
    private String attachmentName;
    private String responseCode;
    private String responseDesc;
    private String contractType;
    private String keyWord;
    private Integer offsetX;
    private Integer offsetY;
    private Integer sealWith;
    private Integer sealHeight;
    private Integer page;
    private Integer sealLbx;
    private Integer sealLby;
    private Integer sealRux;
    private Integer sealRuy;


    @Transient
    private List<EleSignConData> conDataList;

    @Transient
    private List<EleSignSeal> sealList;

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public Integer getSealLbx() {
        return sealLbx;
    }

    public void setSealLbx(Integer sealLbx) {
        this.sealLbx = sealLbx;
    }

    public Integer getSealLby() {
        return sealLby;
    }

    public void setSealLby(Integer sealLby) {
        this.sealLby = sealLby;
    }

    public Integer getSealRux() {
        return sealRux;
    }

    public void setSealRux(Integer sealRux) {
        this.sealRux = sealRux;
    }

    public Integer getSealRuy() {
        return sealRuy;
    }

    public void setSealRuy(Integer sealRuy) {
        this.sealRuy = sealRuy;
    }

    public String getContractFile() {
        return contractFile;
    }

    public void setContractFile(String contractFile) {
        this.contractFile = contractFile;
    }

    public String getKeyWord() {
        return keyWord;
    }

    public void setKeyWord(String keyWord) {
        this.keyWord = keyWord;
    }

    public Integer getOffsetX() {
        return offsetX;
    }

    public void setOffsetX(Integer offsetX) {
        this.offsetX = offsetX;
    }

    public Integer getOffsetY() {
        return offsetY;
    }

    public void setOffsetY(Integer offsetY) {
        this.offsetY = offsetY;
    }

    public Integer getSealWith() {
        return sealWith;
    }

    public void setSealWith(Integer sealWith) {
        this.sealWith = sealWith;
    }

    public Integer getSealHeight() {
        return sealHeight;
    }

    public void setSealHeight(Integer sealHeight) {
        this.sealHeight = sealHeight;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }


    public String getAttachmentName() {
        return attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    public List<EleSignConData> getConDataList() {
        return conDataList;
    }

    public void setConDataList(List<EleSignConData> conDataList) {
        this.conDataList = conDataList;
    }

    public String getAttachmentContentHash() {
        return attachmentContentHash;
    }

    public void setAttachmentContentHash(String attachmentContentHash) {
        this.attachmentContentHash = attachmentContentHash;
    }


    public List<EleSignSeal> getSealList() {
        return sealList;
    }

    public void setSealList(List<EleSignSeal> sealList) {
        this.sealList = sealList;
    }

    public Integer getConId() {
        return conId;
    }

    public void setConId(Integer conId) {
        this.conId = conId;
    }

    public String getTxId() {
        return txId;
    }

    public void setTxId(String txId) {
        this.txId = txId;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public Boolean getPlatformIsSignatory() {
        return platformIsSignatory;
    }

    public void setPlatformIsSignatory(Boolean platformIsSignatory) {
        this.platformIsSignatory = platformIsSignatory;
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getSealId() {
        return sealId;
    }

    public void setSealId(String sealId) {
        this.sealId = sealId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getResponseCode() {
        return responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseDesc() {
        return responseDesc;
    }

    public void setResponseDesc(String responseDesc) {
        this.responseDesc = responseDesc;
    }
}
