package com.hand.app.appManger.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.hand.app.appManger.bean.SmsInfo;
import com.hand.app.appManger.service.ICaptchaCodeService;
import com.hand.hap.core.IRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.UUID;
import java.util.concurrent.TimeUnit;

@Service
public class CaptchaCodeServiceImpl implements ICaptchaCodeService {
    private final Logger logger = LoggerFactory.getLogger(CaptchaCodeServiceImpl.class);

    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private String category = "app:cache:captcha";
    private String captchaKeyName = "captcha_key";
    private Integer expire = 300;

    //产品名称
    static final String product = "Dysmsapi";
    //产品域名
    static final String domain = "dysmsapi.aliyuncs.com";

    // 阿里云的AK
    @Value("#{configProperties['aliyun.accessKeyId']}")
    private String accessKeyId;

    @Value("#{configProperties['aliyun.accessKeySecret']}")
    private String accessKeySecret;


    public String getCaptchaKeyName() {
        return this.captchaKeyName;
    }

    public void setCaptchaKeyName(String captchaKeyName) {
        this.captchaKeyName = captchaKeyName;
    }

    public Integer getExpire() {
        return this.expire;
    }

    public void setExpire(Integer expire) {
        this.expire = expire;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public void setCaptchaCode(String key, String code) {
        redisTemplate.opsForValue().set(this.getCategory() + ":" + key, code, (long) this.getExpire(), TimeUnit.SECONDS);
    }

    @Override
    public String getCaptchaCode(String key) {
        String captchaKey = this.getCategory() + ":" + key;
        String captchaCodeInRedis = redisTemplate.opsForValue().get(captchaKey);

        return captchaCodeInRedis;

    }

    @Override
    public void removeCaptchaCode(String key) {
        String captchaKey = this.getCategory() + ":" + key;
        redisTemplate.execute((RedisCallback<Object>) connection -> {
            connection.del(captchaKey.getBytes());
            return null;
        });

    }

    @Override
    public Boolean checkCaptcha(String key, String code) {
        if (code == null) {
            return false;
        } else {
            String captchaKey = this.getCategory() + ":" + key;
            String captchaCodeInRedis = redisTemplate.opsForValue().get(captchaKey);
            //this.removeCaptchaCode(key);
            return code.equalsIgnoreCase(captchaCodeInRedis);
        }
    }

    @Override
    public JSONObject sendAliyunSms(IRequest iRequest, SmsInfo smsInfo) {
        JSONObject json = new JSONObject();

        logger.info("smsInfo:{}", smsInfo);

        Boolean captchKey = false;

        int code = (int) ((Math.random() * 9 + 1) * 100000);
        //可自助调整超时时间
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        //初始化acsClient,暂不支持region化
        IClientProfile profile = DefaultProfile.getProfile("cn-hangzhou", accessKeyId, accessKeySecret);
        try {
            DefaultProfile.addEndpoint("cn-hangzhou", "cn-hangzhou", product, domain);
            IAcsClient acsClient = new DefaultAcsClient(profile);
            //发送短信接口
            //组装请求对象-具体描述见控制台-文档部分内容
            SendSmsRequest request = new SendSmsRequest();
            //必填:待发送手机号
            request.setPhoneNumbers(smsInfo.getPhoneNumber());
            //必填:短信签名
            request.setSignName(smsInfo.getSignName());
            //必填:短信模板
            request.setTemplateCode(smsInfo.getTemplateCode());

            JSONObject templatePara = smsInfo.getTemplateParam();
            if (templatePara == null || templatePara.isEmpty()) {
                captchKey = true;
                templatePara = new JSONObject();
                templatePara.put("code", code);
            }
            //可选:模板中的变量替换JSON串,如模板内容为"亲爱的${name},您的验证码为${code}"时,此处的值为
            request.setTemplateParam(templatePara.toString());
            //选填-上行短信扩展码(无特殊需求用户请忽略此字段)
            //request.setSmsUpExtendCode("90997");
            //可选:outId为提供给业务方扩展字段,最终在短信回执消息中将此值带回给调用者
            //request.setOutId(Integer.toString(code));
            SendSmsResponse sendSmsResponse = acsClient.getAcsResponse(request);
            if (sendSmsResponse.getCode() != null && sendSmsResponse.getCode().equals("OK")) {
                json.put("code", sendSmsResponse.getCode());
                json.put("message", sendSmsResponse.getMessage());
                //如果是短信验证码
                if (captchKey) {
                    String key = getUUID();
                    setCaptchaCode(key, code + "");
                    json.put("captchaKey", key);
                }

            } else {
                logger.info("message:{}", sendSmsResponse.getMessage());
                json.put("code", "E");
                String message = "短信发送失败!";
                if (sendSmsResponse.getCode().equals("isv.BUSINESS_LIMIT_CONTROL")) {
                    message = "当前手机发送超出限制次数";
                }
                json.put("message", message);
            }
        } catch (ClientException e) {
            logger.info("error:{}", e.getMessage());
            json.put("code", e.getMessage());
            json.put("message", "短信发送失败！");
        }
        return json;

    }

    public String getUUID() {
        return UUID.randomUUID().toString();
    }


}
