package com.hand.app.appManger.controllers;


import com.codahale.metrics.annotation.Timed;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.hand.app.appManger.dto.AppTime;
import com.hand.app.appManger.service.IAppTimeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by 晓兵 on 2018/4/19.
 */
@Controller
@RequestMapping(value = "/r/api")
public class AppTimeController extends BaseController {
    @Autowired
    private IAppTimeService appTimeService;
    @RequestMapping(value = "/app/queryTime",method = RequestMethod.GET)
    @ResponseBody
    @Timed
    public ResponseData queryTime(HttpServletRequest request, @RequestParam("timeId") Integer timeId, @RequestParam("userId") Integer userId) {
        return appTimeService.getTime(createRequestContext(request),timeId,userId);
    }

    @RequestMapping(value = "/app/addTime", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public AppTime addTime(HttpServletRequest request, @RequestBody AppTime time) {
        return appTimeService.insertSelective(createRequestContext(request), time);
    }

    @RequestMapping(value = "/app/deleteTime", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public int deleteTime(HttpServletRequest request, @RequestBody AppTime time) {
        return appTimeService.deleteByPrimaryKey(time);
    }

    @RequestMapping(value = "/app/updateTime", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public AppTime updateTime(HttpServletRequest request, @RequestBody AppTime time) {
        return appTimeService.updateByPrimaryKey(createRequestContext(request), time);
    }
}
