package com.hand.app.appManger.controllers;

import com.codahale.metrics.annotation.Timed;
import com.hand.app.appManger.dto.AppFunction;
import com.hand.app.appManger.dto.AppFunctionExclude;
import com.hand.app.appManger.service.IAppFunctionExcludeService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;

import com.hand.hap.system.dto.ResponseData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created by Think-PC on 2018/3/14.
 */
@Controller
@RequestMapping(value = {"/r/api","/"})
public class AppFunctionExcludeController extends BaseController {
    @Autowired
    private IAppFunctionExcludeService appFunctionExcludeService;

    @RequestMapping(value = "/app/queryFunctionExclude", method = RequestMethod.GET)
    @ResponseBody
    @Timed
    public ResponseData queryRoleAllFunction(HttpServletRequest request, @RequestParam("roleId") String roleId) {
        return appFunctionExcludeService.queryRoleAllFunction(createRequestContext(request),roleId);
    }

    @RequestMapping(value = "/app/addFunctionExclude", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public ResponseData addFunctionExclude(HttpServletRequest request, @RequestBody List<AppFunctionExclude> dto, BindingResult result) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return  new ResponseData(appFunctionExcludeService.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value = "/app/deleteFunctionExclude", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public int deleteFunctionModule(HttpServletRequest request, @RequestBody List<AppFunctionExclude> functionExclude) {
        return appFunctionExcludeService.batchDelete(functionExclude);
    }

}
