package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HlsGridBase extends Grid implements HlsComponent {
    public static final String PROPERTITY_TYPE = "gridType";
    public static final String PROPERTITY_HLSTITLE = "title";
    public static final String PROPERTITY_HLSPAGE_SIZE = "pageSize";
    public static final String PROPERTITY_HLSDATA_SOURCE = "hlsDataSource";
    public static final String PROPERTITY_HLSQUERYID = "queryId";
    public static final String PROPERTITY_HLSQUERYINPUTID = "queryInputId";
    public static final String PROPERTITY_HLSINPUTPLACEHOLDER = "inputPlaceholder";
    public static final String PROPERTITY_HLSLOCATEVENT = "locateEvent";
    public static final String PROPERTITY_HLSITEMS = "items";
    public static  final String PROPERTITY_COLOR="color";
    public static final String PROPERTITY_HLSWIDTH = "width";
    public static final String PROPERTITY_HLSBTNTYPE ="btnType";
    public static final String PROPERTITY_HLSSETPLACEHOLDER = "setPlaceholder";
    public static final String PROPERTITY_HLSQUERYITEM = "queryItem";
    public static final String PROPERTITY_CLICK_FUNC = "clickFunc";
    public String getColor(){return this.getPrototype().getString(PROPERTITY_COLOR);}
    public String getSetPlaceholder(){
        return this.getPrototype().getString(PROPERTITY_HLSSETPLACEHOLDER);
    }
    public String getQueryItem(){
        return this.getPrototype().getString(PROPERTITY_HLSQUERYITEM);
    }
    public Object getItems() {
        Items items = new Items();
        String paramMapArray = this.getPrototype().getString("items");
        XMap paramMapChild = this.getPrototype().getChild("items");
        ArrayList cList = new ArrayList();
        if(paramMapArray != null) {
            String[] var7 = paramMapArray.split(",");
            for(int var8 = 0; var8 < var7.length; ++var8) {
                var7[var8] = var7[var8].trim();
            }
            return var7;
        } else {
            if(paramMapChild != null) {
                List list = paramMapChild.getChildren();
                if(list != null) {
                    Iterator i = list.iterator();
                    while(i.hasNext()) {
                        XMap view = (XMap)i.next();
                        cList.add(ItemsMethod.parse(view));
                    }
                    return cList;
                }
            }
            return null;
        }
    }
    public void setItems(Items items) {
        XMap map = this.getPrototype().getChild("items");
        if(map == null) {
            map = this.getPrototype().createChild("h", "http://www.hand-china.com/hap", "items");
        }
        map.addChild(items.toXMap());
    }
    public String getClickFunc() {
        return this.getPrototype().getString(PROPERTITY_CLICK_FUNC);
    }
    public String getWidth() {
        return this.getPrototype().getString(PROPERTITY_HLSWIDTH);
    }
    public String getLocateEvent() {
        return this.getPrototype().getString(PROPERTITY_HLSLOCATEVENT);
    }
    public String getInputPlaceHolder() {
        return getPrototype().getString(PROPERTITY_HLSINPUTPLACEHOLDER);
    }
    public String getHlsDataSource() {
        return getPrototype().getString(PROPERTITY_HLSDATA_SOURCE);
    }
    public String getPageSize() {
        return getPrototype().getString(PROPERTITY_HLSPAGE_SIZE);
    }
    public String getQueryId() {
        return getPrototype().getString(PROPERTITY_HLSQUERYID);
    }
    public String getQueryInputId() {
        return getPrototype().getString(PROPERTITY_HLSQUERYINPUTID);
    }
    public String getTitle() {
        return getPrototype().getString(PROPERTITY_HLSTITLE);
    }
    public String getBtnType(){
        return getPrototype().getString(PROPERTITY_HLSBTNTYPE);
    }
    public String getGridType(){return getPrototype().getString(PROPERTITY_TYPE);}

    public void init(XMap view, ViewContext context) throws Exception {
        super.init(view, context);
        context.put(PROPERTITY_HLSDATA_SOURCE, getHlsDataSource());
        context.put(PROPERTITY_HLSCLASSNAME, getHlsClassName());
        context.put(PROPERTITY_HLSSTYLE, getHlsStyle());
        context.put(PROPERTITY_HLSTITLE, getTitle());
        context.put(PROPERTITY_HLSINPUTPLACEHOLDER, getInputPlaceHolder());
        context.put(PROPERTITY_HLSQUERYID, getQueryId());
        context.put(PROPERTITY_HLSQUERYINPUTID, getQueryInputId());
        context.put(PROPERTITY_HLSPAGE_SIZE, getPageSize());
        context.put(PROPERTITY_TYPE, getGridType());
        context.put(PROPERTITY_COLOR,getColor());
        context.addJsonConfig("color",getColor());
        context.put(PROPERTITY_HLSWIDTH,getWidth());
        context.put(PROPERTITY_HLSSETPLACEHOLDER,getSetPlaceholder());
        context.put(PROPERTITY_HLSQUERYITEM,getQueryItem());
        context.put(PROPERTITY_CLICK_FUNC,getClickFunc());
        context.addJsonConfig("locateEvent", getLocateEvent());
        context.addJsonConfig("pageSize",getPageSize());
        context.addJsonConfig("id", getId());
        context.addJsonConfig(PROPERTITY_HLSITEMS, this.getItems());
        context.addJsonConfig("title", getTitle());
        context.addJsonConfig("queryId",getQueryId());
        setHlsBtn(context);
    }

    private void setHlsBtn(ViewContext context) {
        if (getBtnType() != null) {
            String[] datas = getBtnType().split(",");
            for (int i = 0; i < datas.length; i++) {
                String[] datas2 = datas[i].split(":");
                String btnType = datas2[0].trim().toUpperCase();
                context.put("BTN" + btnType, "Y");
                if(datas2.length==2) {
                    String btnFunction = datas2[1].trim();
                    context.put("BTF" + btnType,btnFunction );
                }
            }
        }
    }
    @Override
    public void hlsSetPropertity(Object key, Object value) {
        // TODO Auto-generated method stub
        super.setPropertity(key, value);
    }
}
