package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;

/**
 * 
 * 
 * 
 * @author yang.gao01@hand-china.com
 * 
 */
@UITag
public class HlsCheckbox extends InputField implements HlsComponent {
	public static final String PROPERTITY_HLSCHECKBOX = "hlsCheckbox";
	private static final String PROPERTITY_CHECKED_VALUE = "checkedValue";
	private static final String PROPERTITY_UNCHECKED_VALUE = "uncheckedValue";
	private static final String PROPERTITY_READONLY = "readonly";

	public static HlsCheckbox createInstance() {
		XMap view = new XMap(DEFAULT_TAG_PREFIX, DEFAULT_NAME_SPACE,
				PROPERTITY_HLSCHECKBOX);
		HlsCheckbox HlsCheckbox = new HlsCheckbox();
		HlsCheckbox.initPrototype(view);
		return HlsCheckbox;
	}

	public String getCheckedValue() {
		return getPrototype().getString(PROPERTITY_CHECKED_VALUE);
	}
	
	public void setCheckedValue(String checkedValue) {
		setPropertity(PROPERTITY_CHECKED_VALUE, checkedValue);
	}

	public String getUncheckedValue() {
		return getPrototype().getString(PROPERTITY_UNCHECKED_VALUE);
	}

	public void setUncheckedValue(String UncheckedValue) {
		setPropertity(PROPERTITY_UNCHECKED_VALUE, UncheckedValue);
	}
	
	public Boolean getReadonly() {
        return getPrototype().getBoolean(PROPERTITY_READONLY);
    }
    
    public void setReadonly(String readonly) {
        setPropertity(PROPERTITY_READONLY, readonly);
    }

	public void init(XMap view, ViewContext context) throws Exception {
		super.init(view, context);
		context.put(PROPERTITY_PROMPTCOLSPAN, getPromptColspan());
		context.put(PROPERTITY_PROMPT, getPrompt());
		context.put(PROPERTITY_HLSCLASSNAME, getHlsClassName());
		context.put(PROPERTITY_PROMPTCLASSNAME, getPromptClassName());
		context.put(PROPERTITY_PRMOPTIMAGE, getPromptImage());
		context.put(PROPERTITY_BINDMODEL, getHlsBindModel());
		context.put(PROPERTITY_COLSPAN, getColSpan());
		context.put(PROPERTITY_VALIDATIONMESSAGE, getValidationMessage());
		context.put(PROPERTITY_CHECKED_VALUE, getCheckedValue());
		context.put(PROPERTITY_UNCHECKED_VALUE, getUncheckedValue());
		context.put(PROPERTITY_DATAMODELNAME, getDataField(PROPERTITY_DATAMODELNAME));
		context.put(PROPERTITY_DATAFIELDNAME, getDataField(PROPERTITY_DATAFIELDNAME));
		context.addJsonConfig(PROPERTITY_CHECKED_VALUE, getCheckedValue());
        context.addJsonConfig(PROPERTITY_UNCHECKED_VALUE, getUncheckedValue());
        context.addJsonConfig(PROPERTITY_READONLY, getReadonly());
	}

	@Override
	public void hlsSetPropertity(Object key, Object value) {
		super.setPropertity(key, value);
	}

}
