package com.hand.app.pingAn.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.esignHclc.utils.SignHclcUtils;
import com.hand.app.pingAn.service.PingAnService;
import com.hand.app.pingAn.utils.ApiUtils;
import com.hand.app.zhongDengWang.dto.HlsWsRequests;
import com.hand.app.zhongDengWang.mapper.HlsWsRequestsMapper;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.system.dto.ResponseData;
import com.pingan.openbank.api.sdk.common.http.HttpResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class PingAnServiceImpl implements PingAnService {

    @Autowired
    private HlsWsRequestsMapper hlsWsRequestsMapper;
    @Autowired
    private IHapInterfaceHeaderService headerService;

    private Logger logger = LoggerFactory.getLogger(getClass());
    /**
     * 还需要考虑是否要开启事务，但是貌似不太需要
     * @param interfaceName
     * @param params
     * @return
     */
    @Override
    public ResponseData invoke(String interfaceName, HashMap params) {
        ResponseData responseData = new ResponseData();
        JSONObject requestBody = ApiUtils.getBaseReqBody();
        requestBody.putAll(params);
        /*插入接口日志表*/
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests = createRequestLog("url", requestBody.toJSONString(), "pingAn_"+interfaceName.substring(interfaceName.lastIndexOf('/')+1), 1L);
        HttpResult result = ApiUtils.invoke(interfaceName, requestBody);
        if (Objects.nonNull(result)) {
            if ("000000".equals(result.getCode())) {
                ArrayList<String> list = new ArrayList<>();
                JSONObject res = JSONObject.parseObject(responseData.getMessage());
                // todo 记录返回信息并存表

                hlsWsRequests.setReturnStatus("s");
                responseData.setSuccess(true);
                responseData.setRows(list);
            } else {
                //请求失败
                hlsWsRequests.setReturnStatus("f");
                responseData.setSuccess(false);
            }
            hlsWsRequests.setResponseJson(result.getData());
            hlsWsRequests.setResponsedDate(new Date());

            // todo 处理响应信息


        }
        //更新日志
        hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        return responseData;
    }


    public ResponseData detailNotify(JSONObject data){
        ResponseData responseData = new ResponseData();
        // todo 返回单条数据，存记录
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests = createRequestLog("url", data.toJSONString(), "pingAn_notify", 1L);
        // 调用系统的接口服务，推送通知数据
        postNotify(data);

        return responseData;
    }


    private HlsWsRequests createRequestLog(String wsdlUrl, String requestClob, String functionName , Long pkValue) {
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests.setRequestDate(new Date());
        hlsWsRequests.setRequestWsdlUrl(wsdlUrl);
        hlsWsRequests.setFunctionName(functionName);
        hlsWsRequests.setRequestJson(requestClob);
        hlsWsRequests.setStatusDate(new Date());
        hlsWsRequests.setParameterType("json");
        hlsWsRequests.setPkValue(pkValue);

        hlsWsRequestsMapper.insertSelective(hlsWsRequests);
        return hlsWsRequests;
    }

    private String postNotify(JSONObject params) {
        String sysName = "HCL_UPLOAD_FILE";
        // todo 待修改
        String apiName = "writeOffLd037";
        try {

            //初始化接口信息
            HapInterfaceHeader headerAndLineDTO = headerService.getHeaderAndLine(sysName, apiName);
            if (headerAndLineDTO == null) {
                logger.info("headerAndLineDTO is null， apiName:{}, sysName:{}", apiName, sysName);
                return "N";
            }

            String url = headerAndLineDTO.getDomainUrl() + headerAndLineDTO.getIftUrl();

            Map<String, String> headInfo = new HashMap<String, String>();
            headInfo.put("Content-Type", "application/x-www-form-urlencoded");

            JSONObject requestData = new JSONObject();
            requestData.put("requestData", params.toString());

            //发送http请求
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, requestData, headInfo, SignHclcUtils.APPLICATION_FORM_URLENCODED);

            //解析返回结果
            JSONObject jsonResult = JSONObject.parseObject(stringResult);
            if ("S".equalsIgnoreCase(jsonResult.getString("respCode"))) {
                return "Y";
            } else {
                return "N";
            }
        } catch (Exception e) {
            e.printStackTrace();
            return "N";
        }
    }

}
