package com.hand.app.pingAn.controllers;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.pingAn.service.PingAnService;
import com.hand.app.pingAn.utils.ApiUtils;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.pingan.openbank.api.sdk.common.http.HttpResult;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Random;


@Controller
public class PingAnController extends BaseController {

    @Autowired
    private PingAnService pingAnService;

    @ApiModelProperty("子账户维护(BEDL_C002)")
    @RequestMapping("/bedl/SubAcctMaintenance")
    @ResponseBody
    public ResponseData bindSubAccount(){
        // 模拟请求参数
        HashMap<String, String> reqParams = new HashMap<>();
        reqParams.put("OpFlag","A");
        reqParams.put("SubAccountSeq","123456");
        reqParams.put("SubAccountName","测试别名");
        String seqNoTime = new SimpleDateFormat("yyMMdd").format(Calendar.getInstance().getTime());
        Random random = new Random();
        String randomNo = "";
        for (byte i = 0; i < 8; i++) {
            int randomNumber = random.nextInt(10);
            randomNo += randomNumber;
        }
        //系统流水号，规范：用户短号（6位）+日期（6位）+随机编号（10位）
        reqParams.put("CnsmrSeqNo", "C25634" + seqNoTime + randomNo);

        return pingAnService.invoke("bedl/SubAcctMaintenance",reqParams);
    }


    @ApiModelProperty("近期明细查询(BEDL_C00602)")
    @RequestMapping("/bedl/InquiryIntoTheCurrentDetailsOfMainSubaccountAccountTwo")
    @ResponseBody
    public ResponseData recentDetailQuery(){
        // 模拟请求参数
        HashMap<String, String> reqParams = new HashMap<>();
        reqParams.put("OpFlag","1");
        reqParams.put("SubAccountSeq","123456");
        reqParams.put("SubAccountName","测试别名");
        reqParams.put("StartTime","20221201000000");
        reqParams.put("EndTime","20221202000000");
        reqParams.put("PageNo","1");
        reqParams.put("PageSize","200");
        String seqNoTime = new SimpleDateFormat("yyMMdd").format(Calendar.getInstance().getTime());
        Random random = new Random();
        String randomNo = "";
        for (byte i = 0; i < 10; i++) {
            int randomNumber = random.nextInt(10);
            randomNo += randomNumber;
        }
        //系统流水号，规范：用户短号（6位）+日期（6位）+随机编号（10位）
        reqParams.put("CnsmrSeqNo", "C25634" + seqNoTime + randomNo);

        return pingAnService.invoke("bedl/InquiryIntoTheCurrentDetailsOfMainSubaccountAccountTwo",reqParams);
    }

    @ApiModelProperty("明细通知接口(BEDL_ZNA001)")
    @RequestMapping("/api/public/pingAn/notify")
    @ResponseBody
    public ResponseData DetailsNotify(JSONObject data){
        // 类似支付结果通知的接口，每次返回一条记录。

        // 将数据推送到业务系统
        return pingAnService.detailNotify(data);
    }

    @ApiModelProperty("清分台账明细下载(BEDL_F0P101)")
    @RequestMapping("/bedl/DetailReportQueryNew")
    @ResponseBody
    public ResponseData downloadDetail(JSONObject data){

        return pingAnService.detailNotify(data);
    }
}
