package com.hand.app.hms.service.impl;

/**
 * Created by 晓兵 on 2017/4/6.
 */

import net.coobird.thumbnailator.Thumbnails;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.UUID;
/**
 * 网络访问工具类
 * @author silk
 *
 */
public class PureNetUtilImpl {
    /**
     * get方法直接调用post方法
     * @param url 网络地址
     * @return 返回网络数据
     */
    public static String get(String url){
        return post(url,null);
    }
    public static String get(String url,String charset){
        return post(url,null,charset);
    }
    /**
     * 设定post方法获取网络资源,如果参数为null,实际上设定为get方法
     * @param url 网络地址
     * @param file_path 请求参数键值对
     * @return 返回读取数据
     */
    public static String post(String url,String file_path){
        return post(url,file_path,null);
    }
    //名片将map型转为请求参数型
    public static String urlencode(String data) {
        JSONObject json;
        json = JSONObject.fromObject(data);
        Iterator iterator = json.keys();
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            String key = (String) iterator.next();
            try {
                sb.append(key).append("=").append(URLEncoder.encode(json.get(key)+"","UTF-8")).append("&");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }

        }
        return sb.toString();
    }
    //png图片转化成jpg格式
    public static String compressPhoto(int width, int height, String originalFilePath) {
        String compressFilePath = originalFilePath + "_" + width + "_" + height+".jpg";
        try {
            File compressPhotoFile = new File(compressFilePath);
            if (!compressPhotoFile.exists()) {
                File originalPhotoFile = new File(originalFilePath);

                BufferedImage buff = ImageIO.read(new FileInputStream(
                        originalPhotoFile));

                int originalWidth = buff.getWidth();
                int originalHeight = buff.getHeight();
                width=(int)(originalWidth*0.9);
                height=(int)(originalHeight*0.9);
                if (originalWidth > width) {
                /*NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setMaximumFractionDigits(2);
                String percent = numberFormat.format(width /
                        originalWidth);
                double percentDouble = new Double(percent).doubleValue();*/
                    double percentDouble=(double) width/originalWidth;
                    BufferedImage bufferedImage = Thumbnails.of(new File[]{originalPhotoFile})
                            .scale(percentDouble).outputQuality(1.0D)
                            .outputFormat("jpg").asBufferedImage();
                    if (bufferedImage.getHeight() > height) {
                        Thumbnails.of(new BufferedImage[]{
                                bufferedImage})
                                .scale(1.0D)
                                .outputQuality(1.0D)
                                .sourceRegion(0, 0, bufferedImage.getWidth(),
                                        height).toFile(compressPhotoFile);
                    } else {
                        Thumbnails.of(new BufferedImage[]{bufferedImage}).scale(1.0D).outputQuality(1.0D)
                                .toFile(compressPhotoFile);
                    }

                } else if (originalHeight > height) {
                    BufferedImage bufferedImage = Thumbnails.of(new File[]{originalPhotoFile}).scale(1.0D)
                            .outputQuality(1.0D).outputFormat("jpg")
                            .asBufferedImage();
                    Thumbnails.of(new BufferedImage[]{bufferedImage}).scale(1.0D).outputQuality(1.0D)
                            .sourceRegion(0, 0, originalWidth, height)
                            .toFile(compressPhotoFile);
                }

            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return compressFilePath;
    }
    // base64字符串转化成图片
    public static String GenerateImage(String baseStr,String picture_path) { // 对字节数组字符串进行Base64解码并生成图片
        BASE64Decoder decoder = new BASE64Decoder();
        String path = picture_path;
        //String path = "D:\\";
        String name = getRandomString();
        String filepath = path + name;
        try {
            // Base64解码
            byte[] b = decoder.decodeBuffer(baseStr);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] < 0) {// 调整异常数据
                    b[i] += 256;
                }
            }
            // 生成
            String imgFilePath = filepath;// 新生成的图片
            OutputStream out = new FileOutputStream(imgFilePath);
            out.write(b);
            out.flush();
            out.close();
        } catch (Exception e) {
        }
        System.out.print(filepath);
        return compressPhoto(  1024,768,filepath);
    }
    //获取指定位数的随机字符串(包含小写字母、大写字母、数字,0<length)
    public static String getRandomString() {
        return UUID.randomUUID().toString().replaceAll("-", "").toUpperCase();
    }

    public static String post(String  url,String file_path,String outCharset){
        if(outCharset==null) {
            outCharset = "UTF-8";
        }
        String resultDate="";
        HttpURLConnection conn=null;
        try {
            File file = new File(file_path);
            FileInputStream inputStream = new FileInputStream(file);
            int sum = 0;
            sum=inputStream.available();
            url=url+sum;
            URL httpurl=new URL(url);
            HttpURLConnection con = (HttpURLConnection) httpurl.openConnection();
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestMethod("POST");
            OutputStream out = con.getOutputStream();
            //FileInputStream inputStream = new FileInputStream(file);
            byte[] data = new byte[2048];
            int len = 0;
            while ((len = inputStream.read(data))!= -1) {
                out.write(data, 0, len);
                //sum = len + sum;
            }
            System.out.println("upload size="+sum);
            out.flush();
            inputStream.close();
            out.close();
            int code = con.getResponseCode();
            //System.out.println("code="+code+ " url="+url);
            if (code==200) {
                InputStream inputStream2 = con.getInputStream();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                while ((len = inputStream2.read(data))!= -1) {
                    bos.write(data, 0, len);
                }
                System.out.println("result ="+bos.toString());
                inputStream2.close();
                bos.close();
                resultDate= bos.toString();
            }
            con.disconnect();
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }finally{
            if(conn!=null)//关闭连接
                conn.disconnect();
        }
        return resultDate;
    }

    public static String GetImageStr(String imgFilePath) {// 将图片文件转化为字节数组字符串，并对其进行Base64编码处理
        byte[] data = null;

// 读取图片字节数组
        try {
            InputStream in = new FileInputStream(imgFilePath);
            data = new byte[in.available()];
            in.read(data);
            in.close();
        } catch (IOException e) {
            e.printStackTrace();
        }

// 对字节数组Base64编码
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(data);// 返回Base64编码过的字节数组字符串
    }

    public static String GetBase64(String imgFilePath){
        //将图片文件转成base64
        InputStream in = null;
        byte[] data = null;
        //读取图片字节数组
        try {
            in = new FileInputStream(imgFilePath);
            data = new byte[in.available()];
            in.read(data);
            in.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return new String(Base64.encodeBase64(data));


    }


}
