package com.hand.app.electronicSignature.demo;

import constant.APIToolKitException;
import constant.ProtocolConstant;
import request.Tx1019Request;
import service.SignAPI;
import util.Base64;
import util.StringUtil;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;


public class Test1019 {
    public static void main(String[] args)   {
        try {
            SignAPI.initAPI("./APIConfig");
            Tx1019Request tx1019Request = new Tx1019Request();
            String contractId = "RZZL20190308000000009";
            if(args != null){
                contractId = args[0];
            }
            tx1019Request.setContractId(contractId);

            String response = SignAPI.sendMessageAndGetResult(tx1019Request);
            String contractFile = StringUtil.getNodeText(response, ProtocolConstant.CONTRACT_FILE);
            byte[] fileBytes  = Base64.base64ToByteArray(contractFile);
            try {
                String filePath = "./file";
                File dir = new File(filePath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File file = new File(filePath + File.separator + contractId + ".pdf");
                try{
                        FileOutputStream fos = new FileOutputStream(file);

                    fos.write(fileBytes);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println(response);
        } catch (APIToolKitException e) {
            e.printStackTrace();
        }


    }
}
