package com.hand.app.electronicSignature.controllers;

import com.alibaba.fastjson.JSONObject;
import com.codahale.metrics.annotation.Timed;
import com.hand.app.electronicSignature.dto.*;
import com.hand.app.electronicSignature.service.*;
import com.hand.app.hms.service.IHmsThirdpartyAppService;
import com.hand.hap.system.controllers.BaseController;
import config.APIConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import service.SignAPI;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import java.io.InputStream;
import java.util.*;
import org.apache.commons.io.IOUtils;

@Controller
@RequestMapping(value = "/r/api")
public class ElectronicSignatureController extends BaseController {

    @Autowired
    IElectronicSignatureService electronicSignatureService;

    @Autowired
    IHmsThirdpartyAppService thirdpartyAppService;

    @Value("${electronic.signature.path}")
    private static String APIConfigPath;

    public ElectronicSignatureController(){

    }

    //1001个人开户
    @RequestMapping(value = "/electronicSignature/personalAccountOpen", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject personalAccountOpen(HttpServletRequest requests, @RequestBody(required = false) EleSignUser params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI(APIConfigPath);
            response = electronicSignatureService.personalAccountOpen(params);
            params.setUserId(response.get("userId").toString());
            params.setTxId(response.get("txId").toString());
            params.setResponseCode(response.get("ResponseCode").toString());
            params.setResponseDesc(response.get("ResponseDesc").toString());
        } catch (Exception e) {
            response.put("message", e);
        }
        EleSignUser result = electronicSignatureService.insertSelective(createRequestContext(requests), params);
        return response;
    }

    //1002企业开户
    @RequestMapping(value = "/electronicSignature/firmAccountOpen", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject firmAccountOpen(HttpServletRequest requests, @RequestBody(required = false) EleSignUser params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI(APIConfigPath);
            response = electronicSignatureService.firmAccountOpen(params);
            params.setUserId(response.get("userId").toString());
            params.setTxId(response.get("txId").toString());
            params.setResponseCode(response.get("ResponseCode").toString());
            params.setResponseDesc(response.get("ResponseDesc").toString());
        } catch (Exception e) {
            response.put("message", e);
        }
        EleSignUser result = electronicSignatureService.insertSelective(createRequestContext(requests), params);
        return response;
    }

    @Autowired
    IElectronicSignatureSeal electronicSignatureSeal;

    //1003增加印章
    @RequestMapping(value = "/electronicSignature/addSeal", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject addSeal(HttpServletRequest requests) throws Exception {
        JSONObject response = new JSONObject();
        JSONObject param = new JSONObject();
        String filePath = null;
        String fileName = null;
        EleSignSeal params = new EleSignSeal();
        Enumeration<String> str = requests.getParameterNames();
        if (str != null) {
            while (str.hasMoreElements()) {
                String en = str.nextElement();
                String value = requests.getParameter(en);
                param.put(en, value);
            }
        }
        try {
            SignAPI.initAPI(APIConfigPath);
            boolean isMultipart = ServletFileUpload.isMultipartContent(requests);
            if (!isMultipart) {
                response.put("code", "E");
                response.put("error", "不支持的文件类型");
            }
            if (requests instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest req = (MultipartHttpServletRequest) requests;
                Map<String, MultipartFile> fileMap = req.getFileMap();
                if (fileMap != null) {
                    Iterator<Map.Entry<String, MultipartFile>> iterator = fileMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, MultipartFile> next = iterator.next();
                        MultipartFile filePart = next.getValue();
                        fileName = filePart.getOriginalFilename();
                        InputStream inputStream = filePart.getInputStream();
                        byte[] bytes = IOUtils.toByteArray(inputStream);
                        filePath = Base64.getEncoder().encodeToString(bytes);
                    }
                }
            }
            param.put("imageData", filePath);
            response = electronicSignatureSeal.addSeal(param);
            params.setSealId(response.get("sealId").toString());
            params.setTxId(response.get("txId").toString());
            params.setResponseCode(response.get("ResponseCode").toString());
            params.setResponseDesc(response.get("ResponseDesc").toString());
            params.setImageData(fileName);
            params.setUserId(param.getString("userId"));
            EleSignSeal result = electronicSignatureSeal.insertSelective(createRequestContext(requests), params);
        } catch (Exception e) {
            response.put("message", e);
        }
        return response;
    }

    //1004删除印章
    @RequestMapping(value = "/electronicSignature/deleteSeal", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject deleteSeal(HttpServletRequest requests, @RequestBody(required = false) EleSignSeal params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI(APIConfigPath);
            response = electronicSignatureSeal.deleteSeal(params);
            params.setTxId(response.get("txId").toString());
            params.setResponseCode(response.get("ResponseCode").toString());
            params.setResponseDesc(response.get("ResponseDesc").toString());
        } catch (Exception e) {
            response.put("message", e);
        }
        int result = electronicSignatureSeal.deleteBySealId(params.getSealId());
        return response;
    }

    //1005修改印章
    @RequestMapping(value = "/electronicSignature/alterSeal", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject alterSeal(HttpServletRequest requests) throws Exception {
        JSONObject response = new JSONObject();
        JSONObject param = new JSONObject();
        String filePath = null;
        String fileName = null;
        EleSignSeal params = new EleSignSeal();
        Enumeration<String> str = requests.getParameterNames();
        if (str != null) {
            while (str.hasMoreElements()) {
                String en = str.nextElement();
                String value = requests.getParameter(en);
                param.put(en, value);
            }
        }
        try {
            SignAPI.initAPI(APIConfigPath);
            boolean isMultipart = ServletFileUpload.isMultipartContent(requests);
            if (!isMultipart) {
                response.put("code", "E");
                response.put("error", "不支持的文件类型");
            }
            if (requests instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest req = (MultipartHttpServletRequest) requests;
                Map<String, MultipartFile> fileMap = req.getFileMap();
                if (fileMap != null) {
                    Iterator<Map.Entry<String, MultipartFile>> iterator = fileMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, MultipartFile> next = iterator.next();
                        MultipartFile filePart = next.getValue();
                        fileName = filePart.getOriginalFilename();
                        InputStream inputStream = filePart.getInputStream();
                        byte[] bytes = IOUtils.toByteArray(inputStream);
                        filePath = Base64.getEncoder().encodeToString(bytes);
                    }
                }
            }
            param.put("imageData", filePath);
            response = electronicSignatureSeal.alterSeal(param);
            params.setImageData(fileName);
            params.setUserId(param.getString("userId"));
            params.setSealId(param.getString("sealId"));
            params.setTxId(response.get("txId").toString());
            params.setResponseCode(response.get("ResponseCode").toString());
            params.setResponseDesc(response.get("ResponseDesc").toString());
        } catch (Exception e) {
            response.put("message", e);
        }
        int result = electronicSignatureSeal.updateBySealId(params.getSealId(), params.getImageData());
        return response;
    }

    //1006查询印章
    @RequestMapping(value = "/electronicSignature/querySeal", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject querySeal(HttpServletRequest requests, @RequestBody(required = false) EleSignSeal params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI(APIConfigPath);
            response = electronicSignatureSeal.querySeal(params);
        } catch (Exception e) {
            response.put("message", e);
        }
        return response;
    }


    @Autowired
    IElectronicSignatureAuth electronicSignatureAuth;

    //1007发送授权码
    @RequestMapping(value = "/electronicSignature/postAuthCode", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject postAuthCode(HttpServletRequest requests, @RequestBody(required = false) EleSignAuth params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI(APIConfigPath);
            response = electronicSignatureAuth.postAuthCode(params);
            params.setTxId(response.getString("txId"));
            params.setResponseDesc(response.getString("ResponseDesc"));
            params.setResponseCode(response.getString("ResponseCode"));
        } catch (Exception e) {
            response.put("message", e);
        }
        EleSignAuth result = electronicSignatureAuth.insertSelective(createRequestContext(requests), params);
        return response;
    }

    //1008验证授权码
    @RequestMapping(value = "/electronicSignature/verifyAuthCode", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject verifyAuthCode(HttpServletRequest requests, @RequestBody(required = false) EleSignAuth params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            response = electronicSignatureAuth.verifyAuthCode(params);
            params.setTxId(response.getString("txId"));
            params.setResponseDesc(response.getString("ResponseDesc"));
            params.setResponseCode(response.getString("ResponseCode"));
        } catch (Exception e) {
            response.put("message", e);
        }
        EleSignAuth result = electronicSignatureAuth.insertSelective(createRequestContext(requests), params);
        return response;
    }

    //1009人脸授权
    @RequestMapping(value = "/electronicSignature/faceAuth", method = RequestMethod.POST)
    @Timed
    public JSONObject faceAuth(HttpServletRequest requests) throws Exception {
        JSONObject response = new JSONObject();
        JSONObject param = new JSONObject();
        String filePath = null;
        String fileName = null;
        EleSignAuth params = new EleSignAuth();
        Enumeration<String> str = requests.getParameterNames();
        if (str != null) {
            while (str.hasMoreElements()) {
                String en = str.nextElement();
                String value = requests.getParameter(en);
                param.put(en, value);
            }
        }
        try {
            SignAPI.initAPI(APIConfigPath);
            boolean isMultipart = ServletFileUpload.isMultipartContent(requests);
            if (!isMultipart) {
                response.put("code", "E");
                response.put("error", "不支持的文件类型");
            }
            if (requests instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest req = (MultipartHttpServletRequest) requests;
                Map<String, MultipartFile> fileMap = req.getFileMap();
                if (fileMap != null) {
                    Iterator<Map.Entry<String, MultipartFile>> iterator = fileMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, MultipartFile> next = iterator.next();
                        MultipartFile filePart = next.getValue();
                        fileName = filePart.getOriginalFilename();
                        InputStream inputStream = filePart.getInputStream();
                        byte[] bytes = IOUtils.toByteArray(inputStream);
                        filePath = Base64.getEncoder().encodeToString(bytes);
                    }
                }
            }
            param.put("selfieData", filePath);
            response = electronicSignatureAuth.faceAuth(param);
            params.setTxId(response.get("txId").toString());
            params.setResponseCode(response.get("ResponseCode").toString());
            params.setResponseDesc(response.get("ResponseDesc").toString());
            params.setSelfieData(fileName);
            params.setSerialNumber(param.getString("serialNumber"));
            params.setUserId(param.getString("userId"));
        } catch (Exception e) {
            response.put("message", e);
        }
        EleSignAuth result = electronicSignatureAuth.insertSelective(createRequestContext(requests), params);
        return response;
    }

    @Autowired
    IElectronicSignatureContract electronicSignatureContract;
    //1010创建合同(模板方式)
    @RequestMapping(value = "/electronicSignature/createContractTemplate", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject createContractTemplate(HttpServletRequest requests, @RequestBody(required = false) EleSignContract params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI(APIConfigPath);
            response = electronicSignatureContract.createContractTemplate(params);
        } catch (Exception e) {
            response.put("message", e);
        }
        return response;
    }

    //1011创建合同(上传合同文件方式)
    @RequestMapping(value = "/electronicSignature/createContractFile", method = RequestMethod.POST)
    @Timed
    public JSONObject createContractFile(HttpServletRequest requests) throws Exception {
        JSONObject response = new JSONObject();
        EleSignContract params = new EleSignContract();
        JSONObject param = new JSONObject();
        String filePath = null;
        String fileName = null;
        Enumeration<String> str = requests.getParameterNames();
        if (str != null) {
            while (str.hasMoreElements()) {
                String en = str.nextElement();
                String value = requests.getParameter(en);
                param.put(en, value);
            }
        }
        params.setContractType(param.getString("contractType"));
        params.setSerialNumber(param.getString("serialNumber"));
        params.setContractName(param.getString("contractName"));
        params.setKeyWord(param.getString("keyWord"));
        params.setSealId(param.getString("sealId"));
        params.setOffsetX(Integer.parseInt(param.getString("offsetX")));
        params.setOffsetY(Integer.parseInt(param.getString("offsetY")));
        params.setSealWith(Integer.parseInt(param.getString("sealWith")));
        params.setSealHeight(Integer.parseInt(param.getString("sealHeight")));
        params.setPlatformIsSignatory(Boolean.valueOf(param.getString("platformIsSignatory")));
        try {
            SignAPI.initAPI(APIConfigPath);
            boolean isMultipart = ServletFileUpload.isMultipartContent(requests);
            if (!isMultipart) {
                response.put("code", "E");
                response.put("error", "不支持的文件类型");
            }
            if (requests instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest req = (MultipartHttpServletRequest) requests;
                Map<String, MultipartFile> fileMap = req.getFileMap();
                if (fileMap != null) {
                    Iterator<Map.Entry<String, MultipartFile>> iterator = fileMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, MultipartFile> next = iterator.next();
                        MultipartFile filePart = next.getValue();
                        fileName = filePart.getOriginalFilename();
                        InputStream inputStream = filePart.getInputStream();
                        byte[] bytes = IOUtils.toByteArray(inputStream);
                        filePath = Base64.getEncoder().encodeToString(bytes);
                    }
                }
            }
            params.setContractFile(filePath);
            response = electronicSignatureContract.createContractFile(params);
            params.setTxId(response.get("txId").toString());
            params.setContractId(response.get("contractId").toString());
            params.setResponseCode(response.get("ResponseCode").toString());
            params.setResponseDesc(response.get("ResponseDesc").toString());
            params.setContractFile(fileName);
        } catch (Exception e) {
            response.put("message", e);
        }
        electronicSignatureContract.insertSelective(createRequestContext(requests), params);
        return response;
    }

    //1019下载合同
    @RequestMapping(value = "/electronicSignature/downloadContract", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject downloadContract(HttpServletRequest requests, @RequestBody(required = false) EleSignContract params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI(APIConfigPath);
            response = electronicSignatureContract.downloadContract(params);
            params.setTxId(response.get("txId").toString());
            params.setContractFile(response.get("contractFile").toString());
            params.setResponseCode(response.get("ResponseCode").toString());
            params.setResponseDesc(response.get("ResponseDesc").toString());
        } catch (Exception e) {
            response.put("message", e);
        }
        electronicSignatureContract.insertSelective(createRequestContext(requests), params);
        return response;
    }

    //1020用户信息查询
    @RequestMapping(value = "/electronicSignature/userInfoQuery", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject userInfoQuery(HttpServletRequest requests, @RequestBody(required = false) EleSignUser params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI(APIConfigPath);
            response = electronicSignatureService.userInfoQuery(params);
        } catch (Exception e) {
            response.put("message", e);
        }
        return response;
    }

    //1021用户联系信息修改
    @RequestMapping(value = "/electronicSignature/alterUserInfo", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject alterUserInfo(HttpServletRequest requests, @RequestBody(required = false) EleSignUser params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI(APIConfigPath);
            response = electronicSignatureService.alterUserInfo(params);
        } catch (Exception e) {
            response.put("message", e);
        }
        int res = electronicSignatureService.updateByUserId(params.getUserId(),params.getEmail(),params.getPhoneNumber());
        return response;
    }


    @Autowired
    IElectronicSignatureVerify electronicSignatureVerify;

    //2001实名认证（银行卡四要素）
    @RequestMapping(value = "/electronicSignature/bankVerified", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject bankVerified(HttpServletRequest requests, @RequestBody(required = false) EleSignVerify params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI(APIConfigPath);
            response = electronicSignatureVerify.bankVerified(params);
            params.setTxId(response.get("txId").toString());
            params.setResponseCode(response.get("ResponseCode").toString());
            params.setAuthResult(response.get("authResult").toString());
            params.setResponseDesc(response.get("ResponseDesc").toString());
        } catch (Exception e) {
            response.put("message", e);
        }
        EleSignVerify result = electronicSignatureVerify.insertSelective(createRequestContext(requests), params);
        return response;
    }

    //2002实名认证(人脸)
    @RequestMapping(value = "/electronicSignature/faceVerified", method = RequestMethod.POST)
    @Timed
    public JSONObject faceVerified(HttpServletRequest requests) throws Exception {
        JSONObject response = new JSONObject();
        JSONObject param = new JSONObject();
        EleSignVerify params = new EleSignVerify();
        Enumeration<String> str = requests.getParameterNames();
        if (str != null) {
            while (str.hasMoreElements()) {
                String en = str.nextElement();
                String value = requests.getParameter(en);
                param.put(en, value);
            }
        }
        try {
            SignAPI.initAPI(APIConfigPath);
            boolean isMulti = ServletFileUpload.isMultipartContent(requests);
            String[] fileName = new String[2];
            String[] filePath = new String[2];
            if (!isMulti) {
                response.put("code", "E");
                response.put("error", "不支持的文件类型");
            }
            if (requests instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest req = (MultipartHttpServletRequest) requests;
                Map<String, MultipartFile> fileMap = req.getFileMap();
                int i = 0;
                if (fileMap != null) {
                    Iterator<Map.Entry<String, MultipartFile>> iterator = fileMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, MultipartFile> next = iterator.next();
                        MultipartFile filePart = next.getValue();
                        fileName[i] = filePart.getOriginalFilename();
                        InputStream inputStream = filePart.getInputStream();
                        byte[] bytes = IOUtils.toByteArray(inputStream);
                        filePath[i] = Base64.getEncoder().encodeToString(bytes);
                        i++;
                    }
                }
            }
            param.put("identificationImage", filePath[0]);
            param.put("selfieData", filePath[1]);
            response = electronicSignatureVerify.faceVerified(param);
            params.setIdentificationImage(fileName[0]);
            params.setSelfieData(fileName[1]);
            params.setTxId(response.get("txId").toString());
            params.setResponseCode(response.get("ResponseCode").toString());
            params.setAuthResult(response.get("selfieVerifyCode").toString());
            params.setSelfieVerifyInfo(response.get("selfieVerifyInfo").toString());
            params.setSelfieCompareWithIdCode(response.get("selfieCompareWithIdCode").toString());
            params.setSelfieCompareWithIdInfo(response.get("selfieCompareWithIdInfo").toString());
            params.setResponseDesc(response.get("ResponseDesc").toString());
            params.setPersonName(param.getString("personName"));
            params.setIdType(param.getString("idType"));
            params.setIdentificationNumber(param.getString("identificationNumber"));
        } catch (Exception e) {
            response.put("message", e);
        }
        EleSignVerify result = electronicSignatureVerify.insertSelective(createRequestContext(requests), params);
        return response;
    }

    //2003获取实名认证地址(人脸识别H5)
    @RequestMapping(value = "/electronicSignature/getVerifyAddress", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject getVerifyAddress(HttpServletRequest requests, @RequestBody(required = false) EleSignVerify params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI(APIConfigPath);
            response = electronicSignatureVerify.getVerifyAddress(params);
            params.setTxId(response.get("txId").toString());
            params.setResponseCode(response.get("ResponseCode").toString());
            params.setUrl(response.get("url").toString());
            params.setBizToken(response.get("bizToken").toString());
            params.setResponseDesc(response.get("ResponseDesc").toString());
        } catch (Exception e) {
            response.put("message", e);
        }
        EleSignVerify result = electronicSignatureVerify.insertSelective(createRequestContext(requests), params);
        return response;
    }

    //2004获取实名认证结果(人脸识别H5)
    @RequestMapping(value = "/electronicSignature/getVerifyResult", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject getVerifyResult(HttpServletRequest requests, @RequestBody(required = false) EleSignVerify params) throws Exception {
        JSONObject response = new JSONObject() ;
        try {
            SignAPI.initAPI(APIConfigPath);
            response = electronicSignatureVerify.getVerifyResult(params);
            params.setTxId(response.get("txId").toString());
            params.setResponseCode(response.get("ResponseCode").toString());
            params.setDetectInfo(response.getString("detectInfo"));
            params.setResponseDesc(response.get("ResponseDesc").toString());
        } catch (Exception e) {
            response.put("message", e);
        }
        EleSignVerify result = electronicSignatureVerify.insertSelective(createRequestContext(requests), params);
        return response;
    }

    //2005OCR文字识别
//    @RequestMapping(value = "/electronicSignature/ocrTextIdentify", method = RequestMethod.POST)
//    @Timed
//    public JSONObject ocrTextIdentify(HttpServletRequest requests) throws Exception {
//        JSONObject response = new JSONObject();
//        JSONObject param = new JSONObject();
//        EleSignVerify params = new EleSignVerify();
//        String fileName,filePath;
//        Enumeration<String> str = requests.getParameterNames();
//        if (str != null) {
//            while (str.hasMoreElements()) {
//                String en = str.nextElement();
//                String value = requests.getParameter(en);
//                param.put(en, value);
//            }
//        }
//        try {
//            SignAPI.initAPI(APIConfigPath);
//            boolean isMultipart = ServletFileUpload.isMultipartContent(requests);
//            if (!isMultipart) {
//                response.put("code", "E");
//                response.put("error", "不支持的文件类型");
//            }
//            if (requests instanceof MultipartHttpServletRequest) {
//                MultipartHttpServletRequest req = (MultipartHttpServletRequest) requests;
//                Map<String, MultipartFile> fileMap = req.getFileMap();
//                if (fileMap != null) {
//                    Iterator<Map.Entry<String, MultipartFile>> iterator = fileMap.entrySet().iterator();
//                    while (iterator.hasNext()) {
//                        Map.Entry<String, MultipartFile> next = iterator.next();
//                        MultipartFile filePart = next.getValue();
//                        fileName = filePart.getOriginalFilename();
//                        InputStream inputStream = filePart.getInputStream();
//                        byte[] bytes = IOUtils.toByteArray(inputStream);
//                        filePath = Base64.getEncoder().encodeToString(bytes);
//                    }
//                }
//            }
//            response = electronicSignatureVerify.ocrTextIdentify(param);
//            params.setTxId(response.get("txId").toString());
//            params.setResponseCode(response.get("ResponseCode").toString());
//            params.setSerialNumber(response.get("serialNumber").toString());
//            params.setWordsResult(response.get("wordsResult").toString());
//            params.setResponseDesc(response.get("ResponseDesc").toString());
//        } catch (Exception e) {
//            response.put("message", e);
//        }
//        EleSignVerify result = electronicSignatureVerify.insertSelective(createRequestContext(requests), params);
//        return response;
//    }

    //8001查询授权码
    @RequestMapping(value = "/electronicSignature/queryAuthCode", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject queryAuthCode(HttpServletRequest requests, @RequestBody(required = false) EleSignAuth params) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI(APIConfigPath);
            response = electronicSignatureAuth.queryAuthCode(params);
        } catch (Exception e) {
            response.put("message", e);
        }
        return response;
    }

    //9999测试交易
    @RequestMapping(value = "/electronicSignature/testEmpty", method = RequestMethod.POST)
    @Timed
    public JSONObject testEmpty(HttpServletRequest requests) throws Exception {
        JSONObject response = new JSONObject();
        try {
            SignAPI.initAPI(APIConfigPath);
            response = electronicSignatureService.testEmpty();
        } catch (Exception e) {
            response.put("message", e);
        }
        return response;
    }
}
