/**
 * gaoyang hls Component js
 */

function hlscomponent_min(id, id_i) {
    var hlsComponentObj = $('#' + id);
    var hlsheader_i = $('#' + id_i);
    hlsComponentObj.slideToggle("fast");
    hlsheader_i.toggleClass('fa fa-minus');
    hlsheader_i.toggleClass('fa fa-plus');
}

function hlscomponent_validate(id) {
    var obj = $("#" + id);
    var validatable = obj.kendoValidator({
        valid: function (e) {
            var input = e.input;
            var parent = input.parent();
            var parent_firstChild = parent[0].firstChild;
            if (e.valid) {
                if (input.hasClass("hls-inputfield-required")) {
                    input.removeClass("hls-inputfield-required");
                }
                if (parent && parent.hasClass("hls-inputfield-required")) {
                    parent.removeClass("hls-inputfield-required");
                }
                if (parent_firstChild && parent_firstChild.style) {
                    parent_firstChild.style.borderColor = "#ccc";
                }
            } else {
                input.addClass("hls-inputfield-required");
                if (parent) {
                    parent.addClass("hls-inputfield-required");
                }
                if (parent_firstChild && parent_firstChild.style) {
                    parent_firstChild.style.borderColor = "red";
                }
            }
        }
    });
}

function hlscomponent_gridadd(id) {
    $("#" + id).data('kendoGrid').addRow();
}

function hlscomponent_griddelete(id) {
    $("#" + id).data('kendoGrid').removeRow();
}

function hlscomponent_gridcustom1(id) {
}
function hlscomponent_gridcustom2(id) {
}
function hlscomponent_gridcustom3(id) {
}
function hlscomponent_gridcustom4(id) {
}
function hlscomponent_gridexcel(contextPath, id, view_model, viewModelData, controller_name, fileName, temp_div_id, dataSourceId, _csrf_token) {
    if (!view_model || !controller_name) {
        alert("excel数据源配置不完整！");
        return;
    }
    var exportConfig = {};
    var columns = [];
    var index = 0;
    var currengrid = $('#' + id).data("kendoGrid");
    for (var i = 0; i < currengrid.columns.length; i++) {
        var column = currengrid.columns[i];
        if (column.field != null) {
            var columnInfo = {};
            columnInfo["name"] = column.field;
            columnInfo["title"] = column.title;
            columnInfo["width"] = column.width;
            var align = $('tbody').find('tr')[0].getElementsByTagName('td')[i].style.textAlign;
            if (align != null || align != '') {
                columnInfo["align"] = align;
            }
            if (window[dataSourceId].options.schema.model.fields[column.field] != null) {
                columnInfo["type"] = window[dataSourceId].options.schema.model.fields[column.field].type;
            }
            columns[index] = columnInfo;
            index++;
        }
    }
    exportConfig["columnsInfo"] = columns;
    if (window[view_model][viewModelData]) {
        exportConfig["param"] = Hap.prepareQueryParameter(window[view_model][viewModelData].toJSON());
    } else {
        exportConfig["param"] = null;
    }
    exportConfig["fileName"] = fileName || 'temp';
    var $inputImg = $('<input>').attr({name: "config", value: kendo.stringify(exportConfig)});
    var $inputToken = $('<input>').attr({name: "_csrf", value: _csrf_token, type: "hidden"});
    //   var $inputSubmitBtn=$('<input>').attr({type:"submit",value:"submit"});
    var $form = $("<form>");
    $form.attr({
        target: '_self',
        method: 'post',
        action: contextPath + controller_name
    }).append($inputImg);
    $form.append($inputToken);
    //   $form.append($inputSubmitBtn);
    $form.id = 'smbForm';
    $('#' + temp_div_id).empty().append($form);//添加到隐藏div中
    $($form).submit();
    $('#' + temp_div_id).empty();
}

function hlscomponent_gridpdf(id) {
    alert('pdf');
}

function hlscomponent_gridquery(id, search_id) {
    if ($('#' + search_id).css('display') == 'none') {
        $('#' + search_id).show(500);
        $('.hlsgridbox-btn-detail').hide(500);
    } else {
        $('#' + search_id).hide(500);
        $('.hlsgridbox-btn-detail').show(500);
    }
}

function hlscomponent_gridsave(id) {
    $('#' + id).data('kendoGrid').saveChanges();
}

function hlscomponent_gridupload(id) {
}


/*calculate*/
(function () {
    var POW = Math.pow;
    // 乘法
    mul = function (a, b) {
        var m = 0, s1 = String(a), s2 = String(b), l1 = s1.indexOf('.'), l2 = s2
            .indexOf('.'), e1 = s1.indexOf('e'), e2 = s2.indexOf('e');
        if (e1 != -1) {
            m -= Number(s1.substr(e1 + 1));
            s1 = s1.substr(0, e1);
        }
        if (e2 != -1) {
            m -= Number(s2.substr(e2 + 1));
            s2 = s2.substr(0, e2);
        }
        if (l1 != -1)
            m += s1.length - l1 - 1;
        if (l2 != -1)
            m += s2.length - l2 - 1;
        return Number(s1.replace('.', '')) * Number(s2.replace('.', ''))
            / POW(10, m);
    }

    // 除法
    div = function (a, b) {
        var re = String(a / b), i = re.indexOf('.');
        if (i != -1) {
            re = Number(re).toFixed(16 - i - 1)
        }
        return Number(re);
    }

    // 加法
    plus = function (a, b) {
        var m1 = 0, m2 = 0, m3, s1 = String(a), s2 = String(b), l1 = s1
            .indexOf('.'), l2 = s2.indexOf('.'), e1 = s1.indexOf('e'), e2 = s2
            .indexOf('e');
        if (e1 != -1) {
            m1 -= Number(s1.substr(e1 + 1));
            s1 = s1.substr(0, e1);
        }
        if (e2 != -1) {
            m2 -= Number(s2.substr(e2 + 1));
            s2 = s2.substr(0, e2);
        }
        if (l1 != -1)
            m1 += s1.length - l1 - 1;
        if (l2 != -1)
            m2 += s2.length - l2 - 1;
        if (m2 > m1) {
            m3 = m2;
            m1 = m2 - m1;
            m2 = 0;
        } else if (m1 > m2) {
            m3 = m1;
            m2 = m1 - m2;
            m1 = 0;
        } else {
            m3 = m1;
            m1 = m2 = 0;
        }
        return (Number(s1.replace('.', '')) * POW(10, m1) + Number(s2.replace(
                '.', ''))
            * POW(10, m2))
            / POW(10, m3);
    }

    // 减法
    minus = function (a, b) {
        return plus(a, -b);
    }

    pow = function (a, b) {
        var re = String(POW(a, b)), i = re.indexOf('.');
        if (i != -1) {
            re = Number(re).toFixed(16 - i - 1)
        }
        return Number(re);
    }

    if (navigator.userAgent.indexOf("MSIE") == -1) {
        var _toFixed = Number.prototype.toFixed;
        Number.prototype.toFixed = function (deci) {
            var sf = this,
                s = sf + '',
                fix = new Array(deci).join('0') + 1;
            if (s.indexOf('e') != -1) {
                var arr = s.split('e');
                if (arr[1] < 0) {
                    if (arr[0].indexOf('.') == -1) {
                        arr[1] -= -arr[0].length;
                        arr[0] = '.' + arr[0];
                    }
                    return _toFixed.call(Number(arr[0] + fix + 'e' + arr[1]), deci);
                } else {
                    return _toFixed.call(sf, deci);
                }
            } else if (s.indexOf('.') == -1) {
                return _toFixed.call(sf, deci);
            } else {
                return _toFixed.call(Number(s + fix), deci);
            }
        }
    }
})();

/**
 * @summary Hel
 * @description 抽象通用函数
 * @version 1.0
 * @author yang.gao01@hand-china.com
 * @copyright Copyright Hand China Co.,Ltd.
 */
(function ($) {
    if (!window.Hls) {
        Hls = {
            version: '1.0',
            defaultPrompt: {}
        };
        /**
         * 打开功能性窗口
         * 函数描述
         * @param opts.menuCode 菜单代码，opts.title窗口描述，opts.url窗口地址，
         * opts.menuName菜单名称，opts.moduleFlag模块标志，opts.documentKey打开同一个功能时，识别不同单据的唯一标识，
         * opts.reflashFlag刷新标志，opts.moduleName模块名称，
         * @returns
         */
        Hls.openMenuWindow = function (opts) {
            if (opts.menuCode) {
                top.openTab(opts.menuCode, opts.title, opts.url, false, opts.menuName, opts.moduleFlag, opts.documentKey, opts.reflashFlag, opts.moduleName, false);
            }
        };
        /**
         * 关闭功能性窗口
         * 函数描述
         * @param opts.menuCode 菜单代码，
         * @returns
         */
        Hls.closeMenuWindow = function (opts) {
            var tabStrip = top.$('#moduleTab').data("kendoTabStrip");
            var obj = top.$('#moduleTab_ts_active');
            var currentFunction = null;
            if (!opts.menuCode) {
                $.each(obj, function (index, item) {
                    for (var i = 0; i < item.children.length; i++) {
                        if (item.children[i].className == 'k-link') {
                            currentFunction = item.children[i].attributes["data-tabid"].value;
                            break;
                        }
                    }
                    return false;
                });
            } else {
                currentFunction = opts.menuCode;
            }
            var tabidx = tabStrip.tabids.indexOf(currentFunction);
            if (tabidx != -1) {
                top.removeOpenFunctionArray(currentFunction);
                top.$('#bread-function').remove();
                tabStrip.remove(tabidx);
                tabStrip.select(tabidx - 1);
            }
        };
        Hls.openBarWindow = function (opts) {
            if (!opts.actions) {
                opts.actions = ["Maximize", "Minimize", "Close"];
            }
            if (!opts.iframe) {
                opts.iframe = true;
            }
            if (!opts.visible) {
                opts.visible = false;
            }
            if (!opts.modal) {
                opts.modal = true;
            }
            var currentContent = opts.content || opts.url || opts.winOptions.options.content.url.toString();
            opts.content = null;
            var currentWin = $("#" + opts.id).kendoWindow(opts).data("kendoWindow");
            if (opts.position == "center") {
                top.centerOpenWindow(currentWin, currentContent);
            } else {
                var currentSize = null;
                if (opts.size == "THIRD" || opts.size == "HALF" || opts.size == "FULL") {
                    currentSize = null;
                } else {
                    currentSize = opts.size;
                }
                top.topOpenWindow(currentWin, opts.size, currentContent, currentSize);
            }
        };
        Hls.setRequired = function (id, flag) {
            var field = $('#' + id);
            var requiredImageObj = $('#' + id + "-prompt-required");
            if (flag) {
                field.attr("required", true);
                requiredImageObj.addClass("hlsRequiredPromptImage");
            } else {
                field.removeAttr("required");
                requiredImageObj.removeClass("hlsRequiredPromptImage");
            }
        };
        Hls.setReadonly = function (id, flag) {
            var field = $('#' + id);
            var editor = field.data().handler.ns.replace(".", "");
            if (flag) {
                field.data(editor).enable(false);
            } else {
                field.data(editor).enable(true);
            }
        };
        Hls.exportPageExcel = function (opts) {
            var token = $('meta[name=_csrf]').attr('content');
            var contextPath = opts.contextPath || "",
                controller_name = opts.controller,
                fileName = opts.fileName,
                hlsPageId = opts.hlsPageId,
                param = opts.param || {},
                _csrf_token = token;
            if (!controller_name) {
                alert("excel数据源配置不完整！");
                return;
            }
            var exportConfig = {};
            exportConfig["columnsInfo"] = opts.pageConfig;
            exportConfig["param"] = param;
            exportConfig["fileName"] = fileName || 'temp';
            var $inputImg = $('<input>').attr({name: "config", value: kendo.stringify(exportConfig)});
            var $inputToken = $('<input>').attr({name: "_csrf", value: _csrf_token, type: "hidden"});
            //   var $inputSubmitBtn=$('<input>').attr({type:"submit",value:"submit"});
            var $form = $("<form>");
            $form.attr({
                target: '_self',
                method: 'post',
                action: contextPath + controller_name
            }).append($inputImg);
            $form.append($inputToken);
            //   $form.append($inputSubmitBtn);
            $form.id = 'smbForm';
            var parentdiv = $('<div></div>');        //创建一个父div
            parentdiv.appendTo('body');
            parentdiv.empty().append($form);//添加到隐藏div中
            $($form).submit();
            parentdiv.empty();
        };

        Hls.exportExcel = function (opts) {
            var contextPath = opts.contextPath,
                id = opts.id,
                view_model = opts.viewModel,
                viewModelData = opts.viewModelData,
                controller_name = opts.controller,
                fileName = opts.fileName,
                temp_div_id = opts.tempDivId,
                dataSourceId = opts.dataSourceId,
                _csrf_token = opts._csrf_token || token;
            if (!view_model || !controller_name) {
                alert("excel数据源配置不完整！");
                return;
            }
            var exportConfig = {};
            var columns = [];
            var index = 0;
            var currengrid = $('#' + id).data("kendoGrid");
            for (var i = 0; i < currengrid.columns.length; i++) {
                var column = currengrid.columns[i];
                if (column.field != null) {
                    var columnInfo = {};
                    columnInfo["name"] = column.field;
                    columnInfo["title"] = column.title;
                    columnInfo["width"] = column.width;
                    var align = $('tbody').find('tr')[0].getElementsByTagName('td')[i].style.textAlign;
                    if (align != null || align != '') {
                        columnInfo["align"] = align;
                    }
                    if (window[dataSourceId].options.schema.model.fields[column.field] != null) {
                        columnInfo["type"] = window[dataSourceId].options.schema.model.fields[column.field].type;
                    }
                    columns[index] = columnInfo;
                    index++;
                }
            }
            exportConfig["columnsInfo"] = columns;
            if (window[view_model][viewModelData]) {
                exportConfig["param"] = Hap.prepareQueryParameter(window[view_model][viewModelData].toJSON());
            } else {
                exportConfig["param"] = null;
            }
            exportConfig["fileName"] = fileName || 'temp';
            var $inputImg = $('<input>').attr({name: "config", value: kendo.stringify(exportConfig)});
            var $inputToken = $('<input>').attr({name: "_csrf", value: _csrf_token, type: "hidden"});
            //   var $inputSubmitBtn=$('<input>').attr({type:"submit",value:"submit"});
            var $form = $("<form>");
            $form.attr({
                target: '_self',
                method: 'post',
                action: contextPath + controller_name
            }).append($inputImg);
            $form.append($inputToken);
            //   $form.append($inputSubmitBtn);
            $form.id = 'smbForm';
            $('#' + temp_div_id).empty().append($form);//添加到隐藏div中
            $($form).submit();
            $('#' + temp_div_id).empty();
        };
        Hls.currentMaskObj = null;
        Hls.mask = function (opts) {
            var obj;
            if (opts && opts.id) {
                obj = $('#' + opts.id);
            } else {
                obj = $("body");
            }
            Hls.currentMaskObj = obj.mLoading(opts && opts.message || '正在执行。。。');
        };
        Hls.unmask = function (options) {
            if (Hls.currentMaskObj) {
                setTimeout(function () {
                    if (options && options.message) {
                        Hls.currentMaskObj = Hls.currentMaskObj.dom.mLoading(options.message);
                        setTimeout(function () {
                            Hls.currentMaskObj.destroy();
                        }, 500);
                    } else {
                        Hls.currentMaskObj.destroy();
                    }
                }, 1000);
            }
        };
        Hls.barWindowUnmask = function () {
            parent.$(".k-overlay").css('z-index', parseFloat(parent.$(".k-overlay").css("z-index")) - 2);
            top.$(".k-overlay").css('display', 'none');
        };
        Hls.getFunctionUrl = function (function_code) {
            for (var i = 0; i < top.gloab_menus.length; i++) {
                var gloab_menu = top.gloab_menus[i];
                if (gloab_menu['menu_code'] == function_code) {
                    return gloab_menu['url'];
                }
            }
        };
        Hls.getWindowObj = function (url) {
            var iframe = null;
            $.each(parent.$('iframe'), function (index, item) {
                if (item.src.indexOf(url) != -1) {
                    iframe = item;
                    return false;
                }
            });
            return iframe;
        };
        Hls.getWindowObjFromFun = function (function_code) {
            var iframe = null;
            $.each(parent.$('iframe'), function (index, item) {
                if (item.id == function_code || item.id == 'iframe_' + function_code) {
                    iframe = item;
                    return false;
                }
            });
            return iframe;
        };
        Hls.submitForm = function (opts) {
            Hap.submitForm(opts);
        };

        Hls.prepareQueryParameter = function (obj, options) {
            obj = obj || {};
            if (options) {
                obj.page = options.page;
                obj.pageSize = options.pageSize;
                if (options.sort && options.sort.length > 0) {
                    obj.sortname = options.sort[0].field;
                    obj.sortorder = options.sort[0].dir;
                }
            }
            for (var k in obj) {
                if (obj[k] === '' || obj[k] === null || obj[k] === undefined)
                    delete obj[k]
                if (obj[k] instanceof Date) {
                    obj[k] = obj[k].toJSON()
                }
            }
            return obj;
        };

        // jquery 通用提交
        Hls.submit = function (opt){
            $.ajax({
                async:opt.async || false,
                contentType:opt.contentType || "application/json",
                type:opt.type || "post",
                dataType:opt.dataType || "json",
                data:kendo.stringify(opt.data || {}),
                url:opt.url || '#',
                success:function(result){
                    if(opt.success){
                        opt.success(result);
                    }
                },
                error:function (result) {
                    if(opt.error){
                        opt.error(result);
                    }
                },
                complete:function(xhr,ts){
                    if(opt.complete){
                        opt.complete(xhr,ts);
                    }
                }
            });
        }

        Hls.showErrorMessage = function (message) {
            kendo.ui.showErrorDialog({
                title: "错误",
                message: (message || "未定义错误信息!")
            });
            throw new Error(message);
        };
        Hls.showInfoDialog = function (message,func) {
            kendo.ui.showInfoDialog({
                title: "提示",
                message: (message || "未定义提示信息!")
            }).done(function (e){
               if(func) func(e);
            });
        };

        /**
         *  校验input必输字段是否有值
         * @return  boolean
         */
        Hls.requireInputValidate = function(){
            var flag = true;
            $.each($("input[required]"),function (index,item){
               if(!item.value){
                   flag = false;
               }
            });
           return  flag;
        }


        Hls.paramsToURL = function(url,para){
            if (para){
                var arr = [];
                for (var n in para) {
                    if (para.hasOwnProperty(n) && para[n]) {
                        arr.push(encodeURIComponent(n) + "=" + encodeURIComponent(para[n]));
                    }
                }
                url = url + '?' +  arr.join('&');
            }
            return url;
        }

        /**
         * 遍历参数1对象上的属性，复制到参数2
         * @param source 源对象
         * @param target  目标对象
         */
        Hls.copyProperty = function (source,target){
            var isKendoObj = target.uid ? true : false;
            if(source && target && typeof source === 'object' && typeof target === 'object'){
                for(var v in source){
                    if(source.hasOwnProperty(v) && source[v] &&  typeof source[v]!== 'object' &&  typeof source[v]!== 'function'){
                        //如果是kendo对象就得用set赋值
                        if(isKendoObj){
                            target.set(v,source[v]);
                        }else{
                            target[v] = source[v];
                        }

                    }
                }
            }else{
                throw new Error("copyProperty():参数非法!");
            }
        }


        Hls.prepareQueryParameter = function (obj, options) {
            obj = obj || {};
            if (options) {
                obj.page = options.page;
                obj.pageSize = options.pageSize;
                if (options.sort && options.sort.length > 0) {
                    obj.sortname = options.sort[0].field;
                    obj.sortorder = options.sort[0].dir;
                }
            }
            for (var k in obj) {
                if (obj[k] === '' || obj[k] === null || obj[k] === undefined)
                    delete obj[k]
                if (obj[k] instanceof Date) {
                    obj[k] = obj[k].toJSON()
                }
            }
            return obj;
        };


        Hls.showConfirmDialog = function (message, comfirmFunc, cancelFunc) {
            kendo.ui.showConfirmDialog({
                title: '提示',
                message: (message || "未定义提示信息!")
            }).done(function (event) {
                if (event.button === 'OK') {
                    comfirmFunc();
                } else {
                    cancelFunc();
                }
            });
        };

        Hls.InitLayoutIframe= function (iframe) {
            if (iframe) {
                var iframeWin = iframe.contentWindow || iframe.contentDocument.parentWindow;
                if (iframeWin.document.body) {
                    iframe.height = iframeWin.document.documentElement.offsetHeight || iframeWin.document.body.offsetHeight;
                    iframe.width = iframeWin.document.documentElement.offsetWidth || iframeWin.document.body.offsetWidth;
                }
            }
        };

        Hls.initLayout = function (id) {
            var generatorComponent = ['dropdownlist', 'checkbox', 'radio', 'numerictextbox', 'datepicker', 'datetimepicker', 'timepicker', 'maskedtextbox', 'lov', 'combobox', 'tledit'];
            $.each(generatorComponent, function (i, roleName) {
                $(id).find('[data-role="' + roleName + '"]').each(function () {
                    var datas = $(this).data(), isInit = true;
                    for (var data in datas) {
                        if (data.toLowerCase() == "kendo" + roleName && typeof datas[data] == "object") {
                            isInit = false;
                            break;
                        }
                    }
                    if (isInit) {
                        kendo.init($(this));
                    }
                });
            });
            $.each($(".customTabs"), function (index, item) {
                var detail = $(item);
                detail.removeClass("customTabs");
                detail.addClass("hls-dashboard-tabs");
            });
            $.each($(".customTabContent"), function (index, item) {
                var detail = $(item);
                detail.removeClass("customTabContent");
                detail.addClass("hls-dashboard-tab-content");
            });
            $.each($(".customTabUl"), function (index, item) {
                var detail = $(item);
                detail.removeClass("customTabUl");
                detail.addClass("hls-dashboard-tab-ul");
            });
            $.each($(".customTabPane"), function (index, item) {
                var detail = $(item);
                detail.width("unset");
                detail.css("margin", "unset");
            });
            var iframeCount = 0;
            $.each($('div[data-dashboard]'), function (index, item) {
                var detail = $(item);
                var url = detail.attr("data-dashboard");
                var functionCode = detail.attr("data-functionCode");
                if (detail.hasClass("hls-dashboard-margin-left")) {
                    detail.removeClass("hls-dashboard-margin-left");
                    detail.addClass("hls-block-margin-left");
                }
                if (detail.hasClass("hls-dashboard-margin-top")) {
                    detail.removeClass("hls-dashboard-margin-top");
                    detail.addClass("hls-block-margin-top");
                }
                detail.removeClass("hls-dashboard-margin-top");
                detail.css("background-image", "none");
                detail.css("padding", "unset");
                var classList = detail[0].classList;
                for (var i = 0; i < classList.length; i++) {
                    var className = classList[i];
                    if (className.indexOf("hls-dashboard-width") != -1) {
                        detail.removeClass(className);
                        i--;
                        detail.addClass("hls-block-x" + className.substring(className.length - 1));
                    }
                    if (className.indexOf("hls-dashboard-height") != -1) {
                        detail.removeClass(className);
                        i--;
                        detail.addClass("hls-block-y" + className.substring(className.length - 1));
                    }
                }
                if (detail.attr("data-dashboard")) {
                    detail.append("<iframe id='layout_"+functionCode+"' frameborder='0' marginheight='0' marginwidth='0' class='data-dashboard-iframe' data-bashboard-src='" + url + "' scrolling='no' onload='Hls.InitLayoutIframe(this)'></iframe>");
                    iframeCount++;
                }
            });
            var iframeIndex = 0;
            var timer = setInterval(function () {
                var iframe = $("iframe[data-bashboard-src]").eq(iframeIndex);
                iframe.attr("src",iframe.attr("data-bashboard-src"));
                iframeIndex++;
                if (iframeIndex >= iframeCount) {
                    clearInterval(timer);
                    return;
                }
            }, 200);

        }

        Hls.getLayoutIframe = function(functionCode){
            return Hls.getWindowObjFromFun("layout_"+functionCode);
        }
    }
})(jQuery);