package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;

@UITag
public class HlsDisplayFormTextBox extends MaskedTextBox implements HlsComponent {

	public static final String PROPERTITY_HLSDISPLAYFORMTEXTBOX = "hlsDisplayFormTextBox";
	public static final String PROPERTITY_VALUEBIND = "valueBind";

	public String getValueBind() {
		return getPrototype().getString(PROPERTITY_VALUEBIND);
	}


	public static HlsDisplayFormTextBox createInstance() {
		XMap view = new XMap(DEFAULT_TAG_PREFIX, DEFAULT_NAME_SPACE,
				PROPERTITY_HLSDISPLAYFORMTEXTBOX);
		HlsDisplayFormTextBox hlsDisplayFormTextBox = new HlsDisplayFormTextBox();
		hlsDisplayFormTextBox.initPrototype(view);
		return hlsDisplayFormTextBox;
	}
	public void init(XMap view, ViewContext context) throws Exception {
		super.init(view, context);
		context.put(PROPERTITY_VALUEBIND, getValueBind());
		context.put(PROPERTITY_PRMOPTIMAGE, getPromptImage());
		context.put(PROPERTITY_PROMPTCOLSPAN, getPromptColspan());
		context.put(PROPERTITY_PROMPT, getPrompt());
		context.put(PROPERTITY_COLSPAN, getColSpan());
		context.put("bind", getBind());
		context.put("hlsStyle", getHlsStyle());
		context.put(PROPERTITY_HLSCLASSNAME, getHlsClassName());
		context.put(PROPERTITY_PROMPTCLASSNAME, getPromptClassName());
	}
	@Override
	public void hlsSetPropertity(Object key, Object value) {
		super.setPropertity(key, value);
	}

}
