package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.ScreenBuilder;
import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;

import java.util.List;

@UITag
public class Form extends Component {
	public static final String PROPERTITY_TITLE = "title";
	public static final String PROPERTITY_WIDTH = "width";
	public static final String PROPERTITY_HEIGHT = "height";
	public static final String PROPERTITY_FORMBODY = "formbody";
	public static final String PROPERTITY_HLSCLASSNAME = "hlsClassName";
	public static final String PROPERTITY_FORMTYPE = "formType";
	public static final String PROPERTITY_BINDMODULE = "bindModule";

	public static final String PROPERTITY_BTNTYPE = "btnType";
	public String getBtnType() {
		return getPrototype().getString(PROPERTITY_BTNTYPE);
	}

	public String getBindModule() {
		return getPrototype().getString(PROPERTITY_BINDMODULE);
	}

	public String getFormType() {
		return getPrototype().getString(PROPERTITY_FORMTYPE);
	}

	public void setHeight(String height) {
		setPropertity(PROPERTITY_TITLE, height);
	}

	public void setWidth(String width) {
		setPropertity(PROPERTITY_WIDTH, width);
	}

	public void setTitle(String title) {
		setPropertity(PROPERTITY_TITLE, title);
	}

	public void setHlsClassName(String HlsClassName) {
		setPropertity(PROPERTITY_HLSCLASSNAME, HlsClassName);
	}

	public String getHeight() {
		return getPrototype().getString(PROPERTITY_HEIGHT);
	}

	public String getWidth() {
		String width = getPrototype().getString(PROPERTITY_WIDTH);
		if (width == null) {
			width = "100%";
		}
		return width;
	}
	public String getTitle() {
		return getPrototype().getString(PROPERTITY_TITLE);
	}
	public String getHlsClassName() {
		return getPrototype().getString(PROPERTITY_HLSCLASSNAME);
	}
	public String getFormBody(ViewContext context) throws Exception {
		StringBuffer sb = new StringBuffer();
		List<XMap> list = getPrototype().getChildren();
        if(list != null){
            for (XMap map : list) {
                sb.append(ScreenBuilder.build(map, context));
            }
        }
		return sb.toString();
	}

	private void setHlsBtn(ViewContext context) {
		if (getBtnType() != null) {
			String[] datas = getBtnType().split(",");
			for (int i = 0; i < datas.length; i++) {
				String[] datas2 = datas[i].split(":");
				String btnType = datas2[0].trim().toUpperCase();
				context.put("BTN" + btnType, "Y");
				if(datas2.length==2) {
					String btnFunction = datas2[1].trim();
					context.put("BTF" + btnType,btnFunction );
				}
			}
		}
	}

	public void init(XMap view, ViewContext context) throws Exception {
		super.init(view, context);
		context.put(PROPERTITY_TITLE, getTitle());
		context.put(PROPERTITY_HEIGHT, getHeight());
		context.put(PROPERTITY_WIDTH, getWidth());
		context.put(PROPERTITY_HLSCLASSNAME, getHlsClassName());
		context.put(PROPERTITY_FORMBODY, getFormBody(context));
		context.put(PROPERTITY_FORMTYPE, getFormType());
		context.put(PROPERTITY_BINDMODULE, getBindModule());
		context.addJsonConfig(PROPERTITY_FORMTYPE,getFormType());
		setHlsBtn(context);
	}

}
