package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@UITag
public class Chart extends Component {
    public static final String PROPERTITY_CHARTTYPE= "chartType";
    public static final String PROPERTITY_CONTEXTPATH = "contextPath";
    public static final String PROPERTITY_HLSITEMS = "items";
    public static final String PROPERTITY_HLSDATASOURCE = "hlsDataSource";
    public static final String PROPERTITY_TITLE= "title";
    public static final String PROPERTITY_CHARTBTNTYPE= "chartBtnType";
    public static final String PROPERTITY_COLUMN= "column";
    public static final String PROPERTITY_COLOR= "color";
    public static final String PROPERTITY_BARCOLOR= "barColor";
    public static final String PROPERTITY_DESC_STYLE= "descStyle";
    public static final String PROPERTITY_CLICK_FUNCTION= "clickFunc";
    public static final String PROPERTITY_TITLEID = "titleId";
    public static final String PROPERTITY_CHARTID = "chartId";
    public static final String PROPERTITY_PERCENT = "percent";
    public static final String PROPERTITY_TRACKCOLOR = "trackColor";
    public static final String PROPERTITY_CHARTSTYLE= "chartStyle";
    public static final String PROPERTITY_TITLEIMG= "titleImg";
    public static final String PROPERTITY_HIDDENS= "hiddens";

    public Object getItems() {
        Items items = new Items();
        String paramMapArray = this.getPrototype().getString("items");
        XMap paramMapChild = this.getPrototype().getChild("items");
        ArrayList cList = new ArrayList();
        if(paramMapArray != null) {
            String[] var7 = paramMapArray.split(",");
            for(int var8 = 0; var8 < var7.length; ++var8) {
                var7[var8] = var7[var8].trim();
            }
            return var7;
        } else {
            if(paramMapChild != null) {
                List list = paramMapChild.getChildren();
                if(list != null) {
                    Iterator i = list.iterator();
                    while(i.hasNext()) {
                        XMap view = (XMap)i.next();
                        cList.add(ItemsMethod.parse(view));
                    }
                    return cList;
                }
            }
            return null;
        }
    }
    public void setItems(Items items) {
        XMap map = this.getPrototype().getChild("items");
        if(map == null) {
            map = this.getPrototype().createChild("h", "http://www.hand-china.com/hap", "items");
        }
        map.addChild(items.toXMap());
    }

    public String getColor(){return this.getPrototype().getString(PROPERTITY_COLOR);}
    public String getBarColor(){return this.getPrototype().getString(PROPERTITY_BARCOLOR);}
    public String getDescType(){return this.getPrototype().getString(PROPERTITY_DESC_STYLE);}
    public String getClickFunc(){return this.getPrototype().getString(PROPERTITY_CLICK_FUNCTION);}
    public String getContextPath(){return this.getPrototype().getString(PROPERTITY_CONTEXTPATH);}
    public String getChartBtnType(){return this.getPrototype().getString(PROPERTITY_CHARTBTNTYPE);}
    public String getTitle(){
        return this.getPrototype().getString(PROPERTITY_TITLE);
    }
    public String getHlsDataSource(){
        return this.getPrototype().getString(PROPERTITY_HLSDATASOURCE);
    }
    public String getChartType(){
        return this.getPrototype().getString(PROPERTITY_CHARTTYPE);
    }
    public String getColumn(){
        return this.getPrototype().getString(PROPERTITY_COLUMN);
    }
    public String getTitleId(){return this.getPrototype().getString(PROPERTITY_TITLEID);}
    public String getChartId(){return this.getPrototype().getString(PROPERTITY_CHARTID);}
    public String getPercent(){return this.getPrototype().getString(PROPERTITY_PERCENT);}
    public String getTrackColor(){return this.getPrototype().getString(PROPERTITY_TRACKCOLOR);}
    public String getChartStyle(){return this.getPrototype().getString(PROPERTITY_CHARTSTYLE);}
    public String getTitleImg(){return this.getPrototype().getString(PROPERTITY_TITLEIMG);}
    public String getHiddens(){
        return getPrototype().getString(PROPERTITY_HIDDENS);
    }


    public void init(XMap view, ViewContext context) throws Exception {
        super.init(view, context);
        context.put(PROPERTITY_CHARTTYPE,getChartType());
        context.put(PROPERTITY_CONTEXTPATH, context.getContextPath());
        context.put(PROPERTITY_HLSDATASOURCE, getHlsDataSource());
        context.put(PROPERTITY_TITLE,getTitle());
        context.put(PROPERTITY_COLUMN,getColumn());
        context.put(PROPERTITY_TITLE, getTitle());
        context.put(PROPERTITY_TITLE, getTitle());
        context.put(PROPERTITY_COLOR, getColor());
        context.put(PROPERTITY_BARCOLOR, getBarColor());
        context.put(PROPERTITY_DESC_STYLE, getDescType());
        context.put(PROPERTITY_CLICK_FUNCTION, getClickFunc());
        context.put(PROPERTITY_CHARTSTYLE,getChartStyle());
        context.put(PROPERTITY_TITLEIMG,getTitleImg());
        context.addJsonConfig("titleImg",getTitleImg());
        context.addJsonConfig("chartType",getChartType());
        context.addJsonConfig("items", getItems());
        context.addJsonConfig("chartBtnType", getChartBtnType());
        context.addJsonConfig("contextPath", getContextPath());
        context.addJsonConfig("title",getTitle());
        context.addJsonConfig("hlsDataSource",getHlsDataSource());
        context.addJsonConfig("id",getId());
        context.addJsonConfig("descStyle",getDescType());
        context.addJsonConfig("color",getColor());
        context.addJsonConfig("clickFunc",getClickFunc());
        context.put(PROPERTITY_TITLEID,getTitleId());
        context.addJsonConfig("titleId",getTitleId());
        context.put(PROPERTITY_CHARTID,getChartId());
        context.addJsonConfig("chartId",getChartId());
        context.put(PROPERTITY_PERCENT,getPercent());
        context.addJsonConfig("percent",getPercent());
        context.put(PROPERTITY_TRACKCOLOR,getTrackColor());
        context.addJsonConfig("trackColor",getTrackColor());
        setHiddens(context);

    }


    private void setHiddens(ViewContext context) {
        if (getHiddens() != null) {
            String[] datas = getHiddens().split(",");
            for (int i = 0; i < datas.length; i++) {
                context.put("HID"+datas[i].trim().toUpperCase(), "Y");
            }
        }
    }
}
