package com.hand.app.wflSend;



import com.hand.app.wflSend.service.IWflMessageSendService;
import com.hand.hap.job.AbstractJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import org.slf4j.Logger;


/**
 * Created by 晓兵 on 2018/10/30.
 */
public class wflMessageSend extends AbstractJob {
    private Logger logger = LoggerFactory.getLogger(wflMessageSend.class);
    @Autowired
    private IWflMessageSendService service;//业务类
    @Override
    public void safeExecute(JobExecutionContext jobExecutionContext) throws Exception {
        Exception exception = null;
       // String url = "http://106.14.194.11:8100/hlap_dr/modules/app/wfl_send/hls_app_wfl_send.svc";
        //map中可以获取上方定义的参数，key为参数名称，value为参数值
        JobDataMap map = jobExecutionContext.getMergedJobDataMap();
        String url = map.getString("svcUrl");
        try {
            service.get(url);
        } catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error(e.getMessage(), e);
            }

             exception = e;
            throw e;
        }
        if (exception != null) {
            setExecutionSummary(exception.getClass().getName() + ":" + exception.getMessage());
        } else {
            setExecutionSummary("执行完成！" );
        }

    }
    @Override
    public boolean isRefireImmediatelyWhenException() {
        //任务发生异常时候进行的动作
        //false 挂起当前JOB等待处理
        //true 继续执行
        return false;
    }

}
