package com.hand.app.hms.controllers;

import com.codahale.metrics.annotation.Timed;
import com.github.pagehelper.StringUtil;
import com.hand.app.hms.service.IHanvonService;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.exception.HapApiException;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.app.hms.service.impl.PureNetUtilImpl;
import com.alibaba.fastjson.JSONObject;
import com.hand.hap.system.service.ISysConfigService;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.*;


@Controller
@RequestMapping(value = "/r/api")
public class HanvonApiController extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(HanvonApiController.class);

    @Autowired
    IHapInterfaceHeaderService headerService;

    @Autowired
    ISysConfigService sysConfigService;

    @Autowired
    IHanvonService hanvonService;

    @RequestMapping(value = "/app/hanvon", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject sentRequest(HttpServletRequest request)
            throws HapApiException, IOException {
        String sysName = request.getParameter("sysName");
        String apiName = request.getParameter("apiName");
        String idCardPath = request.getParameter("cardPath");
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
        logger.info("return hapInterfaceHeader:{}", hapInterfaceHeader);
        String iftUrl = hapInterfaceHeader.getIftUrl();
        String hanvonKey = sysConfigService.getConfigValue("HANVON.KEY");
        String newUrl = iftUrl.replace("YOURKEY", hanvonKey);
        if (hapInterfaceHeader == null) {
            throw new HapApiException(HapApiException.ERROR_NOT_FOUND, "根据sysName和apiName没有找到数据");
        }
        if (!hapInterfaceHeader.getRequestFormat().equals("raw")) {
            throw new HapApiException(HapApiException.ERROR_REQUEST_FORMAT, "不支持的请求形式");
        }
        JSONObject json = new JSONObject();
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            boolean isMultipart = ServletFileUpload.isMultipartContent(request);
            if (!isMultipart) {
                json.put("error", "不支持的文件类型");
            }
            if (request instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest req = (MultipartHttpServletRequest) request;
                Map<String, MultipartFile> fileMap = req.getFileMap();
                if (fileMap != null) {
                    Iterator<Map.Entry<String, MultipartFile>> iterator = fileMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, MultipartFile> next = iterator.next();
                        String fileKey = next.getKey();
                        MultipartFile filePart = next.getValue();
                        Long size = filePart.getSize();
                        inputStream = filePart.getInputStream();
                        String fileName = UUID.randomUUID().toString().replace("-", "").toUpperCase();

                        //生成文件进入用于文件预览
                        String tomcatPath = sysConfigService.getConfigValue("HANVON.PICTURE.PATH");
                        File file = new File(tomcatPath);
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        tomcatPath += File.separator + fileName;
                        outputStream = new FileOutputStream(tomcatPath);
                        int len = -1;
                        byte[] bytes = new byte[1024];
                        while ((len = inputStream.read(bytes)) != -1) {
                            outputStream.write(bytes, 0, len);//写入
                        }
                        outputStream.flush();
                        outputStream.close();
                        inputStream.close();
                        String imageStr = PureNetUtilImpl.GetBase64(tomcatPath);
                        String uid = InetAddress.getLocalHost().getHostAddress();
                        String inboundParam = "";
                        if (StringUtil.isNotEmpty(idCardPath)) {
                            String idcardImage = PureNetUtilImpl.GetBase64(idCardPath);
                            inboundParam = "{\"uid\":\"" + uid + "\" ,\"idcardImage\":\"" + idcardImage + "\",\"faceImage\":\"" + imageStr + "\"}";
                        } else {
                            inboundParam = "{\"uid\":\"" + uid + "\" ,\"image\":\"" + imageStr + "\"}";
                        }
                        String url = hapInterfaceHeader.getDomainUrl() + newUrl;
                        json = hanvonService.post(inboundParam, url);
                        json.put("file_path", tomcatPath);
                    }
                }
            }

        } catch (Exception e) {
            logger.info(e.toString());
            json.put("error", e.getMessage());
        } finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return json;
    }


/*
    @RequestMapping(value = "/app/hanvon/faceid", method = RequestMethod.POST)
    @ResponseBody
    @Timed
    public JSONObject faceRequest(HttpServletRequest request)
            throws HapApiException, IOException {
        String sysName = request.getParameter("sysName");
        String apiName = request.getParameter("apiName");
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
        logger.info("return hapInterfaceHeader:{}", hapInterfaceHeader);
        String iftUrl = hapInterfaceHeader.getIftUrl();
        String hanvonKey = sysConfigService.getConfigValue("HANVON.KEY");
        String newUrl = iftUrl.replace("YOURKEY", hanvonKey);
        if (hapInterfaceHeader == null) {
            throw new HapApiException(HapApiException.ERROR_NOT_FOUND, "根据sysName和apiName没有找到数据");
        }
        if (!hapInterfaceHeader.getRequestFormat().equals("raw")) {
            throw new HapApiException(HapApiException.ERROR_REQUEST_FORMAT, "不支持的请求形式");
        }
        JSONObject json = new JSONObject();
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            boolean isMultipart = ServletFileUpload.isMultipartContent(request);
            if (!isMultipart) {
                json.put("error", "不支持的文件类型");
            }
            if (request instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest req = (MultipartHttpServletRequest) request;
                Map<String, MultipartFile> fileMap = req.getFileMap();
                if (fileMap != null) {
                    Iterator<Map.Entry<String, MultipartFile>> iterator = fileMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, MultipartFile> next = iterator.next();
                        String fileKey = next.getKey();
                        MultipartFile filePart = next.getValue();
                        Long size = filePart.getSize();
                        inputStream = filePart.getInputStream();
                        String fileName = UUID.randomUUID().toString().replace("-", "").toUpperCase();

                        //生成文件进入用于文件预览
                        String tomcatPath = sysConfigService.getConfigValue("HANVON.PICTURE.PATH");
                        File file = new File(tomcatPath);
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        tomcatPath += File.separator + fileName;
                        outputStream = new FileOutputStream(tomcatPath);
                        int len = -1;
                        byte[] bytes = new byte[1024];
                        while ((len = inputStream.read(bytes)) != -1) {
                            outputStream.write(bytes, 0, len);//写入
                        }
                        outputStream.flush();
                        outputStream.close();
                        inputStream.close();
                        String imageStr = PureNetUtilImpl.GetBase64(tomcatPath);
                        String uid = InetAddress.getLocalHost().getHostAddress();
                        String inboundParam = "{\"uid\":\"" + uid + "\" ,\"image\":\"" + imageStr + "\"}";
                        String url = hapInterfaceHeader.getDomainUrl() + newUrl;
                        json = hanvonService.post(inboundParam, url);
                    }
                }
            }

        } catch (Exception e) {
            logger.info(e.toString());
            json.put("error", e.getMessage());
        } finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return json;
    }*/

}
