package com.hand.app.faceCard.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.faceCard.dto.FaceCard;
import com.hand.app.faceCard.service.IFaceCardService;
import com.hand.app.faceCard.utils.HttpUtil;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.ISysConfigService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Service
public class FaceCardServiceImpl extends BaseServiceImpl<FaceCard> implements IFaceCardService {

    private static String CARD_URL = "http://faceid.shumaidata.com/face_idcard/verify";

    @Autowired
    ISysConfigService sysConfigService;

    // 阿里云的AK
    @Value("#{configProperties['face.check.enable']}")
    private String enableFace;

    @Override
    public JSONObject faceCheck(IRequest request, FaceCard faceCard) {
        JSONObject jsonResult = new JSONObject();

        JSONObject param = new JSONObject();
        param.put("idcard", faceCard.getIdNumber());
        param.put("image", faceCard.getFaceImage());
        param.put("name", faceCard.getName());
        //取appCode
        String appCode = sysConfigService.getConfigValue("ALY.FACEID.APPCODE");
        //发送http请求

        if (enableFace.equals("true")) {
            jsonResult = HttpUtil.postJson(CARD_URL, param, appCode);
        }

        return jsonToFace(jsonResult, faceCard);
    }

    JSONObject jsonToFace(JSONObject json, FaceCard face) {
        //ResponseData responseData = new ResponseData(false);
        //FaceCard face = JSONObject.parseObject(json.toJSONString(),FaceCard.class);
        JSONObject resultJson = new JSONObject();
        face.setFaceId(UUID.randomUUID().toString());
        if (json != null) {
            if (json.containsKey("code") && json.containsKey("message")) {
                face.setCode(json.getString("code"));
                face.setMessage(json.getString("message"));
            }
            if (json.containsKey("result")) {
                JSONObject result = json.getJSONObject("result");
                face.setRes(result.getString("res"));
                face.setDescription(result.getString("description"));
                if (result.containsKey("score")) {
                    face.setScore(result.getString("score"));
                }
                resultJson.put("return", json.getJSONObject("result"));
            }
            resultJson.put("code", "S");
            resultJson.put("message", "人证对比成功");
            if (enableFace.equals("false")) {
                JSONObject result = new JSONObject();
                result.put("score", "0.98232");
                resultJson.put("return", result);
            }
        } else {
            if (enableFace.equals("false")) {
                resultJson.put("code", "S");
                resultJson.put("message", "人证对比成功");
                JSONObject result = new JSONObject();
                result.put("score", "0.98232");
                resultJson.put("return", result);
            } else {
                resultJson.put("code", "E");
                resultJson.put("message", "人证对比失败");
            }

        }
        face.set__status("add");
        mapper.insertSelective(face);
        return resultJson;
    }
}
