package com.hand.app.esign.service.impl;


import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.system.dto.ResponseData;
import com.hand.app.esign.service.IFileDownloadService;
import com.hand.app.esign.utils.PDFHelper;
import com.hand.hap.system.service.ISysConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

@Service
public class FileDownloadServiceImpl implements IFileDownloadService {
    private final String FILE_NAME = "temp.pdf";
    private String pdf_path = null;
    @Autowired
    ISysConfigService sysConfigService;
    @Autowired
    IHapInterfaceHeaderService headerService;
    private Logger logger = LoggerFactory.getLogger(FileDownloadServiceImpl.class);

    @Override
    public ResponseData attachment(HttpServletRequest request, String attId) {
        String file_path = null;
        ResponseData responseData = new ResponseData(false);
        pdf_path = sysConfigService.getConfigValue("ESIGN.PDF.PATH");
        PDFHelper pdfhel = new PDFHelper();
        String apiName = request.getParameter("apiName");
        String sysName = request.getParameter("sysName");
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);

        String url = hapInterfaceHeader.getDomainUrl() + hapInterfaceHeader.getIftUrl();
        url = url + (url.indexOf("?") > 0 ? "&attachment_id=" : "?attachment_id=") + attId;
        //下载图片
        try {
            file_path = downloadFile(url, attId);
        } catch (Exception e) {
            logger.error("file download failed:{}", url);
            responseData.setMessage("file download error");
        }

        if (file_path == null || file_path.isEmpty()) {
            responseData.setMessage("file download error");
        } else {
            //转成图片
            pdf_path = pdf_path + File.separatorChar + attId;
            int pictrueLength = pdfhel.pdf2Image(file_path, pdf_path, 300);
            if (pictrueLength == 0) {
                responseData.setMessage("pdf to image error");
            } else {
                responseData.setSuccess(true);
                responseData.setMessage("" + pictrueLength + "");
            }
        }
        return responseData;

    }


    public String downloadFile(String url, String attId) {
        File file = null;
        String filePath = null;
        BufferedInputStream bin = null;
        OutputStream out = null;
        try {
            URL myURL = new URL(url);
            HttpURLConnection connection = (HttpURLConnection) myURL.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoInput(true);
            connection.connect();
            if (connection.getResponseCode() != 200) {
                throw new RuntimeException("HTTP GET Request Failed with Error code : " + connection.getResponseCode());
            }
            // 文件大小
            int fileLength = connection.getContentLength();
            logger.info("file length---->{}", fileLength);

            URLConnection con = myURL.openConnection();

            bin = new BufferedInputStream(connection.getInputStream());

            filePath = pdf_path + File.separatorChar + attId + File.separatorChar + FILE_NAME;
            file = new File(filePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            out = new FileOutputStream(file);
            int size = 0;
            int len = 0;
            byte[] buf = new byte[1024];
            while ((size = bin.read(buf)) != -1) {
                len += size;
                out.write(buf, 0, size);
            }
            bin.close();
            out.close();
        } catch (Exception e) {
            logger.error("file download failed:{}", e);
        } finally {
            return filePath;
        }

    }

}
