package com.hand.app.esign.dto;

import com.hand.hap.mybatis.annotation.ExtensionAttribute;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.app.esign.bean.AttachmentInfo;
import com.hand.app.esign.bean.SignPage;

import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: yang
 * Date: 2018/1/19
 * Time: 16:08
 */
@Table(name = "sign_info")
@ExtensionAttribute(disable = true)
public class SignInfo extends BaseDTO {

    @Id
    private String idNo;
    private String name;
    private String mobile;
    private String email;
    private String organ;
    private String title;
    private String address;
    private Integer personArea;

    private String sealData; // e签宝 签章内容
    private String accountId; // e签宝账户id

    @Transient
    private List<SignPage> userPages; // 用户签名信息

    @Transient
    private List<String> userKeys;

    @Transient
    private List<String> selfKeys;

    @Transient
    private List<SignPage> selfPages; // 平台签名信息@Transient
    @Transient
    private AttachmentInfo attachmentInfo; // 附件信息

    public List<String> getUserKeys() {
        return userKeys;
    }

    public void setUserKeys(List<String> userKeys) {
        this.userKeys = userKeys;
    }

    public List<String> getSelfKeys() {
        return selfKeys;
    }

    public void setSelfKeys(List<String> selfKeys) {
        this.selfKeys = selfKeys;
    }

    public AttachmentInfo getAttachmentInfo() {
        return attachmentInfo;
    }

    public void setAttachmentInfo(AttachmentInfo attachmentInfo) {
        this.attachmentInfo = attachmentInfo;
    }

    public List<SignPage> getUserPages() {
        return userPages;
    }

    public void setUserPages(List<SignPage> userPages) {
        this.userPages = userPages;
    }

    public List<SignPage> getSelfPages() {
        return selfPages;
    }

    public void setSelfPages(List<SignPage> selfPages) {
        this.selfPages = selfPages;
    }

    public String getIdNo() {
        return idNo;
    }

    public void setIdNo(String idNo) {
        this.idNo = idNo;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getOrgan() {
        return organ;
    }

    public void setOrgan(String organ) {
        this.organ = organ;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getPersonArea() {
        return personArea;
    }

    public void setPersonArea(Integer personArea) {
        this.personArea = personArea;
    }

    public String getSealData() {
        return sealData;
    }

    public void setSealData(String sealData) {
        this.sealData = sealData;
    }

    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }
}
