package com.hand.app.esign.controllers;

import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.hand.app.esign.service.IFileDownloadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * Created with IntelliJ IDEA.
 * User: yang
 * Date: 2018/1/17
 * Time: 13:50
 */
@Controller
@RequestMapping(value = {"/r/api","/"})
public class PDFImageController extends BaseController {
    @Autowired
    private IFileDownloadService fileDownloadService;

    @ResponseBody
    @RequestMapping("/app/pdf/png")
    public ResponseData signPdf(HttpServletRequest request, @RequestParam("attachment_id") String attId) {
        ResponseData responseData;
        try {
            responseData = fileDownloadService.attachment(request, attId);
        } catch (Exception e) {
            responseData = new ResponseData(false);
            responseData.setMessage("Unknown Error");
        }
        return responseData;
    }
}
