package com.hand.app.electronicSignature.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.hand.app.electronicSignature.mapper.EleSignUserMapper;
import com.hand.app.electronicSignature.service.IElectronicSignatureService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import constant.APIToolKitException;
import org.springframework.stereotype.Service;
import com.hand.app.electronicSignature.dto.EleSignUser;
import request.*;
import service.SignAPI;
import util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;

@Service
public class ElectronicSignatureServiceImpl extends BaseServiceImpl<EleSignUser> implements IElectronicSignatureService {
    //个人开户
    public JSONObject personalAccountOpen(EleSignUser param) throws Exception {
        JSONObject returnJson = new JSONObject();
        try {
            Tx1001Request tx1001Request = new Tx1001Request();
            tx1001Request.setPersonName(param.getPersonName());
            tx1001Request.setIdType(param.getIdType());
            tx1001Request.setIdentificationNumber(param.getIdentificationNumber());
            tx1001Request.setPhoneNumber(param.getPhoneNumber());
            tx1001Request.setEmail(param.getEmail());
            tx1001Request.setLocation(param.getLocation());
            String response = SignAPI.sendMessageAndGetResult(tx1001Request);
            returnJson.put("ResponseCode", StringUtil.getNodeText(response, "ResponseCode"));
            returnJson.put("ResponseDesc", StringUtil.getNodeText(response, "ResponseDesc"));
            returnJson.put("userId", StringUtil.getNodeText(response, "userID"));
            returnJson.put("txId", StringUtil.getNodeText(response, "TxID"));
        } catch (APIToolKitException e) {
            e.printStackTrace();
        }
        return returnJson;
    }

    //企业开户
    public JSONObject firmAccountOpen(EleSignUser param) throws Exception {
        JSONObject returnJson = new JSONObject();
        try {
            Tx1002Request tx1002Request = new Tx1002Request();
            tx1002Request.setFirmName(param.getFirmName());
            tx1002Request.setIdType(param.getFirmIdType());
            tx1002Request.setIdentificationNumber(param.getFirmIdNumber());
            tx1002Request.setLocation(param.getLocation());
            tx1002Request.setEmail(param.getEmail());
            tx1002Request.setPhoneNumber(param.getPhoneNumber());
            tx1002Request.setFirmTelephoneNumber(param.getFirmTelephoneNumber());
            tx1002Request.setFirmRepresentitiveName(param.getFirmRepresentitiveName());
            tx1002Request.setFirmRepresentitiveIdType(param.getFirmRepresentitiveIdType());
            tx1002Request.setFirmRepresentitiveId(param.getFirmRepresentitiveId());
            String response = SignAPI.sendMessageAndGetResult(tx1002Request);
            returnJson.put("ResponseCode", StringUtil.getNodeText(response, "ResponseCode"));
            returnJson.put("ResponseDesc", StringUtil.getNodeText(response, "ResponseDesc"));
            returnJson.put("txId", StringUtil.getNodeText(response, "TxID"));
            returnJson.put("userId", StringUtil.getNodeText(response, "userID"));
        } catch (APIToolKitException e) {
            e.printStackTrace();
        }
        return returnJson;
    }

    //1020用户信息查询
    public JSONObject userInfoQuery(EleSignUser param) throws Exception {
        JSONObject returnJson = new JSONObject();
        try {
            Tx1020Request tx1020Request = new Tx1020Request();
            tx1020Request.setUserId(param.getUserId());
            String response = SignAPI.sendMessageAndGetResult(tx1020Request);
            returnJson.put("ResponseCode", StringUtil.getNodeText(response, "ResponseCode"));
            returnJson.put("userName", StringUtil.getNodeText(response, "userName"));
            returnJson.put("idType", StringUtil.getNodeText(response, "idType"));
            returnJson.put("identificationNumber", StringUtil.getNodeText(response, "identificationNumber"));
            returnJson.put("userType", StringUtil.getNodeText(response, "userType"));
            returnJson.put("ResponseDesc", StringUtil.getNodeText(response, "ResponseDesc"));
            returnJson.put("txId", StringUtil.getNodeText(response, "TxID"));
            returnJson.put("userState", StringUtil.getNodeText(response, "userState"));
            returnJson.put("refuseReason", StringUtil.getNodeText(response, "refuseReason"));
            returnJson.put("email", StringUtil.getNodeText(response, "email"));
            returnJson.put("phoneNumber", StringUtil.getNodeText(response, "phoneNumber"));
        } catch (APIToolKitException e) {
            e.printStackTrace();
        }
        return returnJson;
    }

    //1021用户联系信息修改
    public JSONObject alterUserInfo(EleSignUser param) throws Exception {
        JSONObject returnJson = new JSONObject();
        try {
            Tx1021Request tx1021Request = new Tx1021Request();
            tx1021Request.setUserId(param.getUserId());
            tx1021Request.setEmail(param.getEmail());
            tx1021Request.setPhoneNumber(param.getPhoneNumber());
            String response = SignAPI.sendMessageAndGetResult(tx1021Request);
            returnJson.put("ResponseCode", StringUtil.getNodeText(response, "ResponseCode"));
            returnJson.put("txId", StringUtil.getNodeText(response, "TxID"));
            returnJson.put("ResponseDesc", StringUtil.getNodeText(response, "ResponseDesc"));
        } catch (APIToolKitException e) {
            e.printStackTrace();
        }
        return returnJson;
    }


    //9999测试交易
    public JSONObject testEmpty() throws Exception {
        JSONObject returnJson = new JSONObject();
        try {
            Tx9999Request tx9999Request = new Tx9999Request();
            String response = SignAPI.sendMessageAndGetResult(tx9999Request);
            returnJson.put("ResponseCode", StringUtil.getNodeText(response, "ResponseCode"));
            returnJson.put("txId", StringUtil.getNodeText(response, "TxID"));
            returnJson.put("ResponseDesc", StringUtil.getNodeText(response, "ResponseDesc"));
        } catch (APIToolKitException e) {
            e.printStackTrace();
        }
        return returnJson;
    }

    @Autowired
    private EleSignUserMapper eleSignUserMapper;

    @Override
    public int updateByUserId(String id, String email, String phone) {
        return eleSignUserMapper.updateByUserId(id, email, phone);
    }
}
