package com.hand.app.appManger.service.impl;

import com.hand.app.appManger.bean.AppRoleFunction;
import com.hand.app.appManger.mapper.AppRoleFunctionMapper;
import com.hand.app.appManger.service.IAppRoleFunctionService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;

import com.hand.hap.system.service.impl.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by Think-PC on 2018/3/14.
 */
@Service
public class AppRoleFunctionServiceImpl extends BaseServiceImpl<AppRoleFunction> implements IAppRoleFunctionService {
    private static Logger logger = LoggerFactory.getLogger(AppRoleFunctionServiceImpl.class);
    @Autowired
    private AppRoleFunctionMapper appRoleFunctionMapper;
    @Override
    public ResponseData getFunctionAll(IRequest iRequest, String roleCode, String appCode) {
        List<AppRoleFunction> functionAll = appRoleFunctionMapper.getFunctionAll(roleCode,appCode);
        return new ResponseData(functionAll);
    }
    @Override
    public ResponseData getModuleAllFunction(IRequest iRequest, String moduleId) {
        List<AppRoleFunction> functionAll = appRoleFunctionMapper.getModuleAllFunction(moduleId);
        return new ResponseData(functionAll);
    }

    @Override
    public ResponseData getModuleFunction(IRequest iRequest, String moduleId) {
        List<AppRoleFunction> functionAll = appRoleFunctionMapper.getModuleFunction(moduleId);
        return new ResponseData(functionAll);
    }
    @Override
    public ResponseData getSingModuleFunction(IRequest iRequest, String moduleId, String roleCode, String appCode){
        List<AppRoleFunction> functionAll = appRoleFunctionMapper.getRoleFunction(moduleId,roleCode,appCode);
        return new ResponseData(functionAll);
    }
}
