package com.chinapay.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.chinapay.comm.Constants;
import com.chinapay.dto.HclcCupSignInfo;
import com.chinapay.dto.HlsEbankCcbTransaction;
import com.chinapay.dto.HlsWsConfig;
import com.chinapay.mapper.HclcCupSignInfoMapper;
import com.chinapay.mapper.HlsEbankCcbTransactionMapper;
import com.chinapay.mapper.HlsWsConfigMapper;
import com.chinapay.secss.SecssConstants;
import com.chinapay.secss.SecssUtil;
import com.chinapay.service.IHclcChinaPayService;
import com.chinapay.util.HttpUtils;
import com.chinapay.util.StringUtil;
import com.hand.app.zhongDengWang.dto.HlsWsRequests;
import com.hand.app.zhongDengWang.mapper.HlsWsRequestsMapper;
import com.hand.hap.core.IRequest;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.*;
import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: lsy
 * Date: 2020/2/24
 * Time: 9:08
 */
@Service
public class HclcChinaPayServiceImpl extends BaseServiceImpl<HclcCupSignInfo> implements IHclcChinaPayService {

    @Autowired
    IHapInterfaceHeaderService headerService;

    /*签约短信状态*/
    public static final String sendNew = "SEND_NEW";
    public static final String sendSuccess = "SEND_SUCCESS";
    public static final String sendFail = "SEND_FAIL";

    /*签约状态*/
    public static final String signFail = "SING_FAIL";
    public static final String signSuccess = "SING_SUCCESS";

    /*交易类型*/
    public static final String cupSendMessage = "CUP_SEND_MESSAGE";
    public static final String cupSignSend = "CUP_SIGN_SEND";
    public static final String cupBatchUpload = "CUP_BATCH_UPLOAD";
    public static final String cupBatchQuery = "CUP_BATCH_QUERY";
    public static final String cupBatchDownload = "CUP_BATCH_DOWNLOAD";

    /*代扣交易状态*/
    public static final String transNew = "NEW";
    public static final String transDeal = "DEAL";
    public static final String transSuccess = "SUCCESS";
    public static final String transFail = "FAIL";


    @Value("${cup.mer.id}")
    private String cupMerId;
    @Value("${cup.upload.file.path}")
    private String cupUploadFilePath;
    @Value("${cup.download.file.path}")
    private String cupDownloadFilePath;
    @Value("${cup.init.file.path}")
    private String cupInitFilePath;
    @Autowired
    private HclcCupSignInfoMapper hclcCupSignInfoMapper;
    @Autowired
    private HlsWsRequestsMapper hlsWsRequestsMapper;
    @Autowired
    private HlsWsConfigMapper hlsWsConfigMapper;
    @Autowired
    private HlsEbankCcbTransactionMapper hlsEbankCcbTransactionMapper;

    private Logger logger = LoggerFactory.getLogger(getClass());

    public HclcChinaPayServiceImpl() {
    }

    private HclcCupSignInfo createCupSignInfo(IRequest iRequest, JSONObject cardTranDataJson) {
        HclcCupSignInfo hclcCupSignInfo = new HclcCupSignInfo();
        Map<String, String> additionMapFromJSON = JSONObject.parseObject(cardTranDataJson.toJSONString(), Map.class);
        StringUtil.setFieldValue4Bean(hclcCupSignInfo, additionMapFromJSON);
        hclcCupSignInfo.setStatus(sendNew);
        hclcCupSignInfoMapper.insertSelective(hclcCupSignInfo);

        return hclcCupSignInfo;
    }

    /***
     * 签约短信接口;
     * @param iRequest
     * @param params  签约短信接口
     ***/
    public JSONObject sendSignMessage(IRequest iRequest, JSONObject params) {

        JSONObject result = new JSONObject();

        Map<String, String> sendMap = new HashMap<String, String>();

        sendMap.put("Version", Constants.VERSION);
        sendMap.put("AccessType", "0");
        sendMap.put(Constants.MER_ID, cupMerId);
        String merOrderNo = UUID.randomUUID().toString().replace("-", "").toUpperCase();
        sendMap.put("MerOrderNo", merOrderNo);
        sendMap.put("TranDate", StringUtil.getRelevantDate(new Date()));
        sendMap.put("TranTime", StringUtil.getRelevantTime(new Date()));
        sendMap.put("BusiType", Constants.BUSI_TYPE);
        sendMap.put("TranType", Constants.TRAN_TYPE_0610);

        // 机构或商户接入
        String ownerId = cupMerId;
        // 获得签名加密类
        SecssUtil secssUtil = getSecssUtil(ownerId);

        // 构建卡信息保留域
        JSONObject cardTranDataJson = new JSONObject();
        cardTranDataJson.put("CardNo", params.getString("card_no").replace(" ", ""));
        cardTranDataJson.put("AccName", params.getString("acc_name").replace(" ", ""));
        cardTranDataJson.put("CertType", "01");
        cardTranDataJson.put("CertNo", params.getString("cert_no").replace(" ", ""));
        cardTranDataJson.put("MobileNo", params.getString("mobile_no").replace(" ", ""));
        cardTranDataJson.put("EntrstAuthNo", params.getString("cert_no").replace(" ", ""));
        cardTranDataJson.put("EntrstAmtLmt", "50000000");

        //测试由于测试环境日期原因往前调一天
        Date strDtT = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(strDtT);
        calendar.add(Calendar.DAY_OF_MONTH, -1);
        strDtT = calendar.getTime();

        cardTranDataJson.put("EntrstStrDtTm", StringUtil.getEntrstStrDtT(strDtT));
        cardTranDataJson.put("EntrstEndDtTm", StringUtil.yearAddNum(strDtT, 10));
        /*委托扣款时间单位 枚举值: 00-年，03-季，04-月，05-周，07-日*/
        cardTranDataJson.put("EntrstDtUnt", "07");
        /*委托扣款时间步长*/
        cardTranDataJson.put("EntrstDtStp", "9999");

        logger.info("send sign message start!");

        //创建签约记录
        HclcCupSignInfo hclcCupSignInfo = new HclcCupSignInfo();
        hclcCupSignInfo = createCupSignInfo(iRequest, cardTranDataJson);

        hclcCupSignInfo.setMerOrderNo(merOrderNo);
        hclcCupSignInfo.setMerId(cupMerId);

        try {
            String strCardTranData = null;

            if (Objects.nonNull(cardTranDataJson)) {
                strCardTranData = cardTranDataJson.toString();
                logger.info("加密前的卡保留域=" + strCardTranData);
                // 加密
                strCardTranData = Base64.encodeBase64String(strCardTranData.getBytes(Constants.ENCODING));
                secssUtil.encryptData(strCardTranData);
                if (SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                    strCardTranData = secssUtil.getEncValue();
                } else {
                    result.put(Constants.RESP_CODE, "E");
                    result.put("respMsg", "加密卡保留域失败，联系管理员！");
                    logger.info("加密卡保留域失败！" + secssUtil.getErrCode());
                    return result;
                }
            }

            if (strCardTranData != null) {
                sendMap.put(Constants.CARD_TRAN_DATA, strCardTranData);
            }

            // 签名
            secssUtil.sign(sendMap);
            if (SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                sendMap.put(Constants.SIGNATURE, secssUtil.getSign());
            } else {
                result.put(Constants.RESP_CODE, "E");
                result.put("respMsg", "签名失败，联系管理员！");
                logger.info("签名失败！");
                return result;
            }

            result = doSend(sendMap, secssUtil, cupSendMessage, hclcCupSignInfo.getSignId());

            if ("0000".equalsIgnoreCase(result.getString(Constants.RESP_CODE))) {
                hclcCupSignInfo.setStatus(sendSuccess);
            } else {
                hclcCupSignInfo.setStatus(sendFail);
            }

            hclcCupSignInfo.setRemark(result.getString(Constants.RESP_MSG));

        } catch (Exception e) {
            e.printStackTrace();
            logger.info("签约短信接口异常:" + e.getMessage());
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "签约短信接口异常，联系管理员！");
            hclcCupSignInfo.setStatus(sendFail);
        }

        hclcCupSignInfoMapper.updateByPrimaryKeySelective(hclcCupSignInfo);
        result.put("signId", hclcCupSignInfo.getSignId());

        return result;
    }

    /***
     * 签约接口;
     * @param iRequest
     * @param params  签约接口
     ***/
    public JSONObject sendSign(IRequest iRequest, JSONObject params) {

        JSONObject result = new JSONObject();

        if (Objects.isNull(params.get("signId"))) {
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "请求必须参数signId缺失，无法签约！");
            return result;
        }

        HclcCupSignInfo hclcCupSignInfo = new HclcCupSignInfo();
        hclcCupSignInfo.setSignId(params.getLong("signId"));
        hclcCupSignInfo = hclcCupSignInfoMapper.selectByPrimaryKey(hclcCupSignInfo);

        if (signSuccess.equalsIgnoreCase(hclcCupSignInfo.getStatus())) {
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "签约已完成，无需重复签约！");
            return result;
        }


        Map<String, String> sendMap = new HashMap<String, String>();

        sendMap.put("Version", Constants.VERSION);
        sendMap.put(Constants.MER_ID, hclcCupSignInfo.getMerId());
        sendMap.put("MerOrderNo", hclcCupSignInfo.getMerOrderNo());
        sendMap.put("TranDate", StringUtil.getRelevantDate(new Date()));
        sendMap.put("TranTime", StringUtil.getRelevantTime(new Date()));
        sendMap.put("BusiType", Constants.BUSI_TYPE);
        sendMap.put("TranType", Constants.TRAN_TYPE_9910);
        sendMap.put("MerBgUrl", "http://lease.hitachics.com/core/api/public/china/send/sign/listen");

        // 机构或商户接入
        String ownerId = cupMerId;
        // 获得签名加密类
        SecssUtil secssUtil = getSecssUtil(ownerId);

        // 构建卡信息保留域
        JSONObject cardTranDataJson = new JSONObject();
        cardTranDataJson.put("CardNo", hclcCupSignInfo.getCardNo());
        cardTranDataJson.put("AccName", hclcCupSignInfo.getAccName());
        cardTranDataJson.put("CertType", hclcCupSignInfo.getCertType());
        cardTranDataJson.put("CertNo", hclcCupSignInfo.getCertNo());
        cardTranDataJson.put("MobileNo", hclcCupSignInfo.getMobileNo());
        cardTranDataJson.put("EntrstAuthNo", hclcCupSignInfo.getCertNo());
        cardTranDataJson.put("EntrstAmtLmt", hclcCupSignInfo.getEntrstAmtLmt());
        cardTranDataJson.put("EntrstStrDtTm", hclcCupSignInfo.getEntrstStrDtTm());
        cardTranDataJson.put("EntrstEndDtTm", hclcCupSignInfo.getEntrstEndDtTm());
        /*委托扣款时间单位 枚举值: 00-年，03-季，04-月，05-周，07-日*/
        cardTranDataJson.put("EntrstDtUnt", hclcCupSignInfo.getEntrstDtUnt());
        /*委托扣款时间步长*/
        cardTranDataJson.put("EntrstDtStp", hclcCupSignInfo.getEntrstDtStp().toString());
        cardTranDataJson.put("MobileAuthCode", params.getString("auth_code"));

        String strCardTranData = null;

        try {
            logger.info("send sign start!");
            if (Objects.nonNull(cardTranDataJson)) {
                strCardTranData = cardTranDataJson.toString();
                logger.info("加密前的卡保留域=" + strCardTranData);
                // 加密
                strCardTranData = Base64.encodeBase64String(strCardTranData.getBytes(Constants.ENCODING));
                secssUtil.encryptData(strCardTranData);
                if (SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                    strCardTranData = secssUtil.getEncValue();
                } else {
                    result.put(Constants.RESP_CODE, "E");
                    result.put("respMsg", "加密卡保留域失败，联系管理员！");
                    logger.info("加密卡保留域失败!");
                    return result;
                }
            }

            if (strCardTranData != null) {
                sendMap.put(Constants.CARD_TRAN_DATA, strCardTranData);
            }

            // 构建交易扩展域
            JSONObject tranReservedJson = new JSONObject();
            tranReservedJson.put("SubTransType", "99100001");

//            String strTranReserved = null;
//
//            if (Objects.nonNull(tranReservedJson)) {
//                strTranReserved = tranReservedJson.toString();
//                logger.info(String.format("加密前的交易扩展域=%s", strTranReserved));
//                // 加密
//                strTranReserved = Base64.encodeBase64String(strTranReserved.getBytes(Constants.ENCODING));
//                secssUtil.encryptData(strTranReserved);
//                if (SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
//                    strTranReserved = secssUtil.getEncValue();
//                } else {
//                    result.put(Constants.RESP_CODE, "E");
//                    result.put("respMsg", "加密交易扩展域失败，联系管理员！");
//                    logger.info("加密交易扩展域失败!");
//                    return result;
//                }
//            }
//
//            if (strTranReserved != null) {
//                sendMap.put(Constants.TRAN_RESERVED, strTranReserved);
//            }
            sendMap.put(Constants.TRAN_RESERVED, tranReservedJson.toString());

            // 签名
            secssUtil.sign(sendMap);
            if (SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                sendMap.put(Constants.SIGNATURE, secssUtil.getSign());
            } else {
                result.put(Constants.RESP_CODE, "E");
                result.put("respMsg", "签名失败，联系管理员！");
                logger.info("签名失败!");
                return result;
            }

            result = doSend(sendMap, secssUtil, cupSignSend, hclcCupSignInfo.getSignId());

            if ("0000".equalsIgnoreCase(result.getString(Constants.RESP_CODE)) && "01".equalsIgnoreCase(result.getString("SignState"))) {
                hclcCupSignInfo.setStatus(signSuccess);
                hclcCupSignInfo.setProtocolNo(result.getJSONObject("CardTranData").getString("ProtocolNo"));
            } else {
                hclcCupSignInfo.setStatus(signFail);
            }

        } catch (Exception e) {
            e.printStackTrace();
            logger.info("签约接口异常:" + e.getMessage());
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "签约接口异常，联系管理员！");
            hclcCupSignInfo.setStatus(signFail);
        }

        hclcCupSignInfoMapper.updateByPrimaryKeySelective(hclcCupSignInfo);
        return result;
    }

    /***
     * 批量交易文件上传接口;
     * @param iRequest
     * @param params  批量交易文件上传接口
     ***/
    public JSONObject uploadBatch(IRequest iRequest, JSONObject params) {

        JSONObject result = new JSONObject();
        if (Objects.isNull(params.get("transaction_id"))) {
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "请求必须参数transaction_id缺失，无法上传！");
            return result;
        }


        HlsEbankCcbTransaction hlsEbankCcbTransaction = new HlsEbankCcbTransaction();
        hlsEbankCcbTransaction.setTransactionId(params.getLongValue("transaction_id"));
        hlsEbankCcbTransaction = hlsEbankCcbTransactionMapper.selectByPrimaryKey(hlsEbankCcbTransaction);

        if (!transNew.equalsIgnoreCase(hlsEbankCcbTransaction.getStatus())) {
            result.put(Constants.RESP_CODE, "E");
            result.put("respMsg", "批扣单据状态异常，批扣文件无法发送！");
            logger.info("批扣单据状态异常，批扣文件无法发送！");
            return result;
        }

        logger.info("upload batch start, transaction_id:" + hlsEbankCcbTransaction.getTransactionId());

        try {

            Map<String, String> sendMap = new HashMap<String, String>();
            sendMap.put("Version", Constants.VERSION);
            sendMap.put(Constants.MER_ID, cupMerId);
            sendMap.put("FileName", hlsEbankCcbTransaction.getSendFileName());
            sendMap.put("BusiType", Constants.BUSI_TYPE);

            String filepath = cupUploadFilePath + hlsEbankCcbTransaction.getSendFileName();

            //将获取批量代扣文件内容信息
            File file = new File(filepath);

            long fileSize = file.length();
            if (fileSize > Integer.MAX_VALUE) {
                System.out.println("file too big...");
                result.put(Constants.RESP_CODE, "E");
                result.put("respMsg", "批扣文件上传接口异常，上传文件太大！");
                logger.info("批扣文件上传接口异常，上传文件太大！");
                return result;
            }
            if (fileSize <= 0) {//如果文件太小
                result.put(Constants.RESP_CODE, "E");
                result.put("respMsg", "批扣文件上传接口异常，文件不存在！");
                logger.info("批扣文件上传接口异常，文件不存在！");
                return result;
            }

            FileInputStream fi = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader(fi, "UTF-8");
            BufferedReader br = new BufferedReader(reader);
            String readResult = "";
            String line;
            while ((line = br.readLine()) != null) {
                readResult += line;
                readResult += "\n";
            }
            br.close();
            reader.close();

            if (readResult.startsWith("\uFEFF")) {
                readResult = readResult.substring(1);
            }


            // 机构或商户接入
            String ownerId = cupMerId;
            // 获得签名加密类
            SecssUtil secssUtil = getSecssUtil(ownerId);
            String contentStr = secssUtil.encodeEnvelope(readResult.getBytes("UTF-8"));
            sendMap.put("FileContent", contentStr);

            secssUtil.sign(sendMap);
            if (SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                sendMap.put(Constants.SIGNATURE, secssUtil.getSign());
            } else {
                result.put(Constants.RESP_CODE, "E");
                result.put("respMsg", "签名失败，联系管理员！");
                logger.info("签名失败!");
                return result;
            }

            hlsEbankCcbTransaction.setVersion(sendMap.get("Version"));
            hlsEbankCcbTransaction.setTranDate(StringUtil.getRelevantDate(new Date()));
            hlsEbankCcbTransaction.setTranTime(StringUtil.getRelevantTime(new Date()));
            hlsEbankCcbTransaction.setTranType("0101");

            result = doSend(sendMap, secssUtil, cupBatchUpload, hlsEbankCcbTransaction.getTransactionId());

            if ("0014".equalsIgnoreCase(result.getString(Constants.RESP_CODE)) || "2043".equalsIgnoreCase(result.getString(Constants.RESP_CODE)) || "E".equalsIgnoreCase(result.getString(Constants.RESP_CODE))) {
                hlsEbankCcbTransaction.setStatus(transDeal);
                hlsEbankCcbTransaction.setOrderStatus("0001");
            } else {
                hlsEbankCcbTransaction.setStatus(transFail);
                hlsEbankCcbTransaction.setOrderStatus("0003");
            }

            hlsEbankCcbTransaction.setReturnCode(result.getString(Constants.RESP_CODE));
            hlsEbankCcbTransaction.setReturnMsg(result.getString(Constants.RESP_MSG));

        } catch (Exception e) {
            e.printStackTrace();
            logger.info("批量交易文件上传异常，" + e.getMessage());
            result.put(Constants.RESP_CODE, "E");
            result.put(Constants.RESP_MSG, "批量交易文件上传异常，联系管理员！");
            hlsEbankCcbTransaction.setStatus(transDeal);
        }


        hlsEbankCcbTransactionMapper.updateByPrimaryKeySelective(hlsEbankCcbTransaction);

        return result;
    }

    /***
     * 批量交易文件查询接口;
     * @param iRequest
     * @param params  批量交易文件查询接口
     ***/
    public JSONObject queryBatch(IRequest iRequest, JSONObject params) {

        JSONObject result = new JSONObject();
        if (Objects.isNull(params.get("transaction_id"))) {
            result.put(Constants.RESP_CODE, "E");
            result.put(Constants.RESP_MSG, "请求必须参数transaction_id缺失，无法查询！");
            return result;
        }

        HlsEbankCcbTransaction hlsEbankCcbTransaction = new HlsEbankCcbTransaction();
        hlsEbankCcbTransaction.setTransactionId(params.getLongValue("transaction_id"));
        hlsEbankCcbTransaction = hlsEbankCcbTransactionMapper.selectByPrimaryKey(hlsEbankCcbTransaction);

        Map<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("Version", Constants.VERSION);
        sendMap.put(Constants.MER_ID, cupMerId);
        sendMap.put("MerBatchId", hlsEbankCcbTransaction.getSendFileName().split("_")[2]);
        sendMap.put("MerBatchDate", hlsEbankCcbTransaction.getSendFileName().split("_")[1]);
        sendMap.put("BusiType", Constants.BUSI_TYPE);
        sendMap.put("TranType", Constants.TRAN_TYPE_0506);

        logger.info("query batch start, transaction_id:" + hlsEbankCcbTransaction.getTransactionId());

        try {
            // 机构或商户接入
            String ownerId = cupMerId;
            // 获得签名加密类
            SecssUtil secssUtil = getSecssUtil(ownerId);
            secssUtil.sign(sendMap);
            if (SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                sendMap.put(Constants.SIGNATURE, secssUtil.getSign());
            } else {
                result.put(Constants.RESP_CODE, "E");
                result.put(Constants.RESP_MSG, "签名失败，联系管理员！");
                logger.info("签名失败!");
                return result;
            }

            result = doSend(sendMap, secssUtil, cupBatchQuery, hlsEbankCcbTransaction.getTransactionId());

            if ("0000".equalsIgnoreCase(result.getString(Constants.RESP_CODE))) {
                String orderStatus = result.getString("OrderStatus");
                if ("0000".equalsIgnoreCase(orderStatus)) {
                    hlsEbankCcbTransaction.setBackFileName(result.getString("DownloadFileName"));
                } else if ("0003".equalsIgnoreCase(orderStatus) || "1002".equalsIgnoreCase(orderStatus)) {
                    hlsEbankCcbTransaction.setStatus(transFail);
                }
                hlsEbankCcbTransaction.setOrderStatus(orderStatus);
            } else if ("3441".equalsIgnoreCase(result.getString(Constants.RESP_CODE))) {
                hlsEbankCcbTransaction.setStatus(transFail);
            }

        } catch (Exception e) {
            e.printStackTrace();
            logger.info("批量交易文件查询异常!" + e.getMessage());
            result.put(Constants.RESP_CODE, "E");
            result.put(Constants.RESP_MSG, "批量交易文件查询异常，联系管理员！");
        }

        hlsEbankCcbTransactionMapper.updateByPrimaryKeySelective(hlsEbankCcbTransaction);

        return result;
    }

    /***
     * 批量交易文件下载接口;
     * @param iRequest
     * @param params  批量交易文件下载接口
     ***/
    public JSONObject downloadBatch(IRequest iRequest, JSONObject params) {

        JSONObject result = new JSONObject();
        if (Objects.isNull(params.get("transaction_id"))) {
            result.put(Constants.RESP_CODE, "E");
            result.put(Constants.RESP_MSG, "请求必须参数transaction_id缺失，无法下载！");
            return result;
        }

        HlsEbankCcbTransaction hlsEbankCcbTransaction = new HlsEbankCcbTransaction();
        hlsEbankCcbTransaction.setTransactionId(params.getLongValue("transaction_id"));
        hlsEbankCcbTransaction = hlsEbankCcbTransactionMapper.selectByPrimaryKey(hlsEbankCcbTransaction);


        Map<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("Version", Constants.VERSION);
        sendMap.put(Constants.MER_ID, cupMerId);
        sendMap.put("OriFileName", hlsEbankCcbTransaction.getSendFileName());
        sendMap.put("DownloadFileName", hlsEbankCcbTransaction.getBackFileName());

        logger.info("download batch start, transaction_id:" + hlsEbankCcbTransaction.getTransactionId());
        try {
            // 机构或商户接入
            String ownerId = cupMerId;
            // 获得签名加密类
            SecssUtil secssUtil = getSecssUtil(ownerId);
            secssUtil.sign(sendMap);
            if (SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                sendMap.put(Constants.SIGNATURE, secssUtil.getSign());
            } else {
                result.put(Constants.RESP_CODE, "E");
                result.put(Constants.RESP_MSG, "签名失败，联系管理员！");
                logger.info("签名失败!");
                return result;
            }

            result = doSend(sendMap, secssUtil, cupBatchDownload, hlsEbankCcbTransaction.getTransactionId());

            if ("0000".equalsIgnoreCase(result.getString(Constants.RESP_CODE))) {
                String fileData = result.getString("FileData");
                String filepath = cupDownloadFilePath + hlsEbankCcbTransaction.getBackFileName();
                FileOutputStream fos = new FileOutputStream(filepath);
                OutputStreamWriter write = new OutputStreamWriter(fos, "UTF-8");
                BufferedWriter writer = new BufferedWriter(write);
                writer.write(fileData);
                writer.close();
                hlsEbankCcbTransaction.setFileFlag("1");
                hlsEbankCcbTransactionMapper.updateByPrimaryKeySelective(hlsEbankCcbTransaction);
                result.remove("FileData");
            }

        } catch (Exception e) {
            e.printStackTrace();
            logger.info("批量交易文件下载接口异常" + e.getMessage());
            result.put(Constants.RESP_CODE, "E");
            result.put(Constants.RESP_MSG, "批量交易文件下载接口异常，联系管理员！");
        }

        return result;
    }

    /***
     * 通用发送接口;
     * @param
     * @param sendMap  通用发送接口
     ***/
    public JSONObject doSend(Map<String, String> sendMap, SecssUtil secssUtil, String functionName, Long pkValue) throws UnsupportedEncodingException {

        JSONObject resultJson = new JSONObject();
        JSONObject requestJson = new JSONObject();

        for (String key : sendMap.keySet()) {
            String value = sendMap.get(key);
            if (value == null) {
                value = "null";
            }
            value = value.trim();
            requestJson.put(key, value);
        }

        //获取配置url信息
        HlsWsConfig hlsWsConfig = new HlsWsConfig();
        List<HlsWsConfig> configs = new ArrayList<>();
        hlsWsConfig.setConfigName(functionName);
        configs = hlsWsConfigMapper.select(hlsWsConfig);
        if (Objects.nonNull(configs) && configs.size() > 0) {
            hlsWsConfig = configs.get(0);
        } else {
            resultJson.put(Constants.RESP_CODE, "E");
            resultJson.put(Constants.RESP_MSG, "发送请求失败，请求地址信息：" + functionName + "未定义");
            logger.info("发送请求失败，请求地址信息: {} 未定义！", functionName);
            return resultJson;
        }

        //初始化日志
        HlsWsRequests hlsWsRequests = logInterfaceRequest(functionName, hlsWsConfig.getWsdlAddress(), requestJson.toString(), pkValue);
        logger.info("发送请求,请求参数: {}", requestJson.toString());

        String result = "";
        try {
            result = HttpUtils.sendJson(hlsWsConfig.getWsdlAddress(), requestJson, Constants.ENCODING);
            logger.info("发送请求结果: {} ", result);
        } catch (Exception e) {
            e.printStackTrace();
            logger.info("发送请求异常: {} ", e.getMessage());
            resultJson.put(Constants.RESP_CODE, "E");
            resultJson.put(Constants.RESP_MSG, "发送请求异常，异常原因" + e.getMessage());
            hlsWsRequests.setReturnStatus("E");
            hlsWsRequests.setResponsedDate(new Date());
            hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
            return resultJson;
        }

        Map<String, String> retMap = JSONObject.parseObject(result, Map.class);

        hlsWsRequests.setResponseClob(result);
        hlsWsRequests.setReturnStatus("S");
        hlsWsRequests.setResponsedDate(new Date());
        hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);

        //验签
        String sign = retMap.get(Constants.SIGNATURE);
        if (StringUtil.isNotEmpty(sign)) {
            secssUtil.verify(retMap);
        }

        if ((Objects.isNull(retMap.get(Constants.RESP_CODE)))) {
            //TODO:抛异常
            resultJson.put(Constants.RESP_CODE, "E");
            resultJson.put(Constants.RESP_MSG, "请求返回结果未发现验签验签信息，请联系系统管理员");
            logger.info("请求返回结果未发现验签验签信息");
            return resultJson;
        }

        for (Map.Entry<String, String> entry : retMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtil.isEmpty(value)) {
                continue;
            }

            // 解密交易保留域
            if (Constants.CARD_TRAN_DATA.equals(key)) {
                secssUtil.decryptData(value);
                if (SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                    value = secssUtil.getDecValue();
                    // value = new String(Base64.decodeBase64(value),
                    // Constants.ENCODING);
                } else {
                }
            }
            // 解密风控保留域
            if (Constants.RISK_DATA.equals(key)) {
                secssUtil.decryptData(value);
                if (SecssConstants.SUCCESS.equals(secssUtil.getErrCode())) {
                    value = secssUtil.getDecValue();
                    // value = new String(Base64.decodeBase64(value),
                    // Constants.ENCODING);
                } else {

                }
            }
            // 解密文件内容
            if (Constants.FILE_DATA.equals(key)) {
                byte[] bytes = secssUtil.decodeEnvelope(value);
                value = new String(bytes, "UTF-8");

            }
            resultJson.put(key, value);
        }

        hlsWsRequests.setResponseClob(resultJson.toString());
        hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);

        return resultJson;
    }

    /**
     * 加载安全秘钥 .
     *
     * @param ownerId 所有者id
     * @return SecssUtil .
     */
    protected SecssUtil getSecssUtil(String ownerId) {
        String path = String.format("%s%s.properties", cupInitFilePath, ownerId);
        SecssUtil secssUtil = new SecssUtil(true);
        secssUtil.init(path);
        return secssUtil;
    }

    private String getTableName(String functionName) {
        String tableName = "";
        if ("CUP_SIGN_SEND".equalsIgnoreCase(functionName) || "CUP_SEND_MESSAGE".equalsIgnoreCase(functionName)) {
            tableName = "HCLC_CUP_SIGN_INFO";
        } else if ("CUP_BATCH_UPLOAD".equalsIgnoreCase(functionName) || "CUP_BATCH_QUERY".equalsIgnoreCase(functionName) || "CUP_BATCH_DOWNLOAD".equalsIgnoreCase(functionName)) {
            tableName = "HLS_EBANK_CCB_TRANSACTION";
        }

        return tableName;

    }

    public HlsWsRequests logInterfaceRequest(String functionName, String url, String request, Long pkValue) {

        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests.setRequestDate(new Date());
        hlsWsRequests.setRequestWsdlUrl(url);
        hlsWsRequests.setFunctionName(functionName);

        String tableName = getTableName(functionName);
        hlsWsRequests.setTableName(tableName);
        hlsWsRequests.setStatusCode("1");
        hlsWsRequests.setStatusDate(new Date());
        hlsWsRequests.setPkValue(pkValue);
        hlsWsRequests.setRequestClob(request);
        hlsWsRequestsMapper.insertSelective(hlsWsRequests);

        return hlsWsRequests;
    }
}
