/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.bean;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import me.chanjar.weixin.common.util.ToStringUtils;
import me.chanjar.weixin.common.util.xml.XStreamCDataConverter;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import me.chanjar.weixin.cp.util.crypto.WxCpCryptUtil;
import me.chanjar.weixin.cp.util.xml.XStreamTransformer;
import org.apache.commons.io.IOUtils;

@XStreamAlias(value="xml")
public class WxCpXmlMessage
implements Serializable {
    private static final long serialVersionUID = -1042994982179476410L;
    @XStreamAlias(value="AgentID")
    private Integer agentId;
    @XStreamAlias(value="ToUserName")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String toUserName;
    @XStreamAlias(value="FromUserName")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String fromUserName;
    @XStreamAlias(value="CreateTime")
    private Long createTime;
    @XStreamAlias(value="MsgType")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String msgType;
    @XStreamAlias(value="Content")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String content;
    @XStreamAlias(value="MsgId")
    private Long msgId;
    @XStreamAlias(value="PicUrl")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String picUrl;
    @XStreamAlias(value="MediaId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String mediaId;
    @XStreamAlias(value="Format")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String format;
    @XStreamAlias(value="ThumbMediaId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String thumbMediaId;
    @XStreamAlias(value="Location_X")
    private Double locationX;
    @XStreamAlias(value="Location_Y")
    private Double locationY;
    @XStreamAlias(value="Scale")
    private Double scale;
    @XStreamAlias(value="Label")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String label;
    @XStreamAlias(value="Title")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String title;
    @XStreamAlias(value="Description")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String description;
    @XStreamAlias(value="Url")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String url;
    @XStreamAlias(value="Event")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String event;
    @XStreamAlias(value="EventKey")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String eventKey;
    @XStreamAlias(value="Ticket")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String ticket;
    @XStreamAlias(value="Latitude")
    private Double latitude;
    @XStreamAlias(value="Longitude")
    private Double longitude;
    @XStreamAlias(value="Precision")
    private Double precision;
    @XStreamAlias(value="Recognition")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String recognition;
    @XStreamAlias(value="Status")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String status;
    @XStreamAlias(value="TotalCount")
    private Integer totalCount;
    @XStreamAlias(value="FilterCount")
    private Integer filterCount;
    @XStreamAlias(value="SentCount")
    private Integer sentCount;
    @XStreamAlias(value="ErrorCount")
    private Integer errorCount;
    @XStreamAlias(value="ScanCodeInfo")
    private ScanCodeInfo scanCodeInfo = new ScanCodeInfo();
    @XStreamAlias(value="SendPicsInfo")
    private SendPicsInfo sendPicsInfo = new SendPicsInfo();
    @XStreamAlias(value="SendLocationInfo")
    private SendLocationInfo sendLocationInfo = new SendLocationInfo();

    protected static WxCpXmlMessage fromXml(String xml) {
        xml = xml.replace("</PicList><PicList>", "");
        return XStreamTransformer.fromXml(WxCpXmlMessage.class, xml);
    }

    protected static WxCpXmlMessage fromXml(InputStream is) {
        return XStreamTransformer.fromXml(WxCpXmlMessage.class, is);
    }

    public static WxCpXmlMessage fromEncryptedXml(String encryptedXml, WxCpConfigStorage wxCpConfigStorage, String timestamp, String nonce, String msgSignature) {
        WxCpCryptUtil cryptUtil = new WxCpCryptUtil(wxCpConfigStorage);
        String plainText = cryptUtil.decrypt(msgSignature, timestamp, nonce, encryptedXml);
        return WxCpXmlMessage.fromXml(plainText);
    }

    public static WxCpXmlMessage fromEncryptedXml(InputStream is, WxCpConfigStorage wxCpConfigStorage, String timestamp, String nonce, String msgSignature) {
        try {
            return WxCpXmlMessage.fromEncryptedXml(IOUtils.toString((InputStream)is, (String)"UTF-8"), wxCpConfigStorage, timestamp, nonce, msgSignature);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String toString() {
        return ToStringUtils.toSimpleString((Object)this);
    }

    public Integer getAgentId() {
        return this.agentId;
    }

    public String getToUserName() {
        return this.toUserName;
    }

    public String getFromUserName() {
        return this.fromUserName;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getContent() {
        return this.content;
    }

    public Long getMsgId() {
        return this.msgId;
    }

    public String getPicUrl() {
        return this.picUrl;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getFormat() {
        return this.format;
    }

    public String getThumbMediaId() {
        return this.thumbMediaId;
    }

    public Double getLocationX() {
        return this.locationX;
    }

    public Double getLocationY() {
        return this.locationY;
    }

    public Double getScale() {
        return this.scale;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrl() {
        return this.url;
    }

    public String getEvent() {
        return this.event;
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public String getTicket() {
        return this.ticket;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getPrecision() {
        return this.precision;
    }

    public String getRecognition() {
        return this.recognition;
    }

    public String getStatus() {
        return this.status;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public Integer getFilterCount() {
        return this.filterCount;
    }

    public Integer getSentCount() {
        return this.sentCount;
    }

    public Integer getErrorCount() {
        return this.errorCount;
    }

    public ScanCodeInfo getScanCodeInfo() {
        return this.scanCodeInfo;
    }

    public SendPicsInfo getSendPicsInfo() {
        return this.sendPicsInfo;
    }

    public SendLocationInfo getSendLocationInfo() {
        return this.sendLocationInfo;
    }

    public void setAgentId(Integer agentId) {
        this.agentId = agentId;
    }

    public void setToUserName(String toUserName) {
        this.toUserName = toUserName;
    }

    public void setFromUserName(String fromUserName) {
        this.fromUserName = fromUserName;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setMsgId(Long msgId) {
        this.msgId = msgId;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setThumbMediaId(String thumbMediaId) {
        this.thumbMediaId = thumbMediaId;
    }

    public void setLocationX(Double locationX) {
        this.locationX = locationX;
    }

    public void setLocationY(Double locationY) {
        this.locationY = locationY;
    }

    public void setScale(Double scale) {
        this.scale = scale;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public void setPrecision(Double precision) {
        this.precision = precision;
    }

    public void setRecognition(String recognition) {
        this.recognition = recognition;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public void setFilterCount(Integer filterCount) {
        this.filterCount = filterCount;
    }

    public void setSentCount(Integer sentCount) {
        this.sentCount = sentCount;
    }

    public void setErrorCount(Integer errorCount) {
        this.errorCount = errorCount;
    }

    public void setScanCodeInfo(ScanCodeInfo scanCodeInfo) {
        this.scanCodeInfo = scanCodeInfo;
    }

    public void setSendPicsInfo(SendPicsInfo sendPicsInfo) {
        this.sendPicsInfo = sendPicsInfo;
    }

    public void setSendLocationInfo(SendLocationInfo sendLocationInfo) {
        this.sendLocationInfo = sendLocationInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpXmlMessage)) {
            return false;
        }
        WxCpXmlMessage other = (WxCpXmlMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$agentId = this.getAgentId();
        Integer other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !((Object)this$agentId).equals(other$agentId)) {
            return false;
        }
        String this$toUserName = this.getToUserName();
        String other$toUserName = other.getToUserName();
        if (this$toUserName == null ? other$toUserName != null : !this$toUserName.equals(other$toUserName)) {
            return false;
        }
        String this$fromUserName = this.getFromUserName();
        String other$fromUserName = other.getFromUserName();
        if (this$fromUserName == null ? other$fromUserName != null : !this$fromUserName.equals(other$fromUserName)) {
            return false;
        }
        Long this$createTime = this.getCreateTime();
        Long other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Long this$msgId = this.getMsgId();
        Long other$msgId = other.getMsgId();
        if (this$msgId == null ? other$msgId != null : !((Object)this$msgId).equals(other$msgId)) {
            return false;
        }
        String this$picUrl = this.getPicUrl();
        String other$picUrl = other.getPicUrl();
        if (this$picUrl == null ? other$picUrl != null : !this$picUrl.equals(other$picUrl)) {
            return false;
        }
        String this$mediaId = this.getMediaId();
        String other$mediaId = other.getMediaId();
        if (this$mediaId == null ? other$mediaId != null : !this$mediaId.equals(other$mediaId)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$thumbMediaId = this.getThumbMediaId();
        String other$thumbMediaId = other.getThumbMediaId();
        if (this$thumbMediaId == null ? other$thumbMediaId != null : !this$thumbMediaId.equals(other$thumbMediaId)) {
            return false;
        }
        Double this$locationX = this.getLocationX();
        Double other$locationX = other.getLocationX();
        if (this$locationX == null ? other$locationX != null : !((Object)this$locationX).equals(other$locationX)) {
            return false;
        }
        Double this$locationY = this.getLocationY();
        Double other$locationY = other.getLocationY();
        if (this$locationY == null ? other$locationY != null : !((Object)this$locationY).equals(other$locationY)) {
            return false;
        }
        Double this$scale = this.getScale();
        Double other$scale = other.getScale();
        if (this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        String this$eventKey = this.getEventKey();
        String other$eventKey = other.getEventKey();
        if (this$eventKey == null ? other$eventKey != null : !this$eventKey.equals(other$eventKey)) {
            return false;
        }
        String this$ticket = this.getTicket();
        String other$ticket = other.getTicket();
        if (this$ticket == null ? other$ticket != null : !this$ticket.equals(other$ticket)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Double this$precision = this.getPrecision();
        Double other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
            return false;
        }
        String this$recognition = this.getRecognition();
        String other$recognition = other.getRecognition();
        if (this$recognition == null ? other$recognition != null : !this$recognition.equals(other$recognition)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Integer this$totalCount = this.getTotalCount();
        Integer other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        Integer this$filterCount = this.getFilterCount();
        Integer other$filterCount = other.getFilterCount();
        if (this$filterCount == null ? other$filterCount != null : !((Object)this$filterCount).equals(other$filterCount)) {
            return false;
        }
        Integer this$sentCount = this.getSentCount();
        Integer other$sentCount = other.getSentCount();
        if (this$sentCount == null ? other$sentCount != null : !((Object)this$sentCount).equals(other$sentCount)) {
            return false;
        }
        Integer this$errorCount = this.getErrorCount();
        Integer other$errorCount = other.getErrorCount();
        if (this$errorCount == null ? other$errorCount != null : !((Object)this$errorCount).equals(other$errorCount)) {
            return false;
        }
        ScanCodeInfo this$scanCodeInfo = this.getScanCodeInfo();
        ScanCodeInfo other$scanCodeInfo = other.getScanCodeInfo();
        if (this$scanCodeInfo == null ? other$scanCodeInfo != null : !((Object)this$scanCodeInfo).equals(other$scanCodeInfo)) {
            return false;
        }
        SendPicsInfo this$sendPicsInfo = this.getSendPicsInfo();
        SendPicsInfo other$sendPicsInfo = other.getSendPicsInfo();
        if (this$sendPicsInfo == null ? other$sendPicsInfo != null : !((Object)this$sendPicsInfo).equals(other$sendPicsInfo)) {
            return false;
        }
        SendLocationInfo this$sendLocationInfo = this.getSendLocationInfo();
        SendLocationInfo other$sendLocationInfo = other.getSendLocationInfo();
        return !(this$sendLocationInfo == null ? other$sendLocationInfo != null : !((Object)this$sendLocationInfo).equals(other$sendLocationInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxCpXmlMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : ((Object)$agentId).hashCode());
        String $toUserName = this.getToUserName();
        result = result * 59 + ($toUserName == null ? 43 : $toUserName.hashCode());
        String $fromUserName = this.getFromUserName();
        result = result * 59 + ($fromUserName == null ? 43 : $fromUserName.hashCode());
        Long $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Long $msgId = this.getMsgId();
        result = result * 59 + ($msgId == null ? 43 : ((Object)$msgId).hashCode());
        String $picUrl = this.getPicUrl();
        result = result * 59 + ($picUrl == null ? 43 : $picUrl.hashCode());
        String $mediaId = this.getMediaId();
        result = result * 59 + ($mediaId == null ? 43 : $mediaId.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $thumbMediaId = this.getThumbMediaId();
        result = result * 59 + ($thumbMediaId == null ? 43 : $thumbMediaId.hashCode());
        Double $locationX = this.getLocationX();
        result = result * 59 + ($locationX == null ? 43 : ((Object)$locationX).hashCode());
        Double $locationY = this.getLocationY();
        result = result * 59 + ($locationY == null ? 43 : ((Object)$locationY).hashCode());
        Double $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        String $eventKey = this.getEventKey();
        result = result * 59 + ($eventKey == null ? 43 : $eventKey.hashCode());
        String $ticket = this.getTicket();
        result = result * 59 + ($ticket == null ? 43 : $ticket.hashCode());
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Double $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
        String $recognition = this.getRecognition();
        result = result * 59 + ($recognition == null ? 43 : $recognition.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Integer $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        Integer $filterCount = this.getFilterCount();
        result = result * 59 + ($filterCount == null ? 43 : ((Object)$filterCount).hashCode());
        Integer $sentCount = this.getSentCount();
        result = result * 59 + ($sentCount == null ? 43 : ((Object)$sentCount).hashCode());
        Integer $errorCount = this.getErrorCount();
        result = result * 59 + ($errorCount == null ? 43 : ((Object)$errorCount).hashCode());
        ScanCodeInfo $scanCodeInfo = this.getScanCodeInfo();
        result = result * 59 + ($scanCodeInfo == null ? 43 : ((Object)$scanCodeInfo).hashCode());
        SendPicsInfo $sendPicsInfo = this.getSendPicsInfo();
        result = result * 59 + ($sendPicsInfo == null ? 43 : ((Object)$sendPicsInfo).hashCode());
        SendLocationInfo $sendLocationInfo = this.getSendLocationInfo();
        result = result * 59 + ($sendLocationInfo == null ? 43 : ((Object)$sendLocationInfo).hashCode());
        return result;
    }

    @XStreamAlias(value="SendLocationInfo")
    public static class SendLocationInfo {
        @XStreamAlias(value="Location_X")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String locationX;
        @XStreamAlias(value="Location_Y")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String locationY;
        @XStreamAlias(value="Scale")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String scale;
        @XStreamAlias(value="Label")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String label;
        @XStreamAlias(value="Poiname")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String poiName;

        public String getLocationX() {
            return this.locationX;
        }

        public String getLocationY() {
            return this.locationY;
        }

        public String getScale() {
            return this.scale;
        }

        public String getLabel() {
            return this.label;
        }

        public String getPoiName() {
            return this.poiName;
        }

        public void setLocationX(String locationX) {
            this.locationX = locationX;
        }

        public void setLocationY(String locationY) {
            this.locationY = locationY;
        }

        public void setScale(String scale) {
            this.scale = scale;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setPoiName(String poiName) {
            this.poiName = poiName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SendLocationInfo)) {
                return false;
            }
            SendLocationInfo other = (SendLocationInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$locationX = this.getLocationX();
            String other$locationX = other.getLocationX();
            if (this$locationX == null ? other$locationX != null : !this$locationX.equals(other$locationX)) {
                return false;
            }
            String this$locationY = this.getLocationY();
            String other$locationY = other.getLocationY();
            if (this$locationY == null ? other$locationY != null : !this$locationY.equals(other$locationY)) {
                return false;
            }
            String this$scale = this.getScale();
            String other$scale = other.getScale();
            if (this$scale == null ? other$scale != null : !this$scale.equals(other$scale)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            String this$poiName = this.getPoiName();
            String other$poiName = other.getPoiName();
            return !(this$poiName == null ? other$poiName != null : !this$poiName.equals(other$poiName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SendLocationInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $locationX = this.getLocationX();
            result = result * 59 + ($locationX == null ? 43 : $locationX.hashCode());
            String $locationY = this.getLocationY();
            result = result * 59 + ($locationY == null ? 43 : $locationY.hashCode());
            String $scale = this.getScale();
            result = result * 59 + ($scale == null ? 43 : $scale.hashCode());
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            String $poiName = this.getPoiName();
            result = result * 59 + ($poiName == null ? 43 : $poiName.hashCode());
            return result;
        }

        public String toString() {
            return "WxCpXmlMessage.SendLocationInfo(locationX=" + this.getLocationX() + ", locationY=" + this.getLocationY() + ", scale=" + this.getScale() + ", label=" + this.getLabel() + ", poiName=" + this.getPoiName() + ")";
        }
    }

    @XStreamAlias(value="SendPicsInfo")
    public static class SendPicsInfo {
        @XStreamAlias(value="PicList")
        protected final List<Item> picList = new ArrayList<Item>();
        @XStreamAlias(value="Count")
        private Long count;

        public List<Item> getPicList() {
            return this.picList;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SendPicsInfo)) {
                return false;
            }
            SendPicsInfo other = (SendPicsInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Item> this$picList = this.getPicList();
            List<Item> other$picList = other.getPicList();
            if (this$picList == null ? other$picList != null : !((Object)this$picList).equals(other$picList)) {
                return false;
            }
            Long this$count = this.getCount();
            Long other$count = other.getCount();
            return !(this$count == null ? other$count != null : !((Object)this$count).equals(other$count));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SendPicsInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Item> $picList = this.getPicList();
            result = result * 59 + ($picList == null ? 43 : ((Object)$picList).hashCode());
            Long $count = this.getCount();
            result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
            return result;
        }

        public String toString() {
            return "WxCpXmlMessage.SendPicsInfo(picList=" + this.getPicList() + ", count=" + this.getCount() + ")";
        }

        @XStreamAlias(value="item")
        public static class Item {
            @XStreamAlias(value="PicMd5Sum")
            @XStreamConverter(value=XStreamCDataConverter.class)
            private String picMd5Sum;

            public String getPicMd5Sum() {
                return this.picMd5Sum;
            }

            public void setPicMd5Sum(String picMd5Sum) {
                this.picMd5Sum = picMd5Sum;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Item)) {
                    return false;
                }
                Item other = (Item)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$picMd5Sum = this.getPicMd5Sum();
                String other$picMd5Sum = other.getPicMd5Sum();
                return !(this$picMd5Sum == null ? other$picMd5Sum != null : !this$picMd5Sum.equals(other$picMd5Sum));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Item;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $picMd5Sum = this.getPicMd5Sum();
                result = result * 59 + ($picMd5Sum == null ? 43 : $picMd5Sum.hashCode());
                return result;
            }

            public String toString() {
                return "WxCpXmlMessage.SendPicsInfo.Item(picMd5Sum=" + this.getPicMd5Sum() + ")";
            }
        }
    }

    @XStreamAlias(value="ScanCodeInfo")
    public static class ScanCodeInfo {
        @XStreamAlias(value="ScanType")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String scanType;
        @XStreamAlias(value="ScanResult")
        @XStreamConverter(value=XStreamCDataConverter.class)
        private String scanResult;

        public String getScanType() {
            return this.scanType;
        }

        public String getScanResult() {
            return this.scanResult;
        }

        public void setScanType(String scanType) {
            this.scanType = scanType;
        }

        public void setScanResult(String scanResult) {
            this.scanResult = scanResult;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScanCodeInfo)) {
                return false;
            }
            ScanCodeInfo other = (ScanCodeInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$scanType = this.getScanType();
            String other$scanType = other.getScanType();
            if (this$scanType == null ? other$scanType != null : !this$scanType.equals(other$scanType)) {
                return false;
            }
            String this$scanResult = this.getScanResult();
            String other$scanResult = other.getScanResult();
            return !(this$scanResult == null ? other$scanResult != null : !this$scanResult.equals(other$scanResult));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScanCodeInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $scanType = this.getScanType();
            result = result * 59 + ($scanType == null ? 43 : $scanType.hashCode());
            String $scanResult = this.getScanResult();
            result = result * 59 + ($scanResult == null ? 43 : $scanResult.hashCode());
            return result;
        }

        public String toString() {
            return "WxCpXmlMessage.ScanCodeInfo(scanType=" + this.getScanType() + ", scanResult=" + this.getScanResult() + ")";
        }
    }
}

