/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import me.chanjar.weixin.common.bean.WxJsapiSignature;
import me.chanjar.weixin.common.bean.menu.WxMenu;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.session.StandardSessionManager;
import me.chanjar.weixin.common.session.WxSession;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.RandomUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.cp.api.WxCpDepartmentService;
import me.chanjar.weixin.cp.api.WxCpMediaService;
import me.chanjar.weixin.cp.api.WxCpMenuService;
import me.chanjar.weixin.cp.api.WxCpOAuth2Service;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.api.WxCpTagService;
import me.chanjar.weixin.cp.api.WxCpUserService;
import me.chanjar.weixin.cp.api.impl.WxCpDepartmentServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpMediaServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpMenuServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpOAuth2ServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpTagServiceImpl;
import me.chanjar.weixin.cp.api.impl.WxCpUserServiceImpl;
import me.chanjar.weixin.cp.bean.WxCpDepart;
import me.chanjar.weixin.cp.bean.WxCpMessage;
import me.chanjar.weixin.cp.bean.WxCpMessageSendResult;
import me.chanjar.weixin.cp.bean.WxCpTag;
import me.chanjar.weixin.cp.bean.WxCpUser;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WxCpServiceAbstractImpl<H, P>
implements WxCpService,
RequestHttp<H, P> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private WxCpUserService userService = new WxCpUserServiceImpl(this);
    private WxCpDepartmentService departmentService = new WxCpDepartmentServiceImpl(this);
    private WxCpMediaService mediaService = new WxCpMediaServiceImpl(this);
    private WxCpMenuService menuService = new WxCpMenuServiceImpl(this);
    private WxCpOAuth2Service oauth2Service = new WxCpOAuth2ServiceImpl(this);
    private WxCpTagService tagService = new WxCpTagServiceImpl(this);
    protected final Object globalAccessTokenRefreshLock = new Object();
    protected final Object globalJsapiTicketRefreshLock = new Object();
    protected WxCpConfigStorage configStorage;
    protected WxSessionManager sessionManager = new StandardSessionManager();
    protected File tmpDirFile;
    private int retrySleepMillis = 1000;
    private int maxRetryTimes = 5;

    @Override
    public boolean checkSignature(String msgSignature, String timestamp, String nonce, String data) {
        try {
            return SHA1.gen((String[])new String[]{this.configStorage.getToken(), timestamp, nonce, data}).equals(msgSignature);
        }
        catch (Exception e) {
            this.log.error("Checking signature failed, and the reason is :" + e.getMessage());
            return false;
        }
    }

    @Override
    public String getAccessToken() throws WxErrorException {
        return this.getAccessToken(false);
    }

    @Override
    public String getJsapiTicket() throws WxErrorException {
        return this.getJsapiTicket(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJsapiTicket(boolean forceRefresh) throws WxErrorException {
        if (forceRefresh) {
            this.configStorage.expireJsapiTicket();
        }
        if (this.configStorage.isJsapiTicketExpired()) {
            Object object = this.globalJsapiTicketRefreshLock;
            synchronized (object) {
                if (this.configStorage.isJsapiTicketExpired()) {
                    String url = "https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket";
                    String responseContent = (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, null);
                    JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
                    JsonObject tmpJsonObject = tmpJsonElement.getAsJsonObject();
                    String jsapiTicket = tmpJsonObject.get("ticket").getAsString();
                    int expiresInSeconds = tmpJsonObject.get("expires_in").getAsInt();
                    this.configStorage.updateJsapiTicket(jsapiTicket, expiresInSeconds);
                }
            }
        }
        return this.configStorage.getJsapiTicket();
    }

    @Override
    public WxJsapiSignature createJsapiSignature(String url) throws WxErrorException {
        long timestamp = System.currentTimeMillis() / 1000L;
        String noncestr = RandomUtils.getRandomStr();
        String jsapiTicket = this.getJsapiTicket(false);
        String signature = SHA1.genWithAmple((String[])new String[]{"jsapi_ticket=" + jsapiTicket, "noncestr=" + noncestr, "timestamp=" + timestamp, "url=" + url});
        WxJsapiSignature jsapiSignature = new WxJsapiSignature();
        jsapiSignature.setTimestamp(timestamp);
        jsapiSignature.setNonceStr(noncestr);
        jsapiSignature.setUrl(url);
        jsapiSignature.setSignature(signature);
        jsapiSignature.setAppId(this.configStorage.getCorpId());
        return jsapiSignature;
    }

    @Override
    public WxCpMessageSendResult messageSend(WxCpMessage message) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/message/send";
        Integer agentId = message.getAgentId();
        if (null == agentId) {
            message.setAgentId(this.getWxCpConfigStorage().getAgentId());
        }
        return WxCpMessageSendResult.fromJson(this.post(url, message.toJson()));
    }

    @Override
    @Deprecated
    public void menuCreate(WxMenu menu) throws WxErrorException {
        this.getMenuService().create(menu);
    }

    @Override
    @Deprecated
    public void menuCreate(Integer agentId, WxMenu menu) throws WxErrorException {
        this.getMenuService().create(agentId, menu);
    }

    @Override
    @Deprecated
    public void menuDelete() throws WxErrorException {
        this.getMenuService().delete();
    }

    @Override
    @Deprecated
    public void menuDelete(Integer agentId) throws WxErrorException {
        this.getMenuService().delete(agentId);
    }

    @Override
    @Deprecated
    public WxMenu menuGet() throws WxErrorException {
        return this.getMenuService().get();
    }

    @Override
    @Deprecated
    public WxMenu menuGet(Integer agentId) throws WxErrorException {
        return this.getMenuService().get(agentId);
    }

    @Override
    @Deprecated
    public WxMediaUploadResult mediaUpload(String mediaType, String fileType, InputStream inputStream) throws WxErrorException, IOException {
        return this.getMediaService().upload(mediaType, fileType, inputStream);
    }

    @Override
    @Deprecated
    public WxMediaUploadResult mediaUpload(String mediaType, File file) throws WxErrorException {
        return this.getMediaService().upload(mediaType, file);
    }

    @Override
    @Deprecated
    public File mediaDownload(String mediaId) throws WxErrorException {
        return this.getMediaService().download(mediaId);
    }

    @Override
    @Deprecated
    public void userAuthenticated(String userId) throws WxErrorException {
        this.getUserService().authenticate(userId);
    }

    @Override
    @Deprecated
    public void userCreate(WxCpUser user) throws WxErrorException {
        this.getUserService().create(user);
    }

    @Override
    @Deprecated
    public void userUpdate(WxCpUser user) throws WxErrorException {
        this.getUserService().update(user);
    }

    @Override
    @Deprecated
    public void userDelete(String userid) throws WxErrorException {
        this.getUserService().delete(userid);
    }

    @Override
    @Deprecated
    public void userDelete(String[] userids) throws WxErrorException {
        this.getUserService().delete(userids);
    }

    @Override
    @Deprecated
    public WxCpUser userGet(String userid) throws WxErrorException {
        return this.getUserService().getById(userid);
    }

    @Override
    @Deprecated
    public List<WxCpUser> userList(Integer departId, Boolean fetchChild, Integer status) throws WxErrorException {
        return this.getUserService().listByDepartment(departId, fetchChild, status);
    }

    @Override
    @Deprecated
    public List<WxCpUser> departGetUsers(Integer departId, Boolean fetchChild, Integer status) throws WxErrorException {
        return this.getUserService().listSimpleByDepartment(departId, fetchChild, status);
    }

    @Override
    @Deprecated
    public String tagCreate(String tagName) throws WxErrorException {
        return this.getTagService().create(tagName);
    }

    @Override
    @Deprecated
    public void tagUpdate(String tagId, String tagName) throws WxErrorException {
        this.getTagService().update(tagId, tagName);
    }

    @Override
    @Deprecated
    public void tagDelete(String tagId) throws WxErrorException {
        this.getTagService().delete(tagId);
    }

    @Override
    @Deprecated
    public List<WxCpTag> tagGet() throws WxErrorException {
        return this.getTagService().listAll();
    }

    @Override
    @Deprecated
    public List<WxCpUser> tagGetUsers(String tagId) throws WxErrorException {
        return this.getTagService().listUsersByTagId(tagId);
    }

    @Override
    @Deprecated
    public void tagAddUsers(String tagId, List<String> userIds, List<String> partyIds) throws WxErrorException {
        this.getTagService().addUsers2Tag(tagId, userIds, partyIds);
    }

    @Override
    @Deprecated
    public void tagRemoveUsers(String tagId, List<String> userIds) throws WxErrorException {
        this.getTagService().removeUsersFromTag(tagId, userIds);
    }

    @Override
    @Deprecated
    public String oauth2buildAuthorizationUrl(String state) {
        return this.getOauth2Service().buildAuthorizationUrl(state);
    }

    @Override
    @Deprecated
    public String oauth2buildAuthorizationUrl(String redirectUri, String state) {
        return this.getOauth2Service().buildAuthorizationUrl(redirectUri, state);
    }

    @Override
    @Deprecated
    public String[] oauth2getUserInfo(String code) throws WxErrorException {
        return this.getOauth2Service().getUserInfo(code);
    }

    @Override
    @Deprecated
    public String[] oauth2getUserInfo(Integer agentId, String code) throws WxErrorException {
        return this.getOauth2Service().getUserInfo(agentId, code);
    }

    @Override
    public int invite(String userId, String inviteTips) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/invite/send";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("userid", userId);
        if (StringUtils.isNotEmpty((CharSequence)inviteTips)) {
            jsonObject.addProperty("invite_tips", inviteTips);
        }
        String responseContent = this.post(url, jsonObject.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return tmpJsonElement.getAsJsonObject().get("type").getAsInt();
    }

    @Override
    public String[] getCallbackIp() throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/getcallbackip";
        String responseContent = this.get(url, null);
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        JsonArray jsonArray = tmpJsonElement.getAsJsonObject().get("ip_list").getAsJsonArray();
        String[] ips = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            ips[i] = jsonArray.get(i).getAsString();
        }
        return ips;
    }

    @Override
    public String get(String url, String queryParam) throws WxErrorException {
        return (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, queryParam);
    }

    @Override
    public String post(String url, String postData) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, postData);
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        int retryTimes = 0;
        while (true) {
            try {
                return this.executeInternal(executor, uri, data);
            }
            catch (WxErrorException e) {
                if (retryTimes + 1 > this.maxRetryTimes) {
                    this.log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                    throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
                }
                WxError error = e.getError();
                if (error.getErrorCode() == -1) {
                    int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                    try {
                        this.log.debug("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c{} ms \u540e\u91cd\u8bd5(\u7b2c{}\u6b21)", (Object)sleepMillis, (Object)(retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        throw new RuntimeException(e1);
                    }
                } else {
                    throw e;
                }
                if (retryTimes++ < this.maxRetryTimes) continue;
                this.log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
            }
            break;
        }
    }

    protected <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        if (uri.contains("access_token=")) {
            throw new IllegalArgumentException("uri\u53c2\u6570\u4e2d\u4e0d\u5141\u8bb8\u6709access_token: " + uri);
        }
        String accessToken = this.getAccessToken(false);
        String uriWithAccessToken = uri + (uri.contains("?") ? "&" : "?") + "access_token=" + accessToken;
        try {
            Object result = executor.execute(uriWithAccessToken, data);
            this.log.debug("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{uriWithAccessToken, data, result});
            return (T)result;
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() == 42001 || error.getErrorCode() == 40001 || error.getErrorCode() == 40014) {
                this.configStorage.expireAccessToken();
                return this.execute(executor, uri, data);
            }
            if (error.getErrorCode() != 0) {
                this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u9519\u8bef\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, data, error});
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
        catch (IOException e) {
            this.log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, data, e.getMessage()});
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setWxCpConfigStorage(WxCpConfigStorage wxConfigProvider) {
        this.configStorage = wxConfigProvider;
        this.initHttp();
    }

    @Override
    public void setRetrySleepMillis(int retrySleepMillis) {
        this.retrySleepMillis = retrySleepMillis;
    }

    @Override
    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    @Override
    public WxSession getSession(String id) {
        if (this.sessionManager == null) {
            return null;
        }
        return this.sessionManager.getSession(id);
    }

    @Override
    public WxSession getSession(String id, boolean create) {
        if (this.sessionManager == null) {
            return null;
        }
        return this.sessionManager.getSession(id, create);
    }

    @Override
    public void setSessionManager(WxSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public String replaceParty(String mediaId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/batch/replaceparty";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("media_id", mediaId);
        return this.post(url, jsonObject.toString());
    }

    @Override
    public String replaceUser(String mediaId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/batch/replaceuser";
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("media_id", mediaId);
        return this.post(url, jsonObject.toString());
    }

    @Override
    public String getTaskResult(String joinId) throws WxErrorException {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/batch/getresult?jobid=" + joinId;
        return this.get(url, null);
    }

    public File getTmpDirFile() {
        return this.tmpDirFile;
    }

    public void setTmpDirFile(File tmpDirFile) {
        this.tmpDirFile = tmpDirFile;
    }

    @Override
    public WxCpDepartmentService getDepartmentService() {
        return this.departmentService;
    }

    @Override
    public WxCpMediaService getMediaService() {
        return this.mediaService;
    }

    @Override
    public WxCpMenuService getMenuService() {
        return this.menuService;
    }

    @Override
    public WxCpOAuth2Service getOauth2Service() {
        return this.oauth2Service;
    }

    @Override
    public WxCpTagService getTagService() {
        return this.tagService;
    }

    @Override
    public WxCpUserService getUserService() {
        return this.userService;
    }

    @Override
    @Deprecated
    public Integer departCreate(WxCpDepart depart) throws WxErrorException {
        return this.getDepartmentService().create(depart);
    }

    @Override
    @Deprecated
    public void departUpdate(WxCpDepart depart) throws WxErrorException {
        this.getDepartmentService().update(depart);
    }

    @Override
    @Deprecated
    public void departDelete(Integer departId) throws WxErrorException {
        this.getDepartmentService().delete(departId);
    }

    @Override
    @Deprecated
    public List<WxCpDepart> departGet() throws WxErrorException {
        return this.getDepartmentService().listAll();
    }

    @Override
    public RequestHttp getRequestHttp() {
        return this;
    }

    @Override
    public void setUserService(WxCpUserService userService) {
        this.userService = userService;
    }

    @Override
    public void setDepartmentService(WxCpDepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    @Override
    public void setMediaService(WxCpMediaService mediaService) {
        this.mediaService = mediaService;
    }

    @Override
    public void setMenuService(WxCpMenuService menuService) {
        this.menuService = menuService;
    }

    @Override
    public void setOauth2Service(WxCpOAuth2Service oauth2Service) {
        this.oauth2Service = oauth2Service;
    }

    @Override
    public void setTagService(WxCpTagService tagService) {
        this.tagService = tagService;
    }
}

