/*
 * Decompiled with CFR 0.152.
 */
package esign.utils;

import esign.utils.exception.af;
import esign.utils.exception.ai;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlUtil {
    private Protocol a;
    private StringBuilder b = new StringBuilder();
    private StringBuilder c = new StringBuilder();
    private Map<String, Object> d = new HashMap<String, Object>();
    private static final Logger e = LoggerFactory.getLogger(UrlUtil.class);

    public UrlUtil(String host, int port) {
        this.a = Protocol.maybe(port);
        this.b.append(this.a(this.a, host, port));
    }

    public UrlUtil(String address) throws ai {
        URL parser;
        try {
            parser = new URL(address);
        }
        catch (MalformedURLException e2) {
            e.error("parse url failed. url:{}", (Object)address);
            e.error("exception:", (Throwable)e2);
            throw af.aG.c();
        }
        String url = parser.getHost();
        int port = parser.getPort();
        this.a = Protocol.from(parser.getProtocol());
        this.b.append(this.a(this.a, url, port));
    }

    public UrlUtil(Protocol protocol, String host, int port) {
        this.a = protocol;
        this.b.append(this.a(this.a, host, port));
    }

    public UrlUtil(UrlUtil url) {
        this.a = url.a;
        this.b = new StringBuilder(url.b);
        this.c = new StringBuilder(url.c);
    }

    public UrlUtil a(String path) {
        this.c.setLength(0);
        if ('/' != path.charAt(0)) {
            this.c.append('/');
        }
        this.c.append(path);
        return this;
    }

    public void a(String key, Object value) {
        this.d.put(key, value);
    }

    public String a() {
        StringBuilder paramsStream = new StringBuilder();
        paramsStream.append((CharSequence)this.b).append((CharSequence)this.c);
        if (this.d.isEmpty()) {
            return paramsStream.toString();
        }
        paramsStream.append('?');
        Set<Map.Entry<String, Object>> entries = this.d.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            if (StringUtils.isEmpty((String)entry.getKey()) || null == entry.getValue()) continue;
            if (List.class.isAssignableFrom(entry.getValue().getClass())) {
                String param = this.a(entry.getKey(), (List)entry.getValue());
                paramsStream.append(param);
                continue;
            }
            paramsStream.append(entry.getKey()).append('=').append(entry.getValue()).append('&');
        }
        paramsStream.setLength(paramsStream.length() - 1);
        return paramsStream.toString();
    }

    private String a(String key, List<String> values) {
        StringBuilder sb = new StringBuilder();
        if (values == null || values.isEmpty()) {
            return sb.toString();
        }
        for (String value : values) {
            sb.append(key).append('=').append(value).append('&');
        }
        return sb.toString();
    }

    private String a(Protocol protocol, String host, int port) {
        StringBuilder sb = new StringBuilder();
        sb.append(protocol.disc).append("://").append(host);
        if (!protocol.isDefault(port)) {
            sb.append(':').append(port);
        }
        return sb.toString();
    }

    public static enum Protocol {
        HTTP("http", 80, new Integer[]{80, 8080}),
        HTTPS("https", 443, new Integer[]{443, 8443});

        private String disc;
        private int defaultPort;
        private List<Integer> ports;

        private Protocol(String disc, int defaultPort, Integer[] ports) {
            this.ports = Arrays.asList(ports);
            this.disc = disc;
            this.defaultPort = defaultPort;
        }

        public boolean isDefault(int port) {
            return port == this.defaultPort;
        }

        public static Protocol from(String protocol) {
            for (Protocol p2 : Protocol.values()) {
                if (!p2.disc.equalsIgnoreCase(protocol)) continue;
                return p2;
            }
            return HTTP;
        }

        public static Protocol maybe(int port) {
            for (Protocol p2 : Protocol.values()) {
                if (!p2.ports.contains(port)) continue;
                return p2;
            }
            return HTTP;
        }
    }
}

