/*
 * Decompiled with CFR 0.152.
 */
package esign.utils;

import esign.utils.asserts.b;
import esign.utils.exception.af;
import esign.utils.exception.ai;

public class NumericUtil {
    public static String a(long data, NumericType type) throws ai {
        return NumericUtil.a(data, type.convTable().length(), type.convTable());
    }

    public static String a(long data, int step, String convTable) throws ai {
        NumericUtil.a(convTable, step);
        StringBuilder sb = new StringBuilder();
        for (long tmp = data; 0L != tmp; tmp /= (long)step) {
            long r2 = tmp % (long)step;
            sb.append(convTable.charAt((int)r2));
        }
        return sb.reverse().toString();
    }

    public static long a(String data, NumericType dataType) throws ai {
        return NumericUtil.a(data, dataType.convTable().length(), dataType.convTable());
    }

    public static long a(String data, int step, String convTable) throws ai {
        NumericUtil.a(convTable, step);
        long result = 0L;
        for (int i2 = 0; i2 < data.length(); ++i2) {
            result = result * (long)step + (long)convTable.indexOf(data.charAt(i2));
        }
        return result;
    }

    private static void a(String convTable, int step) throws ai {
        b.a(convTable, af.at.c());
        b.a(step <= convTable.length(), af.ay.a(String.format("%d mast lte %d", step, convTable.length())));
    }

    public static enum NumericType {
        NUMERIC_2{

            @Override
            protected String convTable() {
                return "01";
            }
        }
        ,
        NUMERIC_8{

            @Override
            protected String convTable() {
                return "01234567";
            }
        }
        ,
        NUMERIC_16{

            @Override
            protected String convTable() {
                return "0123456789ABCDEF";
            }
        }
        ,
        NUMERIC_64{

            @Override
            protected String convTable() {
                return "01234567890abcdefghijklmnopqrszuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ+-";
            }
        };


        protected abstract String convTable();
    }
}

