/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.template.loader;

import com.timevale.seal.template.creater.OfficialSealTemplate;
import com.timevale.seal.template.creater.OfficialSealTemplatePolicyConfig;
import com.timevale.seal.template.creater.OfficialSealTemplatePolicyManager;
import esign.utils.JsonHelper;
import esign.utils.exception.af;
import esign.utils.exception.ai;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfficialSealTemplatePolicyLoader {
    private List<b> kvs = null;
    private Map<String, OfficialSealTemplate> store = null;
    private static final String PATH_DEFAULT_SEAL_POLICY = "seal/official-seal-policy.json";
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficialSealTemplatePolicyLoader.class);

    public void loadDefault() throws ai {
        this.load(this.getClass().getClassLoader().getResourceAsStream(PATH_DEFAULT_SEAL_POLICY));
    }

    public void load(String file) throws ai {
        try {
            this.load(new FileInputStream(file));
            return;
        }
        catch (FileNotFoundException var3) {
            LOGGER.error("read policy from file failed. file:{}", (Object)file);
            LOGGER.error("exception:", (Throwable)var3);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(InputStream in) throws ai {
        if (in == null) {
            esign.utils.asserts.b.a(false, "empty input stream", new Object[0]);
            return;
        }
        reader = new BufferedReader(new InputStreamReader(in));
        buff = new char[1024];
        sb = new StringBuilder();
        while (true) {
            mgr = reader.read(buff);
            ** if (mgr > 0) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                try {
                    reader.close();
                    in.close();
                }
                catch (IOException v0) {}
                try {
                    mgr1 = JsonHelper.a(sb.toString(), OfficialSealTemplatePolicyManager.class);
                    break;
                }
                catch (Exception var16) {
                    OfficialSealTemplatePolicyLoader.LOGGER.error("invalid json format. json:{}", (Object)sb.toString());
                    OfficialSealTemplatePolicyLoader.LOGGER.error("exception:", (Throwable)var16);
                    return;
                }
            }
lbl-1000:
            // 1 sources

            {
            }
            {
                catch (IOException var17) {
                    OfficialSealTemplatePolicyLoader.LOGGER.error("read policy from inputstream failed.", (Throwable)var17);
                    try {
                        reader.close();
                        in.close();
                        return;
                    }
                    catch (IOException v1) {
                        return;
                    }
                }
                catch (Throwable var7_8) {
                    try {
                        reader.close();
                        in.close();
                        throw var7_8;
                    }
                    catch (IOException v2) {}
                    throw var7_8;
                }
                {
                    sb.append(buff, 0, mgr);
                    continue;
                }
            }
            break;
        }
        this.load(mgr1);
    }

    public void load(OfficialSealTemplatePolicyManager mgr) throws ai {
        this.kvs = this.loadPolicy(mgr.getPolicies());
        this.store = this.loadStore(mgr.getStore());
    }

    public OfficialSealTemplate select(Integer ... wcounts) throws ai {
        String id = this.selectId(wcounts);
        if (id == null) {
            LOGGER.error("can not get the template. wcount:{}", (Object)this.wcountSerialize(wcounts));
            throw af.T.c();
        }
        OfficialSealTemplate template = this.store.get(id);
        esign.utils.asserts.b.a(template, af.ag.c());
        return template;
    }

    private List<b> loadPolicy(List<OfficialSealTemplatePolicyConfig> policies) throws ai {
        ArrayList<b> kvs = new ArrayList<b>();
        this.loadKey(kvs, null, policies);
        return kvs;
    }

    private Map<String, OfficialSealTemplate> loadStore(List<OfficialSealTemplate> templates) {
        HashMap<String, OfficialSealTemplate> store = new HashMap<String, OfficialSealTemplate>();
        for (OfficialSealTemplate template : templates) {
            store.put(template.getId(), template);
        }
        return store;
    }

    private String selectId(Integer ... wcounts) throws ai {
        esign.utils.asserts.b.a(Boolean.valueOf(wcounts != null && wcounts.length > 0), af.am.c());
        esign.utils.asserts.b.a(this.kvs, af.ax.c());
        int max = 0;
        b selected = null;
        for (b kv : this.kvs) {
            int tmp = kv.a.a(wcounts);
            if (tmp <= max) continue;
            max = tmp;
            selected = kv;
        }
        String printable1 = this.wcountSerialize(wcounts);
        if (selected == null) {
            LOGGER.error("unsupport word count in current policy. wcounts:{}", (Object)printable1);
            return null;
        }
        LOGGER.info("success to select a template in current policy. wcounts:{}, template:{}", (Object)printable1, (Object)selected.b);
        return selected.b;
    }

    private void loadKey(List<b> kvs, a prevCompx, List<OfficialSealTemplatePolicyConfig> policies) throws ai {
        if (policies != null) {
            Collections.sort(policies, new Comparator<OfficialSealTemplatePolicyConfig>(){

                public int a(OfficialSealTemplatePolicyConfig o1, OfficialSealTemplatePolicyConfig o2) {
                    if (null != o1.getLt() && null != o2.getLt()) {
                        return o1.getLt() - o2.getLt();
                    }
                    if (null != o1.getLt()) {
                        return -1;
                    }
                    o2.getLt();
                    return 1;
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((OfficialSealTemplatePolicyConfig)object, (OfficialSealTemplatePolicyConfig)object2);
                }
            });
            for (OfficialSealTemplatePolicyConfig policy : policies) {
                if (policy == null) continue;
                this.loadKey(kvs, prevCompx, policy);
            }
        }
    }

    private void loadKey(List<b> kvs, a prevCompx, OfficialSealTemplatePolicyConfig conf) throws ai {
        if (null != conf.getSpecs() && !conf.getSpecs().isEmpty()) {
            this.loadKey(kvs, prevCompx, conf.getSpecs(), conf);
            return;
        }
        if (null != conf.getLt()) {
            this.loadKey(kvs, prevCompx, conf.getLt(), conf);
        }
    }

    private void loadKey(List<b> kvs, a prevCompx, List<Integer> specs, OfficialSealTemplatePolicyConfig conf) throws ai {
        for (Integer spec : specs) {
            b compx = new b(prevCompx);
            compx.a.a.add(c.b(spec));
            this.loadKey(kvs, compx.a, conf.getPolicies());
            compx.b = conf.getTemplateId();
            if (null == compx.b) continue;
            kvs.add(compx);
        }
    }

    private void loadKey(List<b> kvs, a prevCompx, Integer lt, OfficialSealTemplatePolicyConfig conf) throws ai {
        b compx = new b(prevCompx);
        compx.a.a.add(c.a(lt));
        this.loadKey(kvs, compx.a, conf.getPolicies());
        compx.b = conf.getTemplateId();
        if (null != compx.b) {
            kvs.add(compx);
        }
    }

    private String wcountSerialize(Integer ... wcounts) {
        StringBuilder sb = new StringBuilder();
        Integer[] arr$ = wcounts;
        int len$ = wcounts.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer wcount = arr$[i$];
            sb.append(wcount).append('-');
        }
        return sb.toString();
    }

    private static class c {
        private Integer a;
        private Integer b;

        private c() {
        }

        private int a(int wcount, int wcountCount, int wcountIndex) {
            int shift = 2 * (wcountCount - wcountIndex);
            if (this.b != null && this.b == wcount) {
                return 1 << shift;
            }
            if (this.a != null && wcount < this.a) {
                return 1 << shift - 1;
            }
            return 0;
        }

        public static c a(Integer lt) throws ai {
            esign.utils.asserts.b.a(lt, af.am.c());
            c k2 = new c();
            new c().a = lt;
            return k2;
        }

        public static c b(Integer spec) throws ai {
            esign.utils.asserts.b.a(spec, af.am.c());
            c k2 = new c();
            new c().b = spec;
            return k2;
        }
    }

    private static class a {
        private List<c> a = new ArrayList<c>();

        private a() {
        }

        private int a(Integer[] wcounts) {
            int weight = 0;
            for (int i2 = 0; i2 < this.a.size() && i2 < wcounts.length; ++i2) {
                int tmp = this.a.get(i2).a(wcounts[i2], wcounts.length, i2);
                if (tmp == 0) {
                    return 0;
                }
                weight += tmp;
            }
            return weight;
        }
    }

    private static class b {
        private a a = new a();
        private String b;

        public b(a prevCompx) {
            if (prevCompx != null) {
                this.a.a.addAll(prevCompx.a);
            }
        }
    }
}

