/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.template.creater;

import com.timevale.seal.graphics.impl.i;
import com.timevale.seal.graphics.suites.impl.b;
import com.timevale.seal.util.GraphicsTextFont;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class SuiteCircleSurroundText
extends GraphicsTextFont
implements i {
    private String text;
    private int circleStart;
    private int circleEnd;
    private int textWidth;
    private int rotateStart;
    private int rotateEnd;

    @Override
    public void draw(Graphics2D g2, Integer canvasWidth, Integer canvasHeight) {
        g2.translate(canvasWidth / 2, canvasHeight / 2);
        int charFrameHeight = this.circleEnd - this.circleStart;
        Font testFont = this.getFont().getAwtFont(this.getFontSize());
        g2.setFont(testFont);
        g2.setColor(this.getColor().getAwtColor());
        int count = this.text.length();
        double correctText = Math.toRadians(90.0);
        float angle = (float)(this.rotateEnd - this.rotateStart) / (float)(count - 1);
        char[] chars = this.text.toCharArray();
        for (int i2 = 0; i2 < count; ++i2) {
            char character = chars[i2];
            float rotateCurrent = (float)this.rotateStart + angle * (float)i2;
            double radians = Math.toRadians(rotateCurrent);
            g2.rotate(radians);
            g2.translate(this.circleStart, 0);
            g2.rotate(correctText);
            g2.translate(-this.textWidth / 2, 0);
            b scale = this.scaleCharacter(g2, character, this.textWidth, charFrameHeight);
            g2.scale(scale.a(), scale.b());
            g2.drawString(String.valueOf(character), 0, 0);
            g2.scale(1.0f / scale.a(), 1.0f / scale.b());
            g2.translate(this.textWidth / 2, 0);
            g2.rotate(-correctText);
            g2.translate(-this.circleStart, 0);
            g2.rotate(-radians);
        }
        g2.translate(-canvasWidth.intValue() / 2, -canvasHeight.intValue() / 2);
    }

    private b scaleCharacter(Graphics2D g2, char character, int width, int height) {
        FontMetrics fm = g2.getFontMetrics();
        int ch = fm.getAscent();
        int cw = fm.charWidth(character);
        return new b((float)width / (float)cw, (float)height / (float)ch);
    }

    public int getCircleStart() {
        return this.circleStart;
    }

    public void setCircleStart(int circleStart) {
        this.circleStart = circleStart;
    }

    public int getCircleEnd() {
        return this.circleEnd;
    }

    public void setCircleEnd(int circleEnd) {
        this.circleEnd = circleEnd;
    }

    public int getRotateStart() {
        return this.rotateStart;
    }

    public void setRotateStart(int rotateStart) {
        this.rotateStart = rotateStart;
    }

    public int getRotateEnd() {
        return this.rotateEnd;
    }

    public void setRotateEnd(int rotateEnd) {
        this.rotateEnd = rotateEnd;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getTextWidth() {
        return this.textWidth;
    }

    public void setTextWidth(int textWidth) {
        this.textWidth = textWidth;
    }
}

