/*
 * Decompiled with CFR 0.152.
 */
package com.rfp.ws.utils;

import com.rfp.ws.utils.Base64Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

class RSAUtils {
    private static final String ENCODE = "UTF-8";
    private static final int FILE_MAX_SIZE = 0x2800000;
    private static final char[] bcdLookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    RSAUtils() {
    }

    private static PublicKey loadPublicKey(String filePath) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        BufferedReader br = null;
        StringBuffer sb = new StringBuffer();
        try {
            br = new BufferedReader(new FileReader(filePath));
            String readLine = null;
            while ((readLine = br.readLine()) != null) {
                if (readLine.charAt(0) == '-') continue;
                sb.append(readLine);
                sb.append('\r');
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return RSAUtils.getPublicKey(sb.toString());
    }

    private static PrivateKey loadPrivateKey(String filePath) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        BufferedReader br = null;
        StringBuffer sb = new StringBuffer();
        try {
            br = new BufferedReader(new FileReader(filePath));
            String readLine = null;
            while ((readLine = br.readLine()) != null) {
                if (readLine.charAt(0) == '-') continue;
                sb.append(readLine);
                sb.append('\r');
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return RSAUtils.getPrivateKey(sb.toString());
    }

    private static PublicKey getPublicKey(String publicKeyStr) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] buffer = Base64Utils.decode(publicKeyStr).getBytes();
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
        return keyFactory.generatePublic(keySpec);
    }

    private static PrivateKey getPrivateKey(String privateKeyStr) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] buffer = Base64Utils.decode(privateKeyStr).getBytes();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    private static byte[] encryptFile(String filePath, PublicKey publicKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IOException {
        byte[] buff = new byte[1024];
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        FileInputStream fis = null;
        CipherInputStream cis = null;
        FileOutputStream fos = null;
        CipherOutputStream cos = null;
        try {
            int r;
            fis = new FileInputStream(filePath);
            cis = new CipherInputStream(fis, cipher);
            fos = new FileOutputStream("");
            cos = new CipherOutputStream(fos, cipher);
            cis.available();
            while ((r = cis.read(buff)) != -1) {
                cos.write(buff, 0, r);
            }
        }
        finally {
            if (cos != null) {
                cos.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (cis != null) {
                cis.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return buff;
    }

    private static String encrypt(String data, PublicKey publicKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        String mi = "";
        RSAPublicKey rsa = (RSAPublicKey)publicKey;
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        int key_len = rsa.getModulus().bitLength() / 8;
        String[] datas = RSAUtils.splitString(data, key_len / 3);
        int i = 0;
        while (i < datas.length) {
            String s = datas[i];
            mi = String.valueOf(mi) + RSAUtils.bcd2Str(cipher.doFinal(s.getBytes(ENCODE)));
            ++i;
        }
        return mi;
    }

    public static String encrypt(String data, String publicPath) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException, IOException {
        PublicKey publicKey = null;
        publicKey = RSAUtils.loadPublicKey(publicPath);
        return RSAUtils.encrypt(data, publicKey);
    }

    private static byte[] stringToBytes(String data) throws UnsupportedEncodingException {
        return data.getBytes(ENCODE);
    }

    private static String bytesToString(byte[] data) throws UnsupportedEncodingException {
        return new String(data, ENCODE);
    }

    private static String decrypt(String data, PrivateKey privateKey) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException {
        String ming = "";
        RSAPrivateKey rsa = (RSAPrivateKey)privateKey;
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        int key_len = rsa.getModulus().bitLength() / 8;
        byte[] bytes = data.getBytes();
        byte[] bcd = RSAUtils.ASCII_To_BCD(bytes, bytes.length);
        byte[][] arrays = RSAUtils.splitArray(bcd, key_len);
        int i = 0;
        while (i < arrays.length) {
            byte[] arr = arrays[i];
            ming = String.valueOf(ming) + new String(cipher.doFinal(arr), ENCODE);
            ++i;
        }
        return ming;
    }

    public static String decrypt(String data, String privatePath) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        PrivateKey privateKey = RSAUtils.loadPrivateKey(privatePath);
        return RSAUtils.decrypt(data, privateKey);
    }

    private static byte[] ASCII_To_BCD(byte[] ascii, int asc_len) {
        byte[] bcd = new byte[asc_len / 2];
        int j = 0;
        int i = 0;
        while (i < (asc_len + 1) / 2) {
            bcd[i] = RSAUtils.asc_to_bcd(ascii[j++]);
            bcd[i] = (byte)((j >= asc_len ? (byte)0 : RSAUtils.asc_to_bcd(ascii[j++])) + (bcd[i] << 4));
            ++i;
        }
        return bcd;
    }

    private static byte asc_to_bcd(byte asc) {
        byte bcd = asc >= 48 && asc <= 57 ? (byte)(asc - 48) : (asc >= 65 && asc <= 70 ? (byte)(asc - 65 + 10) : (asc >= 97 && asc <= 102 ? (byte)(asc - 97 + 10) : (byte)(asc - 48)));
        return bcd;
    }

    private static String bcd2Str(byte[] bytes) {
        char[] temp = new char[bytes.length * 2];
        int i = 0;
        while (i < bytes.length) {
            char val = (char)((bytes[i] & 0xF0) >> 4 & 0xF);
            temp[i * 2] = (char)(val > '\t' ? val + 65 - 10 : val + 48);
            val = (char)(bytes[i] & 0xF);
            temp[i * 2 + 1] = (char)(val > '\t' ? val + 65 - 10 : val + 48);
            ++i;
        }
        return new String(temp);
    }

    private static String[] splitString(String string, int len) {
        int x = string.length() / len;
        int y = string.length() % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        String[] strings = new String[x + z];
        String str = "";
        int i = 0;
        while (i < x + z) {
            str = i == x + z - 1 && y != 0 ? string.substring(i * len, i * len + y) : string.substring(i * len, i * len + len);
            strings[i] = str;
            ++i;
        }
        return strings;
    }

    private static byte[][] splitArray(byte[] data, int len) {
        int x = data.length / len;
        int y = data.length % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        byte[][] arrays = new byte[x + z][];
        int i = 0;
        while (i < x + z) {
            byte[] arr = new byte[len];
            if (i == x + z - 1 && y != 0) {
                System.arraycopy(data, i * len, arr, 0, y);
            } else {
                System.arraycopy(data, i * len, arr, 0, len);
            }
            arrays[i] = arr;
            ++i;
        }
        return arrays;
    }

    private static String ensign(PrivateKey myprikey, String myinfo) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        String signRet = "";
        Signature signet = Signature.getInstance("MD5withRSA");
        signet.initSign(myprikey);
        signet.update(myinfo.getBytes("ISO-8859-1"));
        byte[] signed = signet.sign();
        signRet = RSAUtils.bytesToHexStr(signed);
        return signRet;
    }

    private static boolean design(PublicKey pubKey, String info, String signRet) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        boolean flag = false;
        byte[] signed = RSAUtils.hexStrToBytes(signRet);
        Signature signetcheck = Signature.getInstance("MD5withRSA");
        signetcheck.initVerify(pubKey);
        signetcheck.update(info.getBytes());
        flag = signetcheck.verify(signed);
        return flag;
    }

    public static String ensign(String prikeyPath, String myinfo) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException, UnsupportedEncodingException, InvalidKeySpecException, IOException {
        return RSAUtils.ensign(RSAUtils.loadPrivateKey(prikeyPath), myinfo);
    }

    public static boolean design(String pubKeyPath, String info, String signRet) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException, InvalidKeySpecException, IOException {
        return RSAUtils.design(RSAUtils.loadPublicKey(pubKeyPath), info, signRet);
    }

    private static final String bytesToHexStr(byte[] bcd) {
        StringBuffer s = new StringBuffer(bcd.length * 2);
        int i = 0;
        while (i < bcd.length) {
            s.append(bcdLookup[bcd[i] >>> 4 & 0xF]);
            s.append(bcdLookup[bcd[i] & 0xF]);
            ++i;
        }
        return s.toString();
    }

    private static final byte[] hexStrToBytes(String s) {
        byte[] bytes = new byte[s.length() / 2];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16);
            ++i;
        }
        return bytes;
    }

    private static byte[] FileToBytes(String filePath) throws IOException {
        FileInputStream fis = null;
        byte[] buffer = null;
        File file = new File(filePath);
        int length = (int)file.length();
        if (file.length() > 0x2800000L) {
            length = 0;
            throw new IOException("file is too long, file size max 41943040 byte");
        }
        fis = new FileInputStream(file);
        buffer = new byte[length];
        fis.read(buffer);
        return buffer;
    }

    private static HashMap getKeys() throws NoSuchAlgorithmException {
        HashMap<String, Key> map = new HashMap<String, Key>();
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        map.put("public", publicKey);
        map.put("private", privateKey);
        return map;
    }

    public static void main(String[] args) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException, IOException {
        String encryptStr = "\u6d4b\u8bd5\u5b57\u7b26\u4e32: Test String chaijunkun";
        System.out.println("\u660e\u6587:" + encryptStr);
        String cipher = RSAUtils.encrypt(encryptStr, "D:/rfpfile/key/rsa_000001.pub");
        System.out.println("\u5bc6\u6587:" + cipher);
        System.out.println("\u5bc6\u6587:" + cipher);
        String plainText = RSAUtils.decrypt(cipher, "D:/rfpfile/key/rsa_000001.pri");
        System.out.println("\u660e\u6587:" + plainText);
        System.out.println(new String(plainText));
    }
}

