/*
 * Decompiled with CFR 0.152.
 */
package com.rfp.ws.utils;

import com.rfp.base.BaseCipher;
import com.rfp.ws.utils.ECCUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class ECCFileUtils
extends BaseCipher {
    public static String encryptFile(String filePath, String keyPath) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeySpecException, IOException {
        return ECCFileUtils.getEncryptStrFromFile(filePath, keyPath);
    }

    public static String encryptFileByUTF8(String filePath, String keyPath) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeySpecException, IOException {
        return ECCFileUtils.getEncryptStrFromFileByUTF8(filePath, keyPath);
    }

    public static String encryptFileByKeyUTF8(String filePath, String key) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeySpecException, IOException {
        return ECCFileUtils.getEncryptStrFromKeyByUTF8(filePath, key);
    }

    public static File decryptFile(String destFilePath, String encryptStr, String keyPath) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException, IOException {
        return ECCFileUtils.getFileFromEncryptStr(destFilePath, encryptStr, keyPath);
    }

    public static File decryptFileByUTF8(String destFilePath, String encryptStr, String keyPath) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException, IOException {
        return ECCFileUtils.getFileFromEncryptStrByUTF8(destFilePath, encryptStr, keyPath);
    }

    public static File decryptFileByKeyUTF8(String destFilePath, String encryptStr, String key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException, IOException {
        return ECCFileUtils.getFileFromEncryptStrByKeyUTF8(destFilePath, encryptStr, key);
    }

    public static String getEncryptStrFromFile(String filePath, String keyPath) throws IOException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeySpecException {
        int n;
        byte[] fileBytes = null;
        FileInputStream fis = new FileInputStream(filePath);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((n = fis.read(b)) != -1) {
            bos.write(b, 0, n);
        }
        fileBytes = bos.toByteArray();
        fis.close();
        bos.close();
        byte[] zipFileBytes = ECCFileUtils.zip(fileBytes);
        String character = "ISO-8859-1";
        String encryptStr = ECCUtils.encrypt(new String(zipFileBytes, character), keyPath);
        return encryptStr;
    }

    public static String getEncryptStrFromFile(String filePath, String keyPath, String zipName) throws IOException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeySpecException {
        int n;
        byte[] fileBytes = null;
        FileInputStream fis = new FileInputStream(filePath);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((n = fis.read(b)) != -1) {
            bos.write(b, 0, n);
        }
        fileBytes = bos.toByteArray();
        fis.close();
        bos.close();
        byte[] zipFileBytes = ECCFileUtils.zip(fileBytes, zipName);
        String character = "ISO-8859-1";
        String encryptStr = ECCUtils.encrypt(new String(zipFileBytes, character), keyPath);
        return encryptStr;
    }

    private static String getEncryptStrFromKeyByUTF8(String filePath, String key) throws IOException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeySpecException {
        int n;
        byte[] fileBytes = null;
        FileInputStream fis = new FileInputStream(filePath);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((n = fis.read(b)) != -1) {
            bos.write(b, 0, n);
        }
        fileBytes = bos.toByteArray();
        fis.close();
        bos.close();
        byte[] zipFileBytes = ECCFileUtils.zip(fileBytes);
        String character = "ISO-8859-1";
        String encryptStr = ECCUtils.encryptByKeyUTF8(new String(zipFileBytes, character), key);
        return encryptStr;
    }

    private static String getEncryptStrFromFileByUTF8(String filePath, String keyPath) throws IOException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeySpecException {
        int n;
        byte[] fileBytes = null;
        FileInputStream fis = new FileInputStream(filePath);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((n = fis.read(b)) != -1) {
            bos.write(b, 0, n);
        }
        fileBytes = bos.toByteArray();
        fis.close();
        bos.close();
        byte[] zipFileBytes = ECCFileUtils.zip(fileBytes);
        String character = "ISO-8859-1";
        String encryptStr = ECCUtils.encryptByUTF8(new String(zipFileBytes, character), keyPath);
        return encryptStr;
    }

    private static File getFileFromEncryptStr(String destFilePath, String encryptStr, String keyPath) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, IOException, InvalidKeySpecException {
        String decryptStr = ECCUtils.decrypt(encryptStr, keyPath);
        byte[] decryptFileBytes = decryptStr.getBytes("ISO-8859-1");
        byte[] unZip = ECCFileUtils.unZip(decryptFileBytes);
        return ECCFileUtils.writeFile(destFilePath, unZip);
    }

    private static File getFileFromEncryptStrByUTF8(String destFilePath, String encryptStr, String keyPath) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, IOException, InvalidKeySpecException {
        String decryptStr = ECCUtils.decryptByUTF8(encryptStr, keyPath);
        byte[] decryptFileBytes = decryptStr.getBytes("ISO-8859-1");
        byte[] unZip = ECCFileUtils.unZip(decryptFileBytes);
        return ECCFileUtils.writeFile(destFilePath, unZip);
    }

    private static File getFileFromEncryptStrByKeyUTF8(String destFilePath, String encryptStr, String key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, IOException, InvalidKeySpecException {
        String decryptStr = ECCUtils.decryptByKeyUTF8(encryptStr, key);
        byte[] decryptFileBytes = decryptStr.getBytes("ISO-8859-1");
        byte[] unZip = ECCFileUtils.unZip(decryptFileBytes);
        return ECCFileUtils.writeFile(destFilePath, unZip);
    }

    private static byte[] zip(byte[] data) throws IOException {
        byte[] b = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(bos);
        ZipEntry entry = new ZipEntry("ORDER_FILE.txt");
        entry.setSize(data.length);
        zip.putNextEntry(entry);
        zip.write(data);
        zip.closeEntry();
        zip.close();
        b = bos.toByteArray();
        bos.close();
        return b;
    }

    private static byte[] zip(byte[] data, String zipName) throws IOException {
        byte[] b = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(bos);
        ZipEntry entry = new ZipEntry(String.valueOf(zipName) + ".zip");
        entry.setSize(data.length);
        zip.putNextEntry(entry);
        zip.write(data);
        zip.closeEntry();
        zip.close();
        b = bos.toByteArray();
        bos.close();
        return b;
    }

    private static byte[] unZip(byte[] data) throws IOException {
        byte[] b = null;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ZipInputStream zip = new ZipInputStream(bis);
        while (zip.getNextEntry() != null) {
            byte[] buf = new byte[1024];
            int num = -1;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((num = zip.read(buf, 0, buf.length)) != -1) {
                baos.write(buf, 0, num);
            }
            b = baos.toByteArray();
            baos.flush();
            baos.close();
        }
        zip.close();
        bis.close();
        return b;
    }

    private static File writeFile(String destFilePath, byte[] fileByte) throws IOException {
        FileOutputStream fos = null;
        File file = new File(destFilePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        fos = new FileOutputStream(file.getPath());
        fos.write(fileByte);
        fos.flush();
        if (fos != null) {
            fos.close();
        }
        return file;
    }
}

