/*
 * Decompiled with CFR 0.152.
 */
package com.rfp.sm.utils;

import com.rfp.base.BaseCipher;
import com.rfp.sm.utils.SM2Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class SM2FileUtils
extends BaseCipher {
    public static String encryptFile(String filePath, String keyPath) throws IOException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeySpecException {
        return SM2FileUtils.getEncryptStrFromFile(filePath, keyPath);
    }

    public static File decryptFile(String destFilePath, String encryptStr, String priKeyPath) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, IOException, InvalidKeySpecException {
        return SM2FileUtils.getFileFromEncryptStr(destFilePath, encryptStr, priKeyPath);
    }

    public static String getEncryptStrFromFile(String filePath, String keyPath) throws IOException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeySpecException {
        int n;
        byte[] fileBytes = null;
        FileInputStream fis = new FileInputStream(filePath);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((n = fis.read(b)) != -1) {
            bos.write(b, 0, n);
        }
        fileBytes = bos.toByteArray();
        fis.close();
        bos.close();
        byte[] zipFileBytes = SM2FileUtils.zip(fileBytes);
        String character = "ISO-8859-1";
        String encryptStr = SM2Utils.encrypt(new String(zipFileBytes, character), new File(keyPath));
        return encryptStr;
    }

    public static File getFileFromEncryptStr(String destFilePath, String encryptStr, String priKeyPath) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, IOException, InvalidKeySpecException {
        String decryptStr = SM2Utils.decrypt(encryptStr, new File(priKeyPath));
        byte[] decryptFileBytes = decryptStr.getBytes("ISO-8859-1");
        byte[] unZip = SM2FileUtils.unZip(decryptFileBytes);
        return SM2FileUtils.writeFile(destFilePath, unZip);
    }

    private static byte[] zip(byte[] data) throws IOException {
        byte[] b = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(bos);
        ZipEntry entry = new ZipEntry("ORDER_FILE.txt");
        entry.setSize(data.length);
        zip.putNextEntry(entry);
        zip.write(data);
        zip.closeEntry();
        zip.close();
        b = bos.toByteArray();
        bos.close();
        return b;
    }

    private static byte[] unZip(byte[] data) throws IOException {
        byte[] b = null;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ZipInputStream zip = new ZipInputStream(bis);
        while (zip.getNextEntry() != null) {
            byte[] buf = new byte[1024];
            int num = -1;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((num = zip.read(buf, 0, buf.length)) != -1) {
                baos.write(buf, 0, num);
            }
            b = baos.toByteArray();
            baos.flush();
            baos.close();
        }
        zip.close();
        bis.close();
        return b;
    }

    private static File writeFile(String destFilePath, byte[] fileByte) throws IOException {
        FileOutputStream fos = null;
        File file = new File(destFilePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        fos = new FileOutputStream(file.getPath());
        fos.write(fileByte);
        fos.flush();
        if (fos != null) {
            fos.close();
        }
        return file;
    }
}

