/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.StringCharacterIterator;
import java.util.HashMap;

public class StringUtil {
    public static final String DEFAULT_CHARSET = "UTF-8";

    public static String removeComma(String string) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (',' == string.charAt(i)) continue;
            sb.append(string.charAt(i));
        }
        return sb.toString();
    }

    public static String getClientIp() {
        String ip = "";
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return ip;
    }

    public static String toLetterOrDigit(String string) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i))) {
                sb.append(string.charAt(i));
                continue;
            }
            sb.append('X');
        }
        return sb.toString();
    }

    public static String toLetter(String string) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetter(string.charAt(i))) {
                sb.append(string.charAt(i));
                continue;
            }
            if (Character.isDigit(string.charAt(i))) {
                switch (string.charAt(i)) {
                    case '0': {
                        sb.append('A');
                        break;
                    }
                    case '1': {
                        sb.append('B');
                        break;
                    }
                    case '2': {
                        sb.append('C');
                        break;
                    }
                    case '3': {
                        sb.append('D');
                        break;
                    }
                    case '4': {
                        sb.append('E');
                        break;
                    }
                    case '5': {
                        sb.append('F');
                        break;
                    }
                    case '6': {
                        sb.append('G');
                        break;
                    }
                    case '7': {
                        sb.append('H');
                        break;
                    }
                    case '8': {
                        sb.append('I');
                        break;
                    }
                    case '9': {
                        sb.append('J');
                    }
                }
                continue;
            }
            sb.append('M');
        }
        return sb.toString();
    }

    public static int getUTF8BytesLength(String string) {
        int length = 0;
        try {
            length = string.getBytes(DEFAULT_CHARSET).length;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return length;
    }

    public static String bytes2hex(byte[] bytes) {
        String result = "";
        String b = "";
        for (int i = 0; i < bytes.length; ++i) {
            b = Integer.toHexString(bytes[i] & 0xFF);
            if (b.length() == 1) {
                b = "0" + b;
            }
            result = result + b;
        }
        return result.toUpperCase();
    }

    public static byte[] hex2bytes(String hexString) {
        hexString = hexString.toUpperCase();
        char[] chars = hexString.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int index = 0;
        for (int i = 0; i < chars.length; i += 2) {
            byte newByte = 0;
            newByte = (byte)(newByte | StringUtil.char2byte(chars[i]));
            newByte = (byte)(newByte << 4);
            bytes[index] = newByte = (byte)(newByte | StringUtil.char2byte(chars[i + 1]));
            ++index;
        }
        return bytes;
    }

    public static byte char2byte(char ch) {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': {
                return 10;
            }
            case 'B': {
                return 11;
            }
            case 'C': {
                return 12;
            }
            case 'D': {
                return 13;
            }
            case 'E': {
                return 14;
            }
            case 'F': {
                return 15;
            }
        }
        return 0;
    }

    private static void byte2hex(byte b, StringBuffer sb) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        sb.append(hexChars[high]);
        sb.append(hexChars[low]);
    }

    public static String toHexString(byte[] bytes, char c) {
        StringBuffer sb = new StringBuffer();
        int len = bytes.length;
        for (int i = 0; i < len; ++i) {
            StringUtil.byte2hex(bytes[i], sb);
            if (i >= len - 1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        int len = bytes.length;
        for (int i = 0; i < len; ++i) {
            StringUtil.byte2hex(bytes[i], sb);
        }
        return sb.toString();
    }

    public static boolean isEmpty(String str) {
        boolean isEmpty = false;
        isEmpty = null == str || "".equals(str.trim());
        return isEmpty;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static String replace(String string, String replacement) {
        if (string != null) {
            return string.replaceAll(replacement, "");
        }
        return null;
    }

    public static String getNodeText(String xmlString, String nodeName) {
        String beginName = "<" + nodeName + ">";
        String endName = "</" + nodeName + ">";
        int beginIndex = xmlString.indexOf(beginName);
        if (beginIndex == -1) {
            return "";
        }
        int endIndex = xmlString.indexOf(endName);
        String nodeValue = xmlString.substring(beginIndex + beginName.length(), endIndex);
        return nodeValue;
    }

    public static String escape(String src, HashMap<String, String> hashMap) {
        if (src == null || src.trim().length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        StringCharacterIterator sci = new StringCharacterIterator(src);
        char c = sci.first();
        while (c != '\uffff') {
            String ch = String.valueOf(c);
            if (hashMap.containsKey(ch)) {
                ch = hashMap.get(ch);
            }
            sb.append(ch);
            c = sci.next();
        }
        return sb.toString();
    }

    public static String escapeSQL(String input) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("'", "''");
        return StringUtil.escape(input, hashMap);
    }

    public static String escapeXML(String input) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("<", "&lt;");
        hashMap.put(">", "&gt;");
        hashMap.put("'", "&apos;");
        hashMap.put("\"", "&quot;");
        hashMap.put("&", "&amp;");
        return StringUtil.escape(input, hashMap);
    }

    public static String trim(String string) {
        if (StringUtil.isEmpty(string)) {
            return "";
        }
        return string.trim();
    }

    public static String genRandomNum(int length) {
        int randomIndex = -1;
        int i = -1;
        String randomID = "";
        char[] randomElement = new char[]{'3', '4', '5', '6', '7', '9', 'A', 'C', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y'};
        for (i = 0; i < length; ++i) {
            randomIndex = new Double(Math.random() * 998.0).intValue() % 27;
            randomID = String.valueOf(randomElement[randomIndex]) + randomID;
        }
        return randomID;
    }

    public static boolean convertUserProcess2Bool(String in) {
        return in != null && "ALLOW".equalsIgnoreCase(in);
    }

    public static boolean convertStr2Bool(String in) {
        return in != null && "true".equalsIgnoreCase(in);
    }
}

