/*
 * Decompiled with CFR 0.152.
 */
package request;

import java.util.LinkedList;
import request.Request;
import request.bean.ContractDataItem;
import request.bean.Signatory;
import util.StringUtil;

public class Tx1010Request
extends Request {
    private final String TX_ID = "1010";
    private String templateId;
    private boolean isPlatformSignatory;
    private String serialNumber;
    private String sealId;
    private String contractName;
    private LinkedList<ContractDataItem> contractData = new LinkedList();
    private String attachmentName;
    private String attachmentContentHash;
    private LinkedList<Signatory> signatories = new LinkedList();

    @Override
    public void initTxId() {
        this.setTxID("1010");
    }

    @Override
    public StringBuffer getTxString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (StringUtil.isNotEmpty(this.getTemplateId())) {
            stringBuffer.append(Request.appendNode("templateId", this.getTemplateId()));
        }
        if (this.getPlatformSignatory()) {
            stringBuffer.append(Request.appendNode("platformIsSignatory", "1"));
        } else {
            stringBuffer.append(Request.appendNode("platformIsSignatory", "0"));
        }
        if (StringUtil.isNotEmpty(this.getSerialNumber())) {
            stringBuffer.append(Request.appendNode("serialNumber", this.getSerialNumber()));
        }
        if (StringUtil.isNotEmpty(this.getContractName())) {
            stringBuffer.append(Request.appendNode("contractName", this.getContractName()));
        }
        if (StringUtil.isNotEmpty(this.getSealId())) {
            stringBuffer.append(Request.appendNode("sealId", this.getSealId()));
        }
        if (!this.getContractData().isEmpty()) {
            StringBuffer contractDataItemBuffer = new StringBuffer();
            for (ContractDataItem contractDataItem : this.getContractData()) {
                contractDataItemBuffer.append(Request.appendNode("contractDataKey", contractDataItem.getContractDataKey()));
                contractDataItemBuffer.append(Request.appendNode("contractDataValue", contractDataItem.getContractDataValue()));
                contractDataItemBuffer.append(Request.appendNode("contractDataItem", contractDataItemBuffer));
            }
            contractDataItemBuffer = Request.appendNode("contractData", contractDataItemBuffer);
            stringBuffer.append(contractDataItemBuffer);
        }
        if (StringUtil.isNotEmpty(this.getAttachmentName()) && StringUtil.isNotEmpty(this.getAttachmentContentHash())) {
            stringBuffer.append(Request.appendNode("attachmentName", this.getAttachmentName()));
            stringBuffer.append(Request.appendNode("attachmentContentHash", this.getAttachmentContentHash()));
        }
        if (!this.getSignatories().isEmpty()) {
            StringBuffer signatoriesStringBuffer = new StringBuffer();
            for (Signatory signatory : this.getSignatories()) {
                signatoriesStringBuffer.append(signatory.getXMLStringBuffer());
            }
            signatoriesStringBuffer = Request.appendNode("signatories", signatoriesStringBuffer);
            stringBuffer.append(signatoriesStringBuffer);
        }
        return stringBuffer;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public boolean getPlatformSignatory() {
        return this.isPlatformSignatory;
    }

    public void setPlatformSignatory(boolean platformSignatory) {
        this.isPlatformSignatory = platformSignatory;
    }

    public String getContractName() {
        return this.contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getSealId() {
        return this.sealId;
    }

    public void setSealId(String sealId) {
        this.sealId = sealId;
    }

    public LinkedList<ContractDataItem> getContractData() {
        return this.contractData;
    }

    public void setContractData(LinkedList<ContractDataItem> contractData) {
        this.contractData = contractData;
    }

    public LinkedList<Signatory> getSignatories() {
        return this.signatories;
    }

    public void setSignatories(LinkedList<Signatory> signatories) {
        this.signatories = signatories;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    public String getAttachmentContentHash() {
        return this.attachmentContentHash;
    }

    public void setAttachmentContentHash(String attachmentContentHash) {
        this.attachmentContentHash = attachmentContentHash;
    }
}

