/*
 * Decompiled with CFR 0.152.
 */
package logger;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackConfigLoader {
    private static Logger logger = LoggerFactory.getLogger(LogbackConfigLoader.class);

    public void load(String externalConfigFileLocation) {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        File externalConfigFile = new File(externalConfigFileLocation);
        if (!externalConfigFile.exists()) {
            logger.error("Logback\u914d\u7f6e\u6587\u4ef6\u65e0\u6cd5\u5b9a\u4f4d\uff0c\u8def\u5f84\uff1a{}", (Object)externalConfigFileLocation);
        } else if (!externalConfigFile.isFile()) {
            logger.error("Logback\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u8def\u5f84\uff1a{}", (Object)externalConfigFileLocation);
        } else if (!externalConfigFile.canRead()) {
            logger.error("Logback\u914d\u7f6e\u6587\u4ef6\u65e0\u6cd5\u8bfb\u53d6\uff0c\u8def\u5f84\uff1a{}", (Object)externalConfigFileLocation);
        } else {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(lc);
            lc.reset();
            try {
                configurator.doConfigure(externalConfigFileLocation);
            }
            catch (JoranException e) {
                logger.error("Logback\u4ece\u6587\u4ef6\u4e2d\u8fdb\u884c\u914d\u7f6e\u53d1\u751f\u5f02\u5e38\uff0c\u8def\u5f84\uff1a{}\uff0c\u5f02\u5e38\uff1a{}", (Object)externalConfigFileLocation, (Object)e);
            }
            StatusPrinter.printInCaseOfErrorsOrWarnings(lc);
        }
    }
}

