/*
 * Decompiled with CFR 0.152.
 */
package com.esms.common.util;

import com.thoughtworks.xstream.XStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    private static final XStream xstream = new XStream();
    private static final String MAP_OPEN = "<map>";
    private static final String MAP_CLOSE = "</map>";
    private static final String MAP_EMPTY = "<map/>";
    private static final String ENTRY_OPEN = "<entry>";
    private static final String ENTRY_CLOSE = "</entry>";
    private static final String VALUE_OPEN = "<string>";
    private static final String VALUE_CLOSE = "</string>";

    public static Object fromXML(String xml) {
        return xstream.fromXML(xml);
    }

    public static String toXML(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return MAP_EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(MAP_OPEN);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            XmlUtil.addEntry(sb, entry.getKey(), entry.getValue() == null ? "" : entry.getValue().toString());
        }
        sb.append(MAP_CLOSE);
        return sb.toString();
    }

    private static void addEntry(StringBuilder sb, String key, String value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("key or value is null");
        }
        sb.append(ENTRY_OPEN);
        sb.append(VALUE_OPEN);
        XmlUtil.escapeElementEntities(sb, key);
        sb.append(VALUE_CLOSE);
        sb.append(VALUE_OPEN);
        XmlUtil.escapeElementEntities(sb, value);
        sb.append(VALUE_CLOSE);
        sb.append(ENTRY_CLOSE);
    }

    private static void escapeElementEntities(StringBuilder sb, String text) {
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
    }
}

