/*
 * Decompiled with CFR 0.152.
 */
package com.esms.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;

public class CommonUtil {
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static String numericRegx = "\\d+";

    public static boolean isNotBlank(String src) {
        return !CommonUtil.isBlank(src);
    }

    public static long getTime(String timeStr) {
        try {
            return CommonUtil.isNotBlank(timeStr) ? sdf.parse(timeStr).getTime() : System.currentTimeMillis();
        }
        catch (ParseException e) {
            return System.currentTimeMillis();
        }
    }

    public static UUID getUUID(String uuidStr) {
        try {
            return CommonUtil.isNotBlank(uuidStr) ? UUID.fromString(uuidStr) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isValidArray(Object[] arr) {
        return arr != null && arr.length >= 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isIP(String ip) {
        String[] segs;
        if (CommonUtil.isNotBlank(ip) && (segs = ip.split("\\.")).length == 4) {
            try {
                String[] stringArray = segs;
                int n = segs.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return true;
                    }
                    String seg = stringArray[n2];
                    int temp = Integer.parseInt(seg);
                    if (temp < 0 || temp > 255) {
                        return false;
                    }
                    ++n2;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean verifyStr(String src, boolean notBlank, boolean limitLenFlag, int limitLen, boolean numeric) {
        int len;
        if (CommonUtil.isBlank(src)) {
            return !notBlank;
        }
        if (limitLenFlag && (len = src.codePointCount(0, src.length())) > limitLen) {
            return false;
        }
        if (numeric) {
            return src.matches(numericRegx);
        }
        return true;
    }

    public static String createSignature(String userName, String timestamp, String privateKey) {
        String encryparmastr = "Account=" + userName.toLowerCase() + "&TimeStamp=" + timestamp + "&AppSecret=" + privateKey;
        return DigestUtils.md5Hex((String)encryparmastr);
    }

    public static boolean checkPwd(String password) {
        if (CommonUtil.isBlank(password)) {
            return false;
        }
        String reg = "^(?!([a-zA-Z]+|\\d+)$)[a-zA-Z\\d]{8,20}$";
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(password);
        boolean isLegal = m.matches();
        return isLegal;
    }
}

