/*
 * Decompiled with CFR 0.152.
 */
package com.esms.common.pool;

import com.esms.HostInfo;
import com.esms.common.ConnectionSupport;
import com.esms.common.pool.SocketObject;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;

public class SocketObjectFactory
extends BaseKeyedPoolableObjectFactory {
    private static long maxIdleTime = 50000L;
    private HostInfo proxyHost;
    private HostInfo host;
    private boolean shortConnMode = false;
    private int soTimeout = 30000;

    public Object makeObject(Object key) throws Exception {
        return ConnectionSupport.getValidSockObj(this.proxyHost, this.host, this.soTimeout);
    }

    public boolean validateObject(Object key, Object obj) {
        SocketObject sockObj = (SocketObject)obj;
        long lastUsedTime = sockObj.getLastUsedTime();
        long curTime = System.currentTimeMillis();
        sockObj.setLastUsedTime(curTime);
        if (curTime - lastUsedTime < maxIdleTime) {
            return sockObj.isValid();
        }
        return false;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        SocketObject sockObj = (SocketObject)obj;
        sockObj.destory();
    }

    public void passivateObject(Object key, Object obj) throws Exception {
        if (this.shortConnMode) {
            this.destroyObject(key, obj);
        }
    }

    public HostInfo getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(HostInfo proxyHost) {
        this.proxyHost = proxyHost;
    }

    public HostInfo getHost() {
        return this.host;
    }

    public void setHost(HostInfo host) {
        this.host = host;
    }

    public void setShortConnMode(boolean shortConnMode) {
        this.shortConnMode = shortConnMode;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }
}

