/*
 * Decompiled with CFR 0.152.
 */
package com.esms.common;

import com.esms.HostInfo;
import com.esms.common.pool.SocketObject;
import com.esms.common.util.CommonUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSupport {
    public static final String CRLF = "\r\n";

    public static String getPostReq(HostInfo proxyHost, HostInfo destHost, String addHead, String httpBody) {
        StringBuilder httpReq = new StringBuilder();
        httpReq.append("POST /BackStageService.asmx HTTP/1.1").append(CRLF);
        httpReq.append("Host: ").append(destHost.toString()).append(CRLF);
        httpReq.append("Content-Type: text/xml; charset=utf-8").append(CRLF);
        httpReq.append("Content-Length: ").append(httpBody.length()).append(CRLF);
        httpReq.append("Connection: Keep-Alive").append(CRLF);
        httpReq.append("Cache-Control: no-cache").append(CRLF);
        httpReq.append("Pragma: no-cache").append(CRLF);
        if (proxyHost != null && proxyHost.getType() == HostInfo.ConnectionType.HTTP) {
            httpReq.append(HttpSupport.getProxyAuth(proxyHost));
        }
        if (CommonUtil.isNotBlank(addHead)) {
            httpReq.append(addHead).append(CRLF);
        }
        httpReq.append(CRLF);
        httpReq.append(httpBody);
        return httpReq.toString();
    }

    public static String getConnectResq(HostInfo proxyHost, HostInfo destHost) {
        StringBuffer httpReq = new StringBuffer();
        httpReq.append("CONNECT ").append(destHost.toString()).append(" HTTP/1.1").append(CRLF);
        httpReq.append("User-Agent: PostMsg").append(CRLF);
        httpReq.append("Host: ").append(destHost.toString()).append(CRLF);
        httpReq.append("Content-Length: 0").append(CRLF);
        httpReq.append("Proxy-Connection: Keep-Alive").append(CRLF);
        httpReq.append("Cache-Control: no-cache").append(CRLF);
        httpReq.append("Pragma: no-cache").append(CRLF);
        if (proxyHost != null && proxyHost.getType() == HostInfo.ConnectionType.HTTP) {
            httpReq.append(HttpSupport.getProxyAuth(proxyHost));
        }
        httpReq.append(CRLF);
        return httpReq.toString();
    }

    private static String getProxyAuth(HostInfo proxyHost) {
        StringBuilder proxyAuth = new StringBuilder();
        proxyAuth.append("Proxy-Authorization: Basic ");
        proxyAuth.append(Base64.encodeBase64String((byte[])(String.valueOf(proxyHost.getUsername()) + ":" + proxyHost.getPassword()).getBytes()));
        return proxyAuth.toString();
    }

    public static String getRespContent(SocketObject obj) throws IOException {
        char[] chars = null;
        BufferedReader reader = obj.getReader();
        String str = reader.readLine();
        int respCode = 0;
        if (CommonUtil.isNotBlank(str)) {
            respCode = HttpSupport.getResponseCode(str);
            if (respCode != 200) {
                System.out.println(str);
            }
        } else {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        while ((str = reader.readLine()) != null) {
            if (CommonUtil.isBlank(str)) break;
            sb.append(str).append(CRLF);
        }
        Map<String, String> params = HttpSupport.parseHttpHead(sb.toString());
        String tempStr = params.get("content-length");
        if (CommonUtil.isNotBlank(tempStr)) {
            int len = Integer.parseInt(tempStr);
            if (len <= 0) {
                return null;
            }
            chars = new char[len];
            int read = 0;
            while (read < len) {
                int cur = reader.read(chars, read, len - read);
                if (cur == -1) {
                    obj.getSocket().close();
                    break;
                }
                read += cur;
            }
            return new String(chars).trim();
        }
        return null;
    }

    public static int getResponseCode(String httpResp) {
        String[] strs;
        if (CommonUtil.isNotBlank(httpResp) && (strs = httpResp.split(" ")).length >= 2) {
            return Integer.parseInt(strs[1]);
        }
        return -1;
    }

    private static Map<String, String> parseHttpHead(String httpHead) {
        HashMap<String, String> params = new HashMap<String, String>();
        String[] stringArray = httpHead.split(CRLF);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            int splitIdx = str.indexOf(":");
            if (splitIdx > 0 && splitIdx + 1 < str.length()) {
                params.put(str.substring(0, splitIdx).toLowerCase().trim(), str.substring(splitIdx + 1, str.length()).trim());
            }
            ++n2;
        }
        return params;
    }
}

