/*
 * Decompiled with CFR 0.152.
 */
package com.esms;

import com.esms.ConfigInfo;
import com.esms.HostInfo;
import com.esms.MOMsg;
import com.esms.MessageData;
import com.esms.ProxyServer;
import com.esms.common.MTSupport;
import com.esms.common.entity.Account;
import com.esms.common.entity.AccountInfo;
import com.esms.common.entity.BindChannel;
import com.esms.common.entity.BusinessType;
import com.esms.common.entity.GsmsResponse;
import com.esms.common.entity.MTPack;
import com.esms.common.entity.MTReport;
import com.esms.common.entity.MTResponse;
import com.esms.common.entity.TicketInfo;
import com.esms.common.util.CommonUtil;
import com.esms.common.util.Interceptor;
import com.xuanwu.msggate.common.protobuf.CommonItem;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.UUID;

public class PostMsg {
    private boolean autoConfirm = true;
    private HostInfo wsHost = new HostInfo("211.147.224.154", 8080);
    private HostInfo gwHost = new HostInfo("211.147.224.154", 18013);
    private ProxyServer proxy;
    private boolean isInShortMode;
    private int soTimeout;
    private int maxConns;
    private int reSendTimes = 0;
    private int reMoQueryTimes = 0;
    private int sendFailCount = 0;
    private int moQueryFailCount = 0;
    boolean isMoReQuerySuccess = false;
    public static final int E_INVALID_USER_PASSWORD = -6;
    public static final int E_FAILED_CONNECTED_TO_SERVER = -3;
    public static final int E_FAILED_TO_POST_MESSAGE = -99;
    public static final int E_INVALID_MESSAGE_DATA = -5;
    private Account account;

    public PostMsg() {
        this(false);
    }

    public PostMsg(boolean isInShortMode) {
        this(isInShortMode, 50000);
    }

    public PostMsg(boolean shortConnMode, int soTimeout) {
        this(shortConnMode, soTimeout, 2);
    }

    public PostMsg(boolean shortConnMode, int soTimeout, int maxConns) {
        this.isInShortMode = shortConnMode;
        this.soTimeout = soTimeout;
        this.maxConns = maxConns;
        this.proxy = new ProxyServer(this.gwHost, this.wsHost, shortConnMode, soTimeout, maxConns);
    }

    public HostInfo getCmHost() {
        return this.gwHost;
    }

    public HostInfo getWsHost() {
        return this.wsHost;
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    public GsmsResponse post(Account account, MTPack pack) throws Exception {
        MTSupport.verifyPack(pack);
        try {
            return this.proxy.sendMessage(account, pack);
        }
        catch (Exception e) {
            GsmsResponse resp = this.doReSend(account, pack);
            if (resp != null) {
                return resp;
            }
            throw e;
        }
    }

    private GsmsResponse doReSend(Account account, MTPack pack) throws Exception {
        if (this.isNeedRePost()) {
            return this.post(account, pack);
        }
        return null;
    }

    private boolean isNeedRePost() {
        boolean flag = true;
        if (this.sendFailCount >= this.reSendTimes) {
            this.sendFailCount = 0;
            flag = this.changeMTAddress();
        } else {
            ++this.sendFailCount;
        }
        return flag;
    }

    private boolean changeMTAddress() {
        boolean isChanged = this.getCmHost().changeHost();
        if (isChanged) {
            System.out.println("change mt address");
            this.proxy = new ProxyServer(this.getCmHost(), this.wsHost, this.isInShortMode, this.soTimeout, this.maxConns);
        }
        return isChanged;
    }

    public MTReport[] getReports(Account account, int fetchSize) throws Exception {
        if (fetchSize <= 0) {
            return null;
        }
        try {
            return this.proxy.getReports(account, fetchSize, 3);
        }
        catch (Exception e) {
            MTReport[] reports = this.doReMoQueryReport(account, fetchSize);
            if (this.isMoReQuerySuccess) {
                this.isMoReQuerySuccess = false;
                return reports;
            }
            throw e;
        }
    }

    private MTReport[] doReMoQueryReport(Account account, int fetchSize) throws Exception {
        if (this.ifNeedMoReQuery()) {
            MTReport[] reports = this.getReports(account, fetchSize);
            this.isMoReQuerySuccess = true;
            return reports;
        }
        return null;
    }

    private boolean ifNeedMoReQuery() {
        boolean flag = true;
        if (this.moQueryFailCount >= this.reMoQueryTimes) {
            this.moQueryFailCount = 0;
            flag = this.changeMOAddress();
        } else {
            ++this.moQueryFailCount;
        }
        return flag;
    }

    private boolean changeMOAddress() {
        boolean isChanged = this.getWsHost().changeHost();
        if (isChanged) {
            System.out.println("change mo address");
            this.proxy = new ProxyServer(this.gwHost, this.getWsHost(), this.isInShortMode, this.soTimeout, this.maxConns);
        }
        return isChanged;
    }

    public MOMsg[] getMOMsgs(Account account, int fetchSize) throws Exception {
        if (fetchSize <= 0) {
            return null;
        }
        try {
            return this.proxy.getMOMsgs(account, fetchSize);
        }
        catch (Exception e) {
            MOMsg[] msgs = this.doReMoQueryMO(account, fetchSize);
            if (this.isMoReQuerySuccess) {
                this.isMoReQuerySuccess = false;
                return msgs;
            }
            throw e;
        }
    }

    private MOMsg[] doReMoQueryMO(Account account, int fetchSize) throws Exception {
        if (this.ifNeedMoReQuery()) {
            MOMsg[] msgs = this.getMOMsgs(account, fetchSize);
            this.isMoReQuerySuccess = true;
            return msgs;
        }
        return null;
    }

    public void setInterceptor(Interceptor interceptor) {
        this.proxy.setInterceptor(interceptor);
    }

    public AccountInfo getAccountInfo(Account account) throws Exception {
        try {
            return this.proxy.getAccountInfo(account);
        }
        catch (Exception e) {
            AccountInfo accountInfo = this.doReGetAccountInfo(account);
            if (this.isMoReQuerySuccess) {
                this.isMoReQuerySuccess = false;
                return accountInfo;
            }
            throw e;
        }
    }

    private AccountInfo doReGetAccountInfo(Account account) throws Exception {
        if (this.ifNeedMoReQuery()) {
            AccountInfo ai = this.getAccountInfo(account);
            this.isMoReQuerySuccess = true;
            return ai;
        }
        return null;
    }

    public MTResponse[] getResps(Account account, int fetchSize) throws Exception {
        if (fetchSize <= 0) {
            return null;
        }
        try {
            return this.proxy.getResps(account, fetchSize, 3);
        }
        catch (Exception e) {
            MTResponse[] reps = this.doReGetResps(account, fetchSize);
            if (this.isMoReQuerySuccess) {
                this.isMoReQuerySuccess = false;
                return reps;
            }
            throw e;
        }
    }

    private MTResponse[] doReGetResps(Account account, int fetchSize) throws Exception {
        if (this.ifNeedMoReQuery()) {
            MTResponse[] resps = this.getResps(account, fetchSize);
            this.isMoReQuerySuccess = true;
            return resps;
        }
        return null;
    }

    public MTResponse[] findResps(Account account, int pageIndex, UUID batchID, String phone, int method) throws Exception {
        if (pageIndex <= 0) {
            return null;
        }
        if (batchID == null && CommonUtil.isBlank(phone)) {
            throw new IllegalArgumentException("\u53c2\u6570\u65e0\u6548\uff08\u6279\u6b21ID\u548c\u624b\u673a\u53f7\u7801\u5176\u4e2d\u4e00\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff09");
        }
        try {
            return this.proxy.findResps(account, pageIndex, batchID, phone, method != 1);
        }
        catch (Exception e) {
            MTResponse[] resps = this.doReFindResps(account, pageIndex, batchID, phone, method);
            if (resps != null) {
                return resps;
            }
            throw e;
        }
    }

    private MTResponse[] doReFindResps(Account account, int pageIndex, UUID batchID, String phone, int method) throws Exception {
        if (this.ifNeedMoReQuery()) {
            MTResponse[] resp = this.findResps(account, pageIndex, batchID, phone, method);
            this.isMoReQuerySuccess = true;
            return resp;
        }
        return null;
    }

    @Deprecated
    public TicketInfo findTickets(Account account, String phone, Date startTime, Date endTime, String userName, int pageIndex) throws Exception {
        if (pageIndex <= 0) {
            return null;
        }
        try {
            return this.proxy.findTickets(account, phone, startTime, endTime, userName, pageIndex);
        }
        catch (Exception e) {
            TicketInfo ti = this.doReFindTickets(account, phone, startTime, endTime, userName, pageIndex);
            if (this.isMoReQuerySuccess) {
                this.isMoReQuerySuccess = false;
                return ti;
            }
            throw e;
        }
    }

    private TicketInfo doReFindTickets(Account account, String phone, Date startTime, Date endTime, String userName, int pageIndex) throws Exception {
        if (this.ifNeedMoReQuery()) {
            TicketInfo ti = this.doReFindTickets(account, phone, startTime, endTime, userName, pageIndex);
            this.isMoReQuerySuccess = true;
            return ti;
        }
        return null;
    }

    public MTReport[] findReports(Account account, int pageIndex, UUID batchID, String phone, int method) throws Exception {
        if (pageIndex <= 0) {
            return null;
        }
        if (batchID == null && CommonUtil.isBlank(phone)) {
            throw new IllegalArgumentException("\u53c2\u6570\u65e0\u6548\uff08\u6279\u6b21ID\u548c\u624b\u673a\u53f7\u7801\u5176\u4e2d\u4e00\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff09");
        }
        try {
            return this.proxy.findReports(account, pageIndex, batchID, phone, method != 1);
        }
        catch (Exception e) {
            MTReport[] reports = this.doReFindReports(account, pageIndex, batchID, phone, method);
            if (this.isMoReQuerySuccess) {
                this.isMoReQuerySuccess = false;
                return reports;
            }
            throw e;
        }
    }

    private MTReport[] doReFindReports(Account account, int pageIndex, UUID batchID, String phone, int method) throws Exception {
        if (this.ifNeedMoReQuery()) {
            MTReport[] reports = this.findReports(account, pageIndex, batchID, phone, method);
            this.isMoReQuerySuccess = true;
            return reports;
        }
        return null;
    }

    public int modifyPassword(Account account, String newPwd) throws Exception {
        if (!CommonUtil.checkPwd(newPwd)) {
            throw new IllegalArgumentException("\u53c2\u6570\u65e0\u6548(newPwd:\u53c2\u6570\u503c\u9519\u8bef,\u8981\u6c42\u4e3a8-20\u4f4d\u6570\u5b57\u548c\u5b57\u6bcd\u7684\u7ec4\u5408,\u4e14\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        try {
            return this.proxy.modifyPassword(account, newPwd);
        }
        catch (Exception e) {
            int result = this.doReModifyPassword(account, newPwd);
            if (this.isMoReQuerySuccess) {
                this.isMoReQuerySuccess = false;
                return result;
            }
            throw e;
        }
    }

    private int doReModifyPassword(Account account, String newPwd) throws Exception {
        if (this.ifNeedMoReQuery()) {
            this.isMoReQuerySuccess = true;
            return this.modifyPassword(account, newPwd);
        }
        return -100;
    }

    public BusinessType[] getBizTypes(Account account) throws Exception {
        try {
            return this.proxy.getBizTypes(account);
        }
        catch (Exception e) {
            BusinessType[] types = this.doReGetBizTypes(account);
            if (types != null) {
                return types;
            }
            throw e;
        }
    }

    private BusinessType[] doReGetBizTypes(Account account) throws Exception {
        if (this.ifNeedMoReQuery()) {
            BusinessType[] types = this.getBizTypes(account);
            this.isMoReQuerySuccess = true;
            return types;
        }
        return null;
    }

    public boolean confirmRespRequest(Account account, CommonItem.UUID uuid) throws Exception {
        return this.proxy.confirmRequest(account, CommonItem.OMsgType.RESP, uuid);
    }

    public boolean confirmReportRequest(Account account, CommonItem.UUID uuid) throws Exception {
        return this.proxy.confirmRequest(account, CommonItem.OMsgType.REPORT, uuid);
    }

    public boolean confirmMoRequest(Account account, CommonItem.UUID uuid) throws Exception {
        return this.proxy.confirmRequest(account, CommonItem.OMsgType.MO, uuid);
    }

    public void setAutoConfirm(boolean autoConfirm) {
        this.autoConfirm = autoConfirm;
        this.proxy.setAutoConfirm(autoConfirm);
    }

    public boolean isAutoConfirm() {
        return this.autoConfirm;
    }

    public int getReSendTimes() {
        return this.reSendTimes;
    }

    public void setReSendTimes(int reSendTimes) {
        this.reSendTimes = reSendTimes;
    }

    public int getReMoQueryTimes() {
        return this.reMoQueryTimes;
    }

    public void setReMoQueryTimes(int reMoQueryTimes) {
        this.reMoQueryTimes = reMoQueryTimes;
    }

    @Deprecated
    public PostMsg(String name, String password) {
        this(false);
        this.setUser(name, password);
    }

    @Deprecated
    public void setUser(String name, String password) {
        this.account = new Account(name, password);
    }

    @Deprecated
    public void getUser(StringBuilder name, StringBuilder password) {
        name.replace(0, name.length(), this.account.getName());
        password.replace(0, password.length(), this.account.getPassword());
    }

    @Deprecated
    public int getRemainFee() {
        try {
            AccountInfo acInfo = this.getAccountInfo(this.account);
            return acInfo == null ? 0 : (int)acInfo.getBalance();
        }
        catch (Exception e) {
            if (e instanceof ConnectException) {
                return -3;
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    @Deprecated
    public MOMsg[] getMOMsg() throws ConnectException {
        try {
            return this.getMOMsgs(this.account, 100);
        }
        catch (Exception e) {
            if (e instanceof ConnectException) {
                throw new ConnectException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    @Deprecated
    public ConfigInfo getConfigInfo() throws ConnectException {
        try {
            ConfigInfo cInfo = new ConfigInfo(this.getAccountInfo(this.account));
            BusinessType[] bizTypes = this.getBizTypes(this.account);
            if (bizTypes != null) {
                HashSet<String> specNums = new HashSet<String>();
                BusinessType[] businessTypeArray = bizTypes;
                int n = bizTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    BusinessType bizType = businessTypeArray[n2];
                    if (bizType.getBindChs() != null) {
                        for (BindChannel bindCh : bizType.getBindChs()) {
                            specNums.add(bindCh.getSpecNumber());
                        }
                    }
                    ++n2;
                }
                cInfo.setCanumber(specNums.toArray(new String[specNums.size()]));
            }
            return cInfo;
        }
        catch (Exception e) {
            if (e instanceof ConnectException) {
                throw new ConnectException(e.getMessage());
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    @Deprecated
    public int modifyPassword(String newPwd) {
        try {
            return this.modifyPassword(this.account, newPwd);
        }
        catch (Exception e) {
            if (e instanceof ConnectException) {
                return -3;
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    @Deprecated
    private int finalPost(Account account, MTPack pack) {
        GsmsResponse resp = null;
        pack.setBatchID(UUID.randomUUID());
        pack.setMsgType(MTPack.MsgType.SMS);
        try {
            resp = this.post(account, pack);
            return resp.getResult();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Deprecated
    public int post(String phone, String content, String subId) {
        MessageData msg = new MessageData(phone, content);
        MTPack pack = new MTPack();
        pack.setSendType(MTPack.SendType.MASS);
        pack.setCustomNum(subId);
        ArrayList<MessageData> msgs = new ArrayList<MessageData>();
        msgs.add(msg);
        pack.setMsgs(msgs);
        return this.finalPost(this.account, pack);
    }

    @Deprecated
    public int post(String[] phones, String content, String subId) {
        if (!CommonUtil.isValidArray(phones)) {
            return -5;
        }
        MTPack pack = new MTPack();
        pack.setSendType(MTPack.SendType.MASS);
        ArrayList<MessageData> msgs = new ArrayList<MessageData>();
        String[] stringArray = phones;
        int n = phones.length;
        int n2 = 0;
        while (n2 < n) {
            String phone = stringArray[n2];
            MessageData msg = new MessageData(phone, content);
            msgs.add(msg);
            ++n2;
        }
        pack.setMsgs(msgs);
        pack.setCustomNum(subId);
        return this.finalPost(this.account, pack);
    }

    @Deprecated
    public int post(MessageData[] msgs, String subId) {
        if (!CommonUtil.isValidArray(msgs)) {
            return -5;
        }
        MTPack pack = new MTPack();
        pack.setSendType(MTPack.SendType.GROUP);
        pack.setCustomNum(subId);
        ArrayList<MessageData> msgList = new ArrayList<MessageData>();
        MessageData[] messageDataArray = msgs;
        int n = msgs.length;
        int n2 = 0;
        while (n2 < n) {
            MessageData msg = messageDataArray[n2];
            msgList.add(msg);
            ++n2;
        }
        pack.setMsgs(msgList);
        return this.finalPost(this.account, pack);
    }

    @Deprecated
    public int postUmp(String phone, String content, String subId, String orgCode) {
        MessageData msg = MessageData.getInstance(phone, content, orgCode);
        MTPack pack = new MTPack();
        pack.setSendType(MTPack.SendType.MASS);
        pack.setCustomNum(subId);
        ArrayList<MessageData> msgs = new ArrayList<MessageData>();
        msgs.add(msg);
        pack.setMsgs(msgs);
        return this.finalPost(this.account, pack);
    }

    @Deprecated
    public int postUmp(String[] phones, String content, String subId, String orgCode) {
        if (!CommonUtil.isValidArray(phones)) {
            return -5;
        }
        MTPack pack = new MTPack();
        pack.setSendType(MTPack.SendType.MASS);
        ArrayList<MessageData> msgs = new ArrayList<MessageData>();
        String[] stringArray = phones;
        int n = phones.length;
        int n2 = 0;
        while (n2 < n) {
            String phone = stringArray[n2];
            MessageData msg = MessageData.getInstance(phone, content, orgCode);
            msgs.add(msg);
            ++n2;
        }
        pack.setMsgs(msgs);
        pack.setCustomNum(subId);
        return this.finalPost(this.account, pack);
    }
}

