/*
 * Decompiled with CFR 0.152.
 */
package com.esms;

import com.esms.common.entity.EmailContent;
import com.esms.common.entity.MediaItem;
import com.esms.common.entity.TemplateData;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageData {
    private String phone;
    private String content;
    private List<MediaItem> medias;
    private String customMsgID;
    private String customNum;
    private boolean vipFlag = false;
    private String orgCode;
    private int msgFmt;
    private Map<String, TemplateData> templateDatas;
    private EmailContent emailContent;
    private String openId;
    private String email;
    private String url;

    public MessageData(String phone, String content) {
        this.setPhone(phone);
        this.setContent(content);
    }

    public MessageData(String phone, String content, String customMsgID) {
        this.setPhone(phone);
        this.setContent(content);
        this.setCustomMsgID(customMsgID);
    }

    public static MessageData getInstance(String phone, String content) {
        MessageData messageData = new MessageData(phone, content);
        messageData.setOrgCode("");
        return messageData;
    }

    public static MessageData getWechatInstance(String openId, Map<String, TemplateData> templateDatas, String url) {
        MessageData messageData = new MessageData("", "");
        messageData.setOpenId(openId);
        messageData.setTemplateDatas(templateDatas);
        messageData.setUrl(url);
        return messageData;
    }

    public static MessageData getTemplateInstance(String phone, Map<String, TemplateData> templateDatas) {
        MessageData messageData = new MessageData(phone, "");
        messageData.setTemplateDatas(templateDatas);
        return messageData;
    }

    public static MessageData getInstance(String phone, String content, String orgCode) {
        MessageData messageData = new MessageData(phone, content);
        messageData.setOrgCode(orgCode);
        return messageData;
    }

    public static MessageData getInstance(String phone, String content, String orgCode, int msgFmt) {
        MessageData messageData = new MessageData(phone, content);
        messageData.setOrgCode(orgCode);
        messageData.setMsgFmt(msgFmt);
        return messageData;
    }

    public static MessageData getEmailMsgInstance(String email, String content) {
        MessageData messageData = new MessageData("", content);
        messageData.setEmail(email);
        return messageData;
    }

    public static MessageData getEmailTemplateInstance(String email, Map<String, TemplateData> templateValue) {
        MessageData messageData = MessageData.getTemplateInstance("", templateValue);
        messageData.setEmail(email);
        return messageData;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone == null ? "" : phone;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content == null ? "" : content;
    }

    public List<MediaItem> getMedias() {
        return this.medias;
    }

    public void setMedias(List<MediaItem> medias) {
        this.medias = medias;
    }

    public String getCustomMsgID() {
        return this.customMsgID;
    }

    public void setCustomMsgID(String customMsgID) {
        this.customMsgID = customMsgID;
    }

    public String getCustomNum() {
        return this.customNum;
    }

    public void setCustomNum(String customNum) {
        this.customNum = customNum;
    }

    public boolean isVipFlag() {
        return this.vipFlag;
    }

    public void setVipFlag(boolean vipFlag) {
        this.vipFlag = vipFlag;
    }

    public String getOrgCode() {
        return this.orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode == null ? "" : orgCode;
    }

    public int getMsgFmt() {
        return this.msgFmt;
    }

    public void setMsgFmt(int msgFmt) {
        if (msgFmt < 0 || msgFmt > 255) {
            throw new RuntimeException("msgFmt must be greater than 0 and less than 255, but msgFmt=" + msgFmt);
        }
        this.msgFmt = msgFmt;
    }

    public Map<String, TemplateData> getTemplateDatas() {
        return this.templateDatas;
    }

    public void setTemplateDatas(Map<String, TemplateData> templateDatas) {
        this.templateDatas = templateDatas;
    }

    public String getOpenId() {
        return this.openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public EmailContent getEmailContent() {
        return this.emailContent;
    }

    public void setEmailContent(EmailContent emailContent) {
        this.emailContent = emailContent;
    }

    public String toString() {
        return "MessageData [phone=" + this.phone + ", content=" + this.content + ", medias=" + this.medias + ", customMsgID=" + this.customMsgID + ", customNum=" + this.customNum + ", vipFlag=" + this.vipFlag + ", orgCode=" + this.orgCode + ", msgFmt=" + this.msgFmt + "]";
    }
}

