package hls.support.core.wechat.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
//import org.apache.http.HttpEntity;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
//import org.apache.http.util.EntityUtils;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

/**
 * Created with IntelliJ IDEA.
 * User: yang
 * Date: 2017-11-09
 * Time: 14:38
 */
public class WechatTokenUtils {
    public final static String Type_CORP_ID = "corp";
    public final static String TYPE_APP_ID = "app";
    public static final int CODE_UNRECOGNIZED_TOKEN_TYPE = -11;
    public static final int CODE_REQUEST_FAILED = -12;
    private static final String CORP_TOKEN_URL = "https://qyapi.weixin.qq.com/cgi-bin/gettoken";
    private static final String APP_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token";
    private static Logger logger = LoggerFactory.getLogger(WechatTokenUtils.class);

    public static JSONObject getToken(String id, String secret, String type) {
        switch (type) {
            case TYPE_APP_ID:
                if (logger.isTraceEnabled()) {
                    logger.trace("tokenType:{}", type);
                }
                return getAppToken(id, secret);
            case Type_CORP_ID:
                return getCorpToken(id, secret);
            default:
                logger.error("unrecognized TokenType: {}", type);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("errcode", CODE_UNRECOGNIZED_TOKEN_TYPE);
                jsonObject.put("errmsg", "unrecognized TokenType");
                return jsonObject;
        }
    }

    private static JSONObject getCorpToken(String id, String secret) {
        String url = CORP_TOKEN_URL + "?corpid=" + id + "&corpsecret=" + secret;
        return getRequest(url);
    }

    private static JSONObject getRequest(String url) {
        HttpGet get = new HttpGet(url);
        JSONObject jsonObject = new JSONObject();
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse execute = null;
        try {
            execute = client.execute(get);
        } catch (IOException e) {
            jsonObject.put("errcode", CODE_REQUEST_FAILED);
            jsonObject.put("errmsg", e.getMessage());
            logger.error("client execute failed: ", e);
        }
        if (execute != null) {
           HttpEntity entity = execute.getEntity();
            try {
                String s = EntityUtils.toString(entity, "utf-8");
                jsonObject = JSON.parseObject(s);
            } catch (IOException e) {
                logger.error("entity parse failed: ", e);
            }
        }
        return jsonObject;
    }

    private static JSONObject getAppToken(String id, String secret) {
        String url = APP_TOKEN_URL + "?grant_type=client_credential&appid=" + id + "&secret=" + secret;
        return getRequest(url);
    }

    public static JSONObject getOpenId(String id, String secret, String code) {
        String openIdUrl = "https://api.weixin.qq.com/sns/jscode2session?appid=" + id
                + "&secret=" + secret
                + "&js_code=" + code
                + "&grant_type=authorization_code";
        return getRequest(openIdUrl);
    }
}
