package hls.support.core.wechat.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

/**
 * Created with IntelliJ IDEA.
 * User: yang
 * Date: 2017-11-09
 * Time: 21:11
 */
public class WechatPicUtils {
    private static Logger logger = LoggerFactory.getLogger(WechatPicUtils.class);

    public static boolean png2Jpeg(File png, String jpegPath, Double scale) {
        // 指定生成的图片格式
        return picScale(png, jpegPath, scale, "jpg");
    }

    /**
     * 图片缩放
     *
     * @param src      源图片文件
     * @param savePath 缩放后的保存路径
     * @param scale    缩放比例
     * @param format   可为空，保存文件的格式
     * @return
     */
    public static boolean picScale(File src, String savePath, Double scale, String format) {
        return picScale(src, new File(savePath), scale, format);
    }

    /**
     * 图片缩放
     *
     * @param src    源图片文件
     * @param dist   缩放后的文件
     * @param scale  缩放比例
     * @param format 可为空，保存文件的格式
     * @return
     */
    public static boolean picScale(File src, File dist, Double scale, String format) {
        if (logger.isDebugEnabled()) {
            logger.debug("src file:{}, dist path: {}", src, dist);
        }
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(src);
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            if (scale != null && scale > 0) {
                width = (int) (width * scale);
                height = (int) (height * scale);
            }
            BufferedImage newBufferedImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
            newBufferedImage.createGraphics().drawImage(
                    bufferedImage.getScaledInstance(width, height, Image.SCALE_SMOOTH),
                    0,
                    0,
                    Color.WHITE,
                    null);
            // write to jpeg file
            if (format == null || format.trim().length() < 1) {
                String name = dist.getName();
                format = name.substring(name.lastIndexOf(".") + 1);
            }
            ImageIO.write(newBufferedImage, format, dist);
        } catch (IOException e) {
            logger.error("transfer pic failed: {}", e);
            return false;
        }
        return true;
    }

    public static boolean picScale(File src, String savePath, int width, int height, String format) {
        return picScale(src, new File(savePath), width, height, format);
    }

    public static boolean picScale(File src, File dist, int width, int height, String format) {
        if (logger.isDebugEnabled()) {
            logger.debug("src file:{}, dist file: {}, width: {}, height: {}", src, dist, width, height);
        }
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(src);
            BufferedImage newBufferedImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
            newBufferedImage.createGraphics().drawImage(
                    bufferedImage.getScaledInstance(width, height, Image.SCALE_SMOOTH),
                    0,
                    0,
                    Color.WHITE,
                    null);
            // write to jpeg file
            if (format == null || format.trim().length() < 1) {
                String name = dist.getName();
                format = name.substring(name.lastIndexOf(".") + 1);
            }
            ImageIO.write(newBufferedImage, format, dist);
        } catch (IOException e) {
            logger.error("transfer pic failed: {}", e);
            return false;
        }
        return true;
    }
}
