package hls.support.core.wechat.utils;

import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * @author: hty  Date: 2018/1/12 Time: 13:31
 */
public class WechatNotificationUtil {

    static Logger logger = LoggerFactory.getLogger(WechatNotificationUtil.class);

    /**
     * 替换需要的数据生成消息
     *
     * @param map
     * @param content
     **/
    public static String initMessage(String content, Map<String, Object> map) {
        if (content == null || map == null) {
            logger.error("The map does not contain keys which the map must have");
            return null;
        }
        String message = initKeys(content, map);
        return message;

    }

    /**
     * 替换参数
     *
     * @param map     存放替换值的map
     * @param content
     **/
    public static String initKeys(String content, Map map) {
        if (StringUtils.isEmpty(content) || MapUtils.isEmpty(map)) {
            logger.error("The param is null;");
            return null;
        }
        while (StringUtils.indexOf(content, "{") > 0 || StringUtils.indexOf(content, "}") > 0) {
            //截取{}中间的字符串作为参数名
            String str = StringUtils.substring(content, StringUtils.indexOf(content, "{") + 1, StringUtils.indexOf(content, "}"));
            if (map.containsKey(str)) {
                String param = (String) map.get(str);
                String replaceStr = "{" + str + "}";
                content = StringUtils.replace(content, replaceStr, param, 1);
            } else {
                logger.error("The map does not have the key {}", str);
                content = null;
                break;
            }
        }
        return content;
    }
}
