package hls.support.core.wechat.utils;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.*;

/**
 * 用于生成预览的小图
 * @author yangsong
 *
 */
public class SunECMSamllImage {

	public static BufferedImage resize(BufferedImage source, int targetW, int targetH) {
		// targetW，targetH分别表示目标长和宽    
		int type = source.getType();
		BufferedImage target = null;
		double sx = (double) targetW / source.getWidth();
		double sy = (double) targetH / source.getHeight();
		//这里想实现在targetW，targetH范围内实现等比缩放。如果不需要等比缩放    
		//则将下面的if else语句注释即可    
		if (sx > sy) {
			sx = sy;
			targetW = (int) (sx * source.getWidth());
		} else {
			sy = sx;
			targetH = (int) (sy * source.getHeight());
		}
		if (type == BufferedImage.TYPE_CUSTOM) { //handmade    
			ColorModel cm = source.getColorModel();
			WritableRaster raster = cm.createCompatibleWritableRaster(targetW, targetH);
			boolean alphaPremultiplied = cm.isAlphaPremultiplied();
			target = new BufferedImage(cm, raster, alphaPremultiplied, null);
		} else
			target = new BufferedImage(targetW, targetH, type);
		Graphics2D g = target.createGraphics();
		g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
		g.drawRenderedImage(source, AffineTransform.getScaleInstance(sx, sy));
		g.dispose();
		return target;
	}
    //原图生成小图
	public static void saveImageAsJpg(String fromFileStr, String saveToFileStr, int width, int hight) throws Exception {
		BufferedImage srcImage;
		String imgType = "JPEG";
		if (fromFileStr.toLowerCase().endsWith(".jpg")) {
			imgType = "jpg";
		}
		File saveFile = new File(saveToFileStr);
		File fromFile = new File(fromFileStr);
		srcImage = ImageIO.read(fromFile);
		if (width > 0 || hight > 0) {
			srcImage = resize(srcImage, width, hight);
		}
		ImageIO.write(srcImage, imgType, saveFile);

	}
	//小图＋大图
	public static void joinImages(String firstSrcImagePath,
		String secondSrcImagePath, String imageFormat, String toPath) throws Exception {
		BufferedInputStream firstin=null;
		BufferedInputStream sectin=null;
		BufferedOutputStream os=null;
		SequenceInputStream sis=null;
		firstin=new BufferedInputStream(new FileInputStream(firstSrcImagePath));
		sectin=new BufferedInputStream(new FileInputStream(secondSrcImagePath));
		os=new BufferedOutputStream(new FileOutputStream(toPath));
		sis=new SequenceInputStream(firstin,sectin);
		int tmp=0;
		while((tmp=sis.read())!=-1){
			os.write(tmp);
		}
		//os.flush();
		firstin.close();
		sectin.close();
		sis.close();
		os.close();
	}
}

