package hls.support.core.wechat.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.mybatis.entity.Example;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.mapper.WechatAccountMapper;
import hls.support.core.wechat.mapper.WechatEnterpriseAppMapper;
import hls.support.core.wechat.service.IWechatUserInfoService;
import hls.support.core.wechat.utils.WeChatUtils;
import hls.support.core.wechat.utils.WechatHttpUtils;
import hls.support.core.wechat.utils.WechatTokenUtils;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpUser;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by weck on 18/01/2018 6:09 PM
 */
@Service
public class WechatUserInfoServiceImpl implements IWechatUserInfoService {

    private static final String USER_TO_OPEN_URL = "https://qyapi.weixin.qq.com/cgi-bin/user/convert_to_openid";
    private static final String OPEN_TO_USER_URL = "https://qyapi.weixin.qq.com/cgi-bin/user/convert_to_userid";

    @Autowired
    private WechatEnterpriseAppMapper appMapper;

    @Autowired
    private WechatAccountMapper accountMapper;

    private Logger logger = LoggerFactory.getLogger(WechatUserInfoServiceImpl.class);

    @Value("#{configProperties['http.proxy.port']}")
    private Integer proxyPort;

    @Value("#{configProperties['http.proxy.host']}")
    private String proxyHost;

    @Override
    public Map<String, Object> getUserInfo(String code, String wxCode, IRequest requestCtx) {
        Map<String, Object> map = new HashMap<>();
        map.put("success", false);
        if (StringUtils.isEmpty(wxCode)) {
            map.put("errMsg", "wxCode can not be empty.");
            return map;
        }
        Example example = new Example(WechatEnterpriseApp.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("wxCode", wxCode);
        List<WechatEnterpriseApp> wechatEnterpriseApps = appMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(wechatEnterpriseApps)) {
            map.put("errMsg", "account can not be found.");
            return map;
        } else if (wechatEnterpriseApps.size() > 1) {
            map.put("errMsg", "account is not specified.");
            return map;
        }
        WechatEnterpriseApp app = wechatEnterpriseApps.get(0);
        WechatAccount account = accountMapper.selectByPrimaryKey(app.getAccountId());
        if (account == null) {
            map.put("errMsg", "internal data error.");
            return map;
        }
        String appId = account.getAppId();
        Integer type = account.getAccountType();
        String userId = "";
        String openId = "";
        String deviceId = "";
        if (type.equals(WechatAccount.CORP)) {
            WxCpService wxCpService = WeChatUtils.initWxCpService(appId, app.getSecret(), Integer.valueOf(app.getAgentId()), proxyHost, proxyPort);
            try {
                String[] res = wxCpService.getOauth2Service().getUserInfo(code);
                userId = res[0];
                deviceId = res[1];
            } catch (WxErrorException e) {
                logger.error("get user info failed from wechat server.", e);
                map.put("errMsg", "get user info failed from wechat server." + e.getMessage());
                return map;
            }
        } else if (type.equals(WechatAccount.SERV) || type.equals(WechatAccount.SUBS)) {
//            String getTokenUrl = "https://api.weixin.qq.com/sns/oauth2/access_token?appid="+appId+"&secret="+app.getSecret()+"&code="+code+"&grant_type=authorization_code";
//            JSONObject res = HttpRequestUtil.httpRequest(getTokenUrl,"GET",null);
            WxMpService wxMpService = WeChatUtils.initWxMpService(appId, account.getSecret(), proxyHost, proxyPort);
            try {
                WxMpOAuth2AccessToken wxMpOAuth2AccessToken = wxMpService.oauth2getAccessToken(code);
                openId = wxMpOAuth2AccessToken.getOpenId();
            } catch (WxErrorException e) {
                logger.error("get user info failed from wechat server.", e);
                map.put("errMsg", "get user info failed from wechat server." + e.getMessage());
                return map;
            }
        } else {
            map.put("errMsg", "internal data error");
            return map;
        }
        map.put("success", true);
        map.put("userId", userId);
        map.put("openId", openId);
        map.put("deviceId", deviceId);
        return map;
    }

    @Override
    public JSONObject converToOpenId(String userId, String wxCode, IRequest request) {
        JSONObject json = new JSONObject();
        json.put("success", false);
        if (StringUtils.isEmpty(wxCode)) {
            json.put("errMsg", "wxCode can not be empty.");
            return json;
        }
        Example example = new Example(WechatEnterpriseApp.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("wxCode", wxCode);
        List<WechatEnterpriseApp> wechatEnterpriseApps = appMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(wechatEnterpriseApps)) {
            json.put("errMsg", "account can not be found.");
            return json;
        } else if (wechatEnterpriseApps.size() > 1) {
            json.put("errMsg", "account is not specified.");
            return json;
        }
        WechatEnterpriseApp app = wechatEnterpriseApps.get(0);
        WechatAccount account = accountMapper.selectByPrimaryKey(app.getAccountId());
        if (account == null) {
            json.put("errMsg", "internal data error.");
            return json;
        }


        String appId = account.getAppId();
        String appSecret = account.getSecret();
        String agentId = app.getAgentId();
        Map<String, Object> paraMap = new HashMap<>();
        paraMap.put("userid", userId);
        paraMap.put("agentId", agentId);

        JSONObject tokenObject = WechatTokenUtils.getToken(appId, appSecret, "corp");

        String accessToken;
        try {
            accessToken = tokenObject.get("access_token").toString();
        } catch (Exception e) {
            json.put("errMsg", "get access_token error.");
            return json;
        }

        String url = USER_TO_OPEN_URL + "?access_token=" + accessToken;

        json = WechatHttpUtils.postForJson(url, paraMap);
        json.put("success", true);
        return json;

    }


    @Override
    public JSONObject converToUserId(String openId, String wxCode, IRequest request) {
        JSONObject json = new JSONObject();
        json.put("success", false);
        if (StringUtils.isEmpty(wxCode)) {
            json.put("errMsg", "wxCode can not be empty.");
            return json;
        }
        Example example = new Example(WechatEnterpriseApp.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("wxCode", wxCode);
        List<WechatEnterpriseApp> wechatEnterpriseApps = appMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(wechatEnterpriseApps)) {
            json.put("errMsg", "account can not be found.");
            return json;
        } else if (wechatEnterpriseApps.size() > 1) {
            json.put("errMsg", "account is not specified.");
            return json;
        }
        WechatEnterpriseApp app = wechatEnterpriseApps.get(0);
        WechatAccount account = accountMapper.selectByPrimaryKey(app.getAccountId());
        if (account == null) {
            json.put("errMsg", "internal data error.");
            return json;
        }
        String appId = account.getAppId();
        String appSecret = account.getSecret();
        Map<String, Object> paraMap = new HashMap<>();
        paraMap.put("openid", openId);

        JSONObject tokenObject = WechatTokenUtils.getToken(appId, appSecret, "corp");

        String accessToken;
        try {
            accessToken = tokenObject.get("access_token").toString();
        } catch (Exception e) {
            json.put("errMsg", "get access_token error.");
            return json;
        }

        String url = OPEN_TO_USER_URL + "?access_token=" + accessToken;

        json = WechatHttpUtils.postForJson(url, paraMap);
        json.put("success", true);
        return json;

    }

    @Override
    public Map<String, Object> getById(String userId, String wxCode) {
        Map<String, Object> map = new HashMap<>();
        WxCpUser user = new WxCpUser();
        map.put("success", false);
        if (StringUtils.isEmpty(wxCode)) {
            map.put("errMsg", "wxCode can not be empty.");
            return map;
        }
        Example example = new Example(WechatEnterpriseApp.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("wxCode", wxCode);
        List<WechatEnterpriseApp> wechatEnterpriseApps = appMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(wechatEnterpriseApps)) {
            map.put("errMsg", "account can not be found.");
            return map;
        } else if (wechatEnterpriseApps.size() > 1) {
            map.put("errMsg", "account is not specified.");
            return map;
        }
        WechatEnterpriseApp app = wechatEnterpriseApps.get(0);
        WechatAccount account = accountMapper.selectByPrimaryKey(app.getAccountId());
        if (account == null) {
            map.put("errMsg", "internal data error.");
            return map;
        }
        String appId = account.getAppId();
        WxCpService wxCpService = WeChatUtils.initWxCpService(appId, app.getSecret(), Integer.valueOf(app.getAgentId()), proxyHost, proxyPort);
        try {
            user =  wxCpService.getUserService().getById(userId);
        } catch (WxErrorException e) {
            logger.error("get user info failed from wechat server.", e);
            map.put("errMsg", "get user info failed from wechat server." + e.getMessage());
            return map;
        }
        map.put("success", true);
        map.put("user", user);
        return map;
    }
}
