package hls.support.core.wechat.service.impl;

import com.hand.hap.core.IRequest;
import hls.support.core.responseMessage.service.IResponseMessageService;
import hls.support.core.wechat.components.MessageHandler;
import hls.support.core.wechat.components.MessageMatcher;
import hls.support.core.wechat.dto.WechatAccount;
import hls.support.core.wechat.dto.WechatEnterpriseApp;
import hls.support.core.wechat.mapper.WechatAccountMapper;
import hls.support.core.wechat.mapper.WechatEnterpriseAppMapper;
import hls.support.core.wechat.service.WechatAcceptAutoRecoverService;
import hls.support.core.wechat.utils.WeChatUtils;
import me.chanjar.weixin.mp.api.WxMpMessageRouter;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.util.xml.XStreamTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

@Service
@Transactional(rollbackFor = Exception.class)
public class WechatAcceptAutoRecoverServiceImpl implements WechatAcceptAutoRecoverService {

    private static Logger logger = LoggerFactory.getLogger(WechatAcceptAutoRecoverServiceImpl.class);

    @Autowired
    private WechatEnterpriseAppMapper appMapper;

    @Autowired
    private WechatAccountMapper accountMapper;

    @Autowired
    private IResponseMessageService responseMessageService;

    @Value("#{configProperties['http.proxy.port']}")
    private Integer proxyPort;

    @Value("#{configProperties['http.proxy.host']}")
    private String proxyHost;

    @Override
    public void filterSubscribe(HttpServletRequest request, HttpServletResponse response, IRequest iRequest) {
        WxMpXmlMessage inMessage;
        try {
            inMessage = WxMpXmlMessage.fromXml(request.getInputStream());
        } catch (Throwable t) {
            logger.error("get xml message failed.", t);
            return;
        }
        // 返回消息给微信服务器
        PrintWriter out = null;
        try {
            out = response.getWriter();
        } catch (IOException e) {
            e.printStackTrace();
        }
        String toUserName = inMessage.getToUser();
        String fromUserName = inMessage.getFromUser();
        String msgType = inMessage.getMsgType();
        String event = inMessage.getEvent();
        WechatEnterpriseApp wea = new WechatEnterpriseApp();
        wea.setWechatId(toUserName);
        List<WechatEnterpriseApp> apps = appMapper.select(wea);
        WechatEnterpriseApp targetApp = apps.get(0);
        WechatAccount targetAccount = accountMapper.selectByPrimaryKey(targetApp.getAccountId());
        WxMpXmlMessage wx = null;
        try {
            wx = XStreamTransformer.fromXml(WxMpXmlMessage.class, request.getInputStream());
            WxMpService wxMpService = WeChatUtils.initWxMpService(targetAccount.getAppId(), targetAccount.getSecret(), proxyHost, proxyPort);
            //定义规则
            WxMpMessageRouter wxMpMessageRouter = new WxMpMessageRouter(wxMpService);
            wxMpMessageRouter.rule()
                    .matcher(new MessageMatcher())
                    .handler(new MessageHandler())
                    .end();
            // 把消息传递给路由器进行处理
            WxMpXmlOutMessage xmlOutMsg = wxMpMessageRouter.route(wx);
            if (xmlOutMsg != null) {
                out.print(xmlOutMsg.toXml());
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            out.close();
        }

    }
}
